/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.prng;

import gnu.crypto.Registry;
import gnu.crypto.prng.BasePRNG;
import gnu.crypto.prng.ICMGenerator;
import gnu.crypto.prng.IRandom;
import gnu.crypto.prng.MDGenerator;
import gnu.crypto.prng.UMacGenerator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class PRNGFactory
implements Registry {
    private PRNGFactory() {
    }

    public static final IRandom getInstance(String prng) {
        if (prng == null) {
            return null;
        }
        prng = prng.trim();
        BasePRNG result = null;
        if (prng.equalsIgnoreCase("icm")) {
            result = new ICMGenerator();
        } else if (prng.equalsIgnoreCase("md")) {
            result = new MDGenerator();
        } else if (prng.equalsIgnoreCase("umac-kdf")) {
            result = new UMacGenerator();
        }
        return result;
    }

    public static final Set getNames() {
        HashSet<String> hs = new HashSet<String>();
        hs.add("icm");
        hs.add("md");
        hs.add("umac-kdf");
        return Collections.unmodifiableSet(hs);
    }
}

