/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.model.internal.bundle;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.region.Region;
import org.eclipse.virgo.kernel.model.ArtifactState;
import org.eclipse.virgo.kernel.model.internal.AbstractArtifact;
import org.eclipse.virgo.kernel.model.internal.SpringContextAccessor;
import org.eclipse.virgo.kernel.osgi.framework.PackageAdminUtil;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.nano.serviceability.enforcement.NonNullAssertionEnforcer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NativeBundleArtifact
extends AbstractArtifact {
    static final String TYPE = "bundle";
    private final Logger logger;
    private final PackageAdminUtil packageAdminUtil;
    private final Bundle bundle;
    private final SpringContextAccessor springContextAccessor;

    public NativeBundleArtifact(@NonNull BundleContext bundleContext, @NonNull PackageAdminUtil packageAdminUtil, @NonNull Bundle bundle, @NonNull Region region, @NonNull SpringContextAccessor springContextAccessor) {
        SpringContextAccessor springContextAccessor2 = springContextAccessor;
        Region region2 = region;
        Bundle bundle2 = bundle;
        PackageAdminUtil packageAdminUtil2 = packageAdminUtil;
        BundleContext bundleContext2 = bundleContext;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)bundleContext2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)packageAdminUtil2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$3$438bd8c1((Object)bundle2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$4$c122b91c((Object)region2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$5$e9cfb671((Object)springContextAccessor2);
        super(bundleContext, TYPE, bundle.getSymbolicName(), bundle.getVersion(), region);
        try {
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.packageAdminUtil = packageAdminUtil;
            this.bundle = bundle;
            this.springContextAccessor = springContextAccessor;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public ArtifactState getState() {
        try {
            return NativeBundleArtifact.mapBundleState(this.bundle.getState());
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public Map<String, String> getProperties() {
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("Bundle Id", String.valueOf(this.bundle.getBundleId()));
            properties.put("Spring", String.valueOf(this.springContextAccessor.isSpringPowered(this.bundle)));
            return Collections.unmodifiableMap(properties);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public boolean refresh() {
        try {
            try {
                this.bundle.update();
                this.packageAdminUtil.synchronouslyRefreshPackages(new Bundle[]{this.bundle});
                return true;
            }
            catch (BundleException e) {
                this.logger.error("Unable to update bundle '{}:{}'", (Object)this.bundle.getSymbolicName(), (Object)this.bundle.getVersion());
                throw new RuntimeException(String.format("Unable to update bundle '%s:%s'", this.bundle.getSymbolicName(), this.bundle.getVersion()), e);
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void start() {
        try {
            try {
                this.bundle.start();
            }
            catch (BundleException e) {
                this.logger.error("Unable to start bundle '{}:{}'", (Object)this.bundle.getSymbolicName(), (Object)this.bundle.getVersion());
                throw new RuntimeException(String.format("Unable to start bundle '%s:%s'", this.bundle.getSymbolicName(), this.bundle.getVersion()), e);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void stop() {
        try {
            try {
                this.bundle.stop();
            }
            catch (BundleException e) {
                this.logger.error("Unable to stop bundle '{}:{}'", (Object)this.bundle.getSymbolicName(), (Object)this.bundle.getVersion());
                throw new RuntimeException(String.format("Unable to stop bundle '%s:%s'", this.bundle.getSymbolicName(), this.bundle.getVersion()), e);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void uninstall() {
        try {
            try {
                this.bundle.uninstall();
            }
            catch (BundleException e) {
                this.logger.error("Unable to uninstall bundle '{}:{}'", (Object)this.bundle.getSymbolicName(), (Object)this.bundle.getVersion());
                throw new RuntimeException(String.format("Unable to uninstall bundle '%s:%s'", this.bundle.getSymbolicName(), this.bundle.getVersion()), e);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static ArtifactState mapBundleState(int state) {
        try {
            if (1 == state) {
                return ArtifactState.UNINSTALLED;
            }
            if (2 == state) {
                return ArtifactState.INSTALLED;
            }
            if (4 == state) {
                return ArtifactState.RESOLVED;
            }
            if (8 == state) {
                return ArtifactState.STARTING;
            }
            if (16 == state) {
                return ArtifactState.STOPPING;
            }
            if (32 == state) {
                return ArtifactState.ACTIVE;
            }
            throw new IllegalArgumentException(String.format("Unknown bundle state '%d'", state));
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

