/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.data;

import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.properties.data.FolderNamingConventionPropertyData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class FolderBuildPropertyData {
    public static final String QUALIFIER = "org.eclipse.titan.designer.Properties.Folder";
    public static final String FOLDERRESOURCEXMLNODE = "FolderResource";
    public static final String FOLDERPATHXMLNODE = "FolderPath";
    public static final String FOLDERPROPERTIESXMLNODE = "FolderProperties";
    public static final String CONTRALSTORAGEXMLNODE = "CentralStorage";
    public static final String EXCLUDEFROMBUILDXMLNODE = "ExcludeFromBuild";
    public static final String TRUE_STRING = "true";
    public static final String FALSE_STRING = "false";
    public static final String CENTRAL_STORAGE_PROPERTY = "centralStorage";
    public static final String EXCLUDE_FROM_BUILD_PROPERTY = "excludeFromBuild";

    private FolderBuildPropertyData() {
    }

    public static void removeTITANAttributes(IFolder folder) {
        try {
            folder.setPersistentProperty(new QualifiedName(QUALIFIER, CENTRAL_STORAGE_PROPERTY), null);
            folder.setPersistentProperty(new QualifiedName(QUALIFIER, EXCLUDE_FROM_BUILD_PROPERTY), null);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While removing properties of `" + folder.getName() + "'"), (Throwable)e);
        }
    }

    private static String getPropertyValue(IFolder folder, String property) {
        String temp = null;
        try {
            temp = folder.getPersistentProperty(new QualifiedName(QUALIFIER, property));
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While getting property `" + property + "' of `" + folder.getName() + "'"), (Throwable)e);
        }
        if (!TRUE_STRING.equals(temp)) {
            temp = FALSE_STRING;
        }
        return temp;
    }

    private static void setPropertyValue(IFolder folder, String property, String value) {
        try {
            folder.setPersistentProperty(new QualifiedName(QUALIFIER, property), TRUE_STRING.equals(value) ? TRUE_STRING : FALSE_STRING);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While setting property `" + property + "' of `" + folder.getName() + "'"), (Throwable)e);
        }
    }

    public static boolean hasDefaultProperties(IFolder folder) {
        return FALSE_STRING.equals(FolderBuildPropertyData.getPropertyValue(folder, CENTRAL_STORAGE_PROPERTY)) && FALSE_STRING.equals(FolderBuildPropertyData.getPropertyValue(folder, EXCLUDE_FROM_BUILD_PROPERTY)) && FolderNamingConventionPropertyData.hasDefaultProperties(folder);
    }

    public static Element saveFolderProperties(Document document, IFolder folder) {
        Element root = document.createElement(FOLDERRESOURCEXMLNODE);
        Element folderPath = document.createElement(FOLDERPATHXMLNODE);
        folderPath.appendChild(document.createTextNode(folder.getProjectRelativePath().toPortableString()));
        root.appendChild(folderPath);
        Element folderProperties = document.createElement(FOLDERPROPERTIESXMLNODE);
        Element folderProperty = document.createElement(CONTRALSTORAGEXMLNODE);
        folderProperty.appendChild(document.createTextNode(FolderBuildPropertyData.getPropertyValue(folder, CENTRAL_STORAGE_PROPERTY)));
        folderProperties.appendChild(folderProperty);
        folderProperty = document.createElement(EXCLUDEFROMBUILDXMLNODE);
        folderProperty.appendChild(document.createTextNode(FolderBuildPropertyData.getPropertyValue(folder, EXCLUDE_FROM_BUILD_PROPERTY)));
        folderProperties.appendChild(folderProperty);
        root.appendChild(folderProperties);
        if (!FolderNamingConventionPropertyData.hasDefaultProperties(folder)) {
            root.appendChild(FolderNamingConventionPropertyData.saveProperties(document, folder));
        }
        return root;
    }

    public static void loadFolderProperties(Node node, IProject project, Set<IFolder> notYetReachedFolders, Set<IResource> changedResources) {
        NodeList resourceList = node.getChildNodes();
        Node folderPathIndex = null;
        Node folderPropertiesIndex = null;
        Node namingConventionIndex = null;
        int size = resourceList.getLength();
        for (int i = 0; i < size; ++i) {
            Node tempNode = resourceList.item(i);
            String nodeName = tempNode.getNodeName();
            if (FOLDERPATHXMLNODE.equals(nodeName)) {
                folderPathIndex = tempNode;
                continue;
            }
            if (FOLDERPROPERTIESXMLNODE.equals(nodeName)) {
                folderPropertiesIndex = tempNode;
                continue;
            }
            if (!"NamingCoventions".equals(nodeName)) continue;
            namingConventionIndex = tempNode;
        }
        if (folderPathIndex == null || folderPropertiesIndex == null) {
            return;
        }
        String folderPath = folderPathIndex.getTextContent();
        if (!project.exists((IPath)new Path(folderPath))) {
            return;
        }
        IFolder folder = project.getFolder(folderPath);
        if (notYetReachedFolders.contains(folder)) {
            notYetReachedFolders.remove(folder);
        }
        NodeList folderProperties = folderPropertiesIndex.getChildNodes();
        int size2 = folderProperties.getLength();
        for (int i = 0; i < size2; ++i) {
            String value;
            String oldValue;
            Node property = folderProperties.item(i);
            if (CONTRALSTORAGEXMLNODE.equals(property.getNodeName())) {
                oldValue = FolderBuildPropertyData.getPropertyValue(folder, CENTRAL_STORAGE_PROPERTY);
                value = property.getTextContent();
                if (oldValue != null && oldValue.equals(value)) continue;
                changedResources.add((IResource)folder);
                FolderBuildPropertyData.setPropertyValue(folder, CENTRAL_STORAGE_PROPERTY, value);
                continue;
            }
            if (!EXCLUDEFROMBUILDXMLNODE.equals(property.getNodeName())) continue;
            oldValue = FolderBuildPropertyData.getPropertyValue(folder, EXCLUDE_FROM_BUILD_PROPERTY);
            value = property.getTextContent();
            if (oldValue != null && oldValue.equals(value)) continue;
            changedResources.add((IResource)folder);
            FolderBuildPropertyData.setPropertyValue(folder, EXCLUDE_FROM_BUILD_PROPERTY, value);
        }
        FolderNamingConventionPropertyData.loadProperties(namingConventionIndex, folder);
    }

    public static void loadDefaultProperties(IFolder folder, Set<IResource> changedResources) {
        String oldValue = FolderBuildPropertyData.getPropertyValue(folder, CENTRAL_STORAGE_PROPERTY);
        if (oldValue == null || !oldValue.equals(FALSE_STRING)) {
            changedResources.add((IResource)folder);
            FolderBuildPropertyData.setPropertyValue(folder, CENTRAL_STORAGE_PROPERTY, FALSE_STRING);
        }
        if ((oldValue = FolderBuildPropertyData.getPropertyValue(folder, EXCLUDE_FROM_BUILD_PROPERTY)) == null || !oldValue.equals(FALSE_STRING)) {
            changedResources.add((IResource)folder);
            FolderBuildPropertyData.setPropertyValue(folder, EXCLUDE_FROM_BUILD_PROPERTY, FALSE_STRING);
        }
        FolderNamingConventionPropertyData.loadProperties(null, folder);
    }

    public static Node copyFolderProperties(Node sourceNode, Document document, IProject project, Set<String> notYetReachedFolders, boolean saveDefaultValues) {
        String folderPath = null;
        String excludeValue = FALSE_STRING;
        String centralStorage = FALSE_STRING;
        Node namingConventionNode = null;
        IFolder folder = null;
        if (sourceNode != null) {
            NodeList resourceList = sourceNode.getChildNodes();
            int folderPathIndex = -1;
            int folderPropertiesIndex = -1;
            int size = resourceList.getLength();
            for (int i = 0; i < size; ++i) {
                String nodeName = resourceList.item(i).getNodeName();
                if (FOLDERPATHXMLNODE.equals(nodeName)) {
                    folderPathIndex = i;
                    continue;
                }
                if (FOLDERPROPERTIESXMLNODE.equals(nodeName)) {
                    folderPropertiesIndex = i;
                    continue;
                }
                if (!"NamingCoventions".equals(nodeName)) continue;
                namingConventionNode = resourceList.item(i);
            }
            if (folderPathIndex == -1) {
                return null;
            }
            folderPath = resourceList.item(folderPathIndex).getTextContent();
            if (!project.exists((IPath)new Path(folderPath))) {
                return null;
            }
            notYetReachedFolders.remove(folderPath);
            folder = project.getFolder(folderPath);
            if (folderPropertiesIndex != -1) {
                NodeList folderProperties = resourceList.item(folderPropertiesIndex).getChildNodes();
                int size2 = folderProperties.getLength();
                for (int i = 0; i < size2; ++i) {
                    Node property = folderProperties.item(i);
                    if (CONTRALSTORAGEXMLNODE.equals(property.getNodeName())) {
                        centralStorage = property.getTextContent();
                        if (FALSE_STRING.equals(centralStorage) || TRUE_STRING.equals(centralStorage)) continue;
                        centralStorage = FALSE_STRING;
                        continue;
                    }
                    if (!EXCLUDEFROMBUILDXMLNODE.equals(property.getNodeName()) || FALSE_STRING.equals(excludeValue = property.getTextContent()) || TRUE_STRING.equals(excludeValue)) continue;
                    excludeValue = FALSE_STRING;
                }
            }
        }
        if (!saveDefaultValues && FALSE_STRING.equals(excludeValue) && FALSE_STRING.equals(centralStorage) && namingConventionNode == null) {
            return null;
        }
        Element root = document.createElement(FOLDERRESOURCEXMLNODE);
        Element filePathNode = document.createElement(FOLDERPATHXMLNODE);
        filePathNode.appendChild(document.createTextNode(folderPath));
        root.appendChild(filePathNode);
        Element fileProperties = document.createElement(FOLDERPROPERTIESXMLNODE);
        if (saveDefaultValues || !FALSE_STRING.equals(excludeValue)) {
            Element excludeFromBuild = document.createElement(EXCLUDEFROMBUILDXMLNODE);
            excludeFromBuild.appendChild(document.createTextNode(excludeValue));
            fileProperties.appendChild(excludeFromBuild);
        }
        if (saveDefaultValues || !FALSE_STRING.equals(centralStorage)) {
            Element centralStorageNode = document.createElement(CENTRAL_STORAGE_PROPERTY);
            centralStorageNode.appendChild(document.createTextNode(centralStorage));
            fileProperties.appendChild(centralStorageNode);
        }
        if (saveDefaultValues || namingConventionNode != null && folder != null) {
            Element tempNode = FolderNamingConventionPropertyData.copyProperties(namingConventionNode, document, saveDefaultValues);
            fileProperties.appendChild(tempNode);
        }
        root.appendChild(fileProperties);
        return root;
    }

    public static Node copyDefaultFolderProperties(Document document, IFolder folder) {
        Element root = document.createElement(FOLDERRESOURCEXMLNODE);
        Element filePath = document.createElement(FOLDERPATHXMLNODE);
        filePath.appendChild(document.createTextNode(folder.getProjectRelativePath().toPortableString()));
        root.appendChild(filePath);
        Element fileProperties = document.createElement(FOLDERPROPERTIESXMLNODE);
        Element excludeFromBuild = document.createElement(EXCLUDEFROMBUILDXMLNODE);
        excludeFromBuild.appendChild(document.createTextNode(FALSE_STRING));
        fileProperties.appendChild(excludeFromBuild);
        Element centralStorage = document.createElement(CENTRAL_STORAGE_PROPERTY);
        centralStorage.appendChild(document.createTextNode(FALSE_STRING));
        fileProperties.appendChild(centralStorage);
        Element tempNode = FolderNamingConventionPropertyData.copyProperties(null, document, true);
        fileProperties.appendChild(tempNode);
        root.appendChild(fileProperties);
        return root;
    }
}

