/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.views.executormonitor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.titan.executor.Activator;
import org.eclipse.titan.executor.executors.BaseExecutor;
import org.eclipse.titan.executor.executors.ITreeLeaf;
import org.eclipse.titan.executor.executors.TreeBranch;
import org.eclipse.titan.executor.executors.TreeLeaf;
import org.eclipse.titan.executor.graphics.ImageCache;
import org.eclipse.titan.executor.views.executormonitor.ExecutorMonitorContentProvider;
import org.eclipse.titan.executor.views.executormonitor.ExecutorMonitorLabelProvider;
import org.eclipse.titan.executor.views.executormonitor.ExecutorStorage;
import org.eclipse.titan.executor.views.executormonitor.LaunchElement;
import org.eclipse.titan.executor.views.executormonitor.LaunchStorage;
import org.eclipse.titan.executor.views.executormonitor.LaunchesListener;
import org.eclipse.titan.executor.views.executormonitor.MainControllerElement;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.part.ViewPart;

public final class ExecutorMonitorView
extends ViewPart {
    public static final String EXECUTORMONITOR_VIEW_ID = "org.eclipse.titan.executor.views.executorMonitor.ExecutorMonitorView";
    public static final String SINGLE_MODE_LAUNCHCONFIGURATION_ID = "org.eclipse.titan.executor.executors.single.LaunchConfigurationDelegate";
    public static final String MCTR_CLI_MODE_LAUNCHCONFIGURATION_ID = "org.eclipse.titan.executor.executors.mctr.cli.LaunchConfigurationDelegate";
    public static final String JNI_MODE_LAUNCHCONFIGURATION_ID = "org.eclipse.titan.executor.executors.jni.LaunchConfigurationDelegate";
    public static final String NATIVE_JAVA_LAUNCHCONFIGURATION_ID = "org.eclipse.titan.executor.executors.java_mctr.LaunchConfigurationDelegate";
    public static final ILaunchConfigurationType MCTR_CLI_LAUNCHCONFIGURATION_TYPE = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.titan.executor.executors.mctr.cli.LaunchConfigurationDelegate");
    public static final ILaunchConfigurationType SINGLE_LAUNCHCONFIGURATION_TYPE = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.titan.executor.executors.single.LaunchConfigurationDelegate");
    public static final ILaunchConfigurationType JNI_LAUNCHCONFIGURATION_TYPE = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.titan.executor.executors.jni.LaunchConfigurationDelegate");
    public static final ILaunchConfigurationType NATIVE_JAVA_LAUNCHCONFIGURATION_TYPE = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.titan.executor.executors.java_mctr.LaunchConfigurationDelegate");
    private TreeViewer viewer;
    private MenuManager manager;
    private ExecutorMonitorContentProvider contentProvider;
    private ExecutorMonitorLabelProvider labelProvider;
    private ILaunchesListener2 launchListener;
    private ISelectionChangedListener selectionChangedListener;
    private TreeBranch root;
    private Action terminateSelectedAction;
    private Action terminateAllAction;
    private Action removeSelectedAction;
    private Action removeAllTerminatedAction;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 768);
        this.contentProvider = new ExecutorMonitorContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new ExecutorMonitorLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.createActions();
        this.manager = new MenuManager("menuManager");
        this.createEmptyContextMenu();
        this.createToolBar();
        Activator.setMainView(this);
        this.viewer.setInput((Object)this.getInitialInput());
        this.viewer.expandToLevel(2);
        this.updateActions();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.launchListener = new LaunchesListener(this);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this.launchListener);
        this.selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ITreeLeaf element = (ITreeLeaf)selection.getFirstElement();
                ExecutorMonitorView.this.updateActions();
                if (null == element) {
                    return;
                }
                if (element instanceof LaunchElement) {
                    ExecutorMonitorView.this.createLauncherContextMenu();
                } else if (element instanceof MainControllerElement) {
                    ExecutorMonitorView.this.createExecutorContextMenu((MainControllerElement)element);
                    BaseExecutor executor = ((MainControllerElement)element).executor();
                    IProcess process = executor.getProcess();
                    if (null == process) {
                        return;
                    }
                    IConsole console = DebugUITools.getConsole((IProcess)process);
                    if (null == console) {
                        return;
                    }
                    IConsole[] consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
                    boolean exists = false;
                    for (IConsole console2 : consoles) {
                        if (!console2.equals(console)) continue;
                        exists = true;
                    }
                    if (!exists) {
                        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
                    }
                    ConsolePlugin.getDefault().getConsoleManager().showConsoleView(console);
                    ConsolePlugin.getDefault().getConsoleManager().refresh(console);
                } else {
                    ExecutorMonitorView.this.createEmptyContextMenu();
                }
            }
        };
        this.viewer.addSelectionChangedListener(this.selectionChangedListener);
    }

    public void dispose() {
        if (null != this.launchListener) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this.launchListener);
        }
        this.launchListener = null;
        this.viewer.removeSelectionChangedListener(this.selectionChangedListener);
        this.viewer = null;
        Activator.setMainView(null);
        this.contentProvider = null;
        this.labelProvider = null;
        this.removeSelectedAction = null;
        this.removeAllTerminatedAction = null;
        this.terminateSelectedAction = null;
        this.terminateAllAction = null;
        super.dispose();
    }

    public void setFocus() {
    }

    private void createActions() {
        this.terminateSelectedAction = new Action("Terminate selected"){

            public void run() {
                ExecutorMonitorView.this.terminateSelected();
            }
        };
        this.terminateSelectedAction.setToolTipText("Terminate Selected Launch");
        this.terminateSelectedAction.setImageDescriptor(ImageCache.getImageDescriptor("terminate_enabled.gif"));
        this.terminateSelectedAction.setDisabledImageDescriptor(ImageCache.getImageDescriptor("terminate_disabled.gif"));
        this.terminateSelectedAction.setEnabled(false);
        this.terminateAllAction = new Action("Terminate all launch"){

            public void run() {
                ExecutorMonitorView.this.terminateAll();
            }
        };
        this.terminateAllAction.setToolTipText("Terminate All Lanches");
        this.terminateAllAction.setImageDescriptor(ImageCache.getImageDescriptor("terminate_all_enabled.gif"));
        this.terminateAllAction.setDisabledImageDescriptor(ImageCache.getImageDescriptor("terminate_all_disabled.gif"));
        this.terminateAllAction.setEnabled(false);
        this.removeSelectedAction = new Action("Remove selected terminated launch"){

            public void run() {
                ExecutorMonitorView.this.removeSelected();
            }
        };
        this.removeSelectedAction.setToolTipText("Remove Selected Terminated Launch");
        this.removeSelectedAction.setImageDescriptor(ImageCache.getImageDescriptor("remove_enabled.gif"));
        this.removeSelectedAction.setDisabledImageDescriptor(ImageCache.getImageDescriptor("remove_disabled.gif"));
        this.removeSelectedAction.setEnabled(false);
        this.removeAllTerminatedAction = new Action("Remove All Terminated Launches"){

            public void run() {
                ExecutorMonitorView.this.removeAllTerminated();
            }
        };
        this.removeAllTerminatedAction.setToolTipText("Remove all terminated launches");
        this.removeAllTerminatedAction.setImageDescriptor(ImageCache.getImageDescriptor("remove_all_enabled.gif"));
        this.removeAllTerminatedAction.setDisabledImageDescriptor(ImageCache.getImageDescriptor("remove_all_disabled.gif"));
        this.removeAllTerminatedAction.setEnabled(false);
    }

    private void createEmptyContextMenu() {
        this.manager.removeAll();
        Menu menu = this.manager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private void createLauncherContextMenu() {
        this.manager.removeAll();
        this.manager.add((IAction)this.removeSelectedAction);
        this.manager.add((IAction)this.removeAllTerminatedAction);
        this.manager.add((IAction)this.terminateSelectedAction);
        this.manager.add((IAction)this.terminateAllAction);
        Menu menu = this.manager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private void createExecutorContextMenu(MainControllerElement element) {
        this.manager.removeAll();
        this.manager = element.executor().createMenu(this.manager);
        if (!this.manager.isEmpty()) {
            this.manager.add((IContributionItem)new Separator());
        }
        this.manager.add((IAction)this.removeSelectedAction);
        this.manager.add((IAction)this.terminateSelectedAction);
        Menu menu = this.manager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private void createToolBar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolbarManager.add((IAction)this.removeSelectedAction);
        toolbarManager.add((IAction)this.removeAllTerminatedAction);
        toolbarManager.add((IAction)this.terminateSelectedAction);
        toolbarManager.add((IAction)this.terminateAllAction);
    }

    public TreeBranch getRoot() {
        return this.root;
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    private TreeBranch getInitialInput() {
        ILaunch[] launches;
        this.root = new TreeBranch("root");
        for (ILaunch launche : launches = DebugPlugin.getDefault().getLaunchManager().getLaunches()) {
            LaunchElement launchElement;
            ILaunch launch = launche;
            ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
            if (!ExecutorMonitorView.isSupportedConfiguration(launchConfiguration)) continue;
            if (LaunchStorage.getLaunchElementMap().containsKey(launch)) {
                launchElement = LaunchStorage.getLaunchElementMap().get(launch);
            } else {
                launchElement = new LaunchElement(launchConfiguration.getName(), launch);
                LaunchStorage.registerLaunchElement(launchElement);
                ExecutorStorage.registerExecutorStorage(launchElement);
            }
            if (launch.isTerminated() && ExecutorStorage.getExecutorMap().containsKey(launch)) {
                launchElement.setTerminated();
                ExecutorStorage.getExecutorMap().get(launch).terminate(true);
            }
            this.root.addChildToEnd(launchElement);
        }
        return this.root;
    }

    private void terminateSelected() {
        if (null == this.viewer || this.viewer.getSelection().isEmpty()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (ITreeLeaf element : selection) {
            BaseExecutor executor;
            while (!(element instanceof LaunchElement)) {
                element = element.parent();
            }
            ILaunch launched = ((LaunchElement)element).launch();
            ILaunchConfiguration launchConfiguration = launched.getLaunchConfiguration();
            MainControllerElement mainController = 1 == ((LaunchElement)element).children().size() ? (MainControllerElement)((LaunchElement)element).children().get(0) : null;
            if (!ExecutorMonitorView.isSupportedConfiguration(launchConfiguration) || null == mainController || (executor = mainController.executor()).isTerminated()) continue;
            executor.terminate(false);
        }
        this.updateActions();
    }

    private void terminateAll() {
        if (null == this.viewer) {
            return;
        }
        for (int i = this.root.children().size() - 1; i >= 0; --i) {
            BaseExecutor executor;
            LaunchElement element = (LaunchElement)this.root.children().get(i);
            ILaunch launched = element.launch();
            ILaunchConfiguration launchConfiguration = launched.getLaunchConfiguration();
            MainControllerElement mainController = 1 == element.children().size() ? (MainControllerElement)element.children().get(0) : null;
            if (!ExecutorMonitorView.isSupportedConfiguration(launchConfiguration) || null == mainController || (executor = mainController.executor()).isTerminated()) continue;
            executor.terminate(false);
        }
        this.updateActions();
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ExecutorMonitorView.this.viewer.refresh((Object)ExecutorMonitorView.this.root);
            }
        });
    }

    private void removeSelected() {
        if (null == this.viewer || this.viewer.getSelection().isEmpty()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        this.viewer.getTree().setRedraw(false);
        for (ITreeLeaf element : selection) {
            BaseExecutor executor;
            while (!(element instanceof LaunchElement)) {
                element = element.parent();
            }
            ILaunch launched = ((LaunchElement)element).launch();
            ILaunchConfiguration launchConfiguration = launched.getLaunchConfiguration();
            MainControllerElement mainController = 1 == ((LaunchElement)element).children().size() ? (MainControllerElement)((LaunchElement)element).children().get(0) : null;
            if (!ExecutorMonitorView.isSupportedConfiguration(launchConfiguration) || null == mainController || !(executor = mainController.executor()).isTerminated()) continue;
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launched);
        }
        this.viewer.setSelection(null);
        this.updateActions();
        this.viewer.getTree().setRedraw(true);
    }

    private void removeAllTerminated() {
        if (null == this.viewer) {
            return;
        }
        for (int i = this.root.children().size() - 1; i >= 0; --i) {
            BaseExecutor executor;
            LaunchElement element = (LaunchElement)this.root.children().get(i);
            ILaunch launched = element.launch();
            if (null == launched) continue;
            ILaunchConfiguration launchConfiguration = launched.getLaunchConfiguration();
            MainControllerElement mainController = 1 == element.children().size() ? (MainControllerElement)element.children().get(0) : null;
            if (!ExecutorMonitorView.isSupportedConfiguration(launchConfiguration) || null == mainController || !(executor = mainController.executor()).isTerminated()) continue;
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launched);
        }
        this.viewer.setSelection(null);
        this.updateActions();
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ExecutorMonitorView.this.viewer.refresh((Object)ExecutorMonitorView.this.root);
            }
        });
    }

    public void updateActions() {
        if (this.viewer == null) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MainControllerElement mainController;
                ILaunch launched;
                IStructuredSelection selection = (IStructuredSelection)ExecutorMonitorView.this.viewer.getSelection();
                boolean foundTerminatable = false;
                boolean foundRemovable = false;
                for (ITreeLeaf element : ExecutorMonitorView.this.root.children()) {
                    launched = ((LaunchElement)element).launch();
                    mainController = ((LaunchElement)element).children().size() == 1 ? (MainControllerElement)((LaunchElement)element).children().get(0) : null;
                    ILaunchConfiguration launchConfiguration = launched.getLaunchConfiguration();
                    if (!ExecutorMonitorView.isSupportedConfiguration(launchConfiguration) || mainController == null) continue;
                    BaseExecutor executor = mainController.executor();
                    foundTerminatable |= !executor.isTerminated();
                    foundRemovable |= executor.isTerminated();
                }
                ExecutorMonitorView.this.terminateAllAction.setEnabled(foundTerminatable);
                ExecutorMonitorView.this.removeAllTerminatedAction.setEnabled(foundRemovable);
                ITreeLeaf element = (ITreeLeaf)selection.getFirstElement();
                if (element != null) {
                    while (!(element instanceof LaunchElement)) {
                        element = element.parent();
                    }
                    launched = ((LaunchElement)element).launch();
                    mainController = ((LaunchElement)element).children().size() == 1 ? (MainControllerElement)((LaunchElement)element).children().get(0) : null;
                    ILaunchConfiguration launchConfiguration = launched.getLaunchConfiguration();
                    if (ExecutorMonitorView.isSupportedConfiguration(launchConfiguration) && mainController != null) {
                        BaseExecutor executor = mainController.executor();
                        ExecutorMonitorView.this.terminateSelectedAction.setEnabled(!executor.isTerminated());
                        ExecutorMonitorView.this.removeSelectedAction.setEnabled(executor.isTerminated());
                    }
                } else {
                    ExecutorMonitorView.this.removeSelectedAction.setEnabled(false);
                    ExecutorMonitorView.this.terminateSelectedAction.setEnabled(false);
                }
            }
        });
    }

    public void refreshAll() {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ExecutorMonitorView.this.viewer.refresh();
                if (ExecutorMonitorView.this.root == null || ExecutorMonitorView.this.root.children().size() != 1) {
                    return;
                }
                ITreeLeaf element = ExecutorMonitorView.this.root.children().get(0);
                if (((LaunchElement)element).children().size() == 1) {
                    MainControllerElement mainController = (MainControllerElement)((LaunchElement)element).children().get(0);
                    ExecutorMonitorView.this.viewer.setSelection((ISelection)new StructuredSelection((Object)mainController), true);
                }
            }
        });
    }

    public void refreshIfSelected(final TreeLeaf element) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ITreeLeaf selectionElement;
                ITreeLeaf tempElement;
                if (ExecutorMonitorView.this.viewer == null || element == null) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)ExecutorMonitorView.this.viewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                for (tempElement = element; tempElement != null && !(tempElement instanceof MainControllerElement); tempElement = tempElement.parent()) {
                }
                for (selectionElement = (ITreeLeaf)selection.getFirstElement(); selectionElement != null && !(selectionElement instanceof MainControllerElement); selectionElement = selectionElement.parent()) {
                }
                if (tempElement == selectionElement) {
                    ExecutorMonitorView.this.viewer.setSelection((ISelection)selection, false);
                }
            }
        });
    }

    public void expandToLevel(final Object elementOrTreePath, final int level) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (ExecutorMonitorView.this.viewer != null) {
                    ExecutorMonitorView.this.viewer.expandToLevel(elementOrTreePath, level);
                }
            }
        });
    }

    public static boolean isSupportedConfiguration(ILaunchConfiguration launchConfiguration) {
        if (launchConfiguration == null) {
            return false;
        }
        try {
            if (NATIVE_JAVA_LAUNCHCONFIGURATION_TYPE.equals(launchConfiguration.getType())) {
                return !launchConfiguration.getAttribute("org.eclipse.titan.executor.singleModeJavaExecutor", false);
            }
            return JNI_LAUNCHCONFIGURATION_TYPE.equals(launchConfiguration.getType()) || SINGLE_LAUNCHCONFIGURATION_TYPE.equals(launchConfiguration.getType()) || MCTR_CLI_LAUNCHCONFIGURATION_TYPE.equals(launchConfiguration.getType());
        }
        catch (CoreException e) {
            return false;
        }
    }
}

