/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Testcase;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class UncommentedDefinition
extends BaseModuleCodeSmellSpotter {
    public UncommentedDefinition() {
        super(CodeSmellType.UNCOMMENTED_FUNCTION);
    }

    @Override
    public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        Definition s;
        if (node instanceof Definition && !(s = (Definition)node).hasDocumentComment()) {
            String msg = MessageFormat.format("The {0} {1} should have a comment", s.getAssignmentName(), s.getIdentifier().getDisplayName());
            problems.report(s.getIdentifier().getLocation(), msg);
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(3);
        ret.add(Def_Altstep.class);
        ret.add(Def_Function.class);
        ret.add(Def_Testcase.class);
        return ret;
    }
}

