/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.markers.handler.Marker;
import org.eclipse.titanium.markers.types.CodeSmellType;

public final class MarkerHandler {
    private final Map<IResource, List<Marker>> markersByResource = new HashMap<IResource, List<Marker>>();
    private final Map<CodeSmellType, List<Marker>> markersByType;

    public MarkerHandler(Map<IResource, List<Marker>> markers) {
        for (Map.Entry<IResource, List<Marker>> entry : markers.entrySet()) {
            for (Marker m : entry.getValue()) {
                IResource belongsTo = m.getResource();
                if (belongsTo == null) {
                    belongsTo = entry.getKey();
                }
                if (this.markersByResource.get(belongsTo) == null) {
                    this.markersByResource.put(belongsTo, new ArrayList());
                }
                this.markersByResource.get(belongsTo).add(m);
            }
        }
        this.markersByType = new HashMap<CodeSmellType, List<Marker>>();
    }

    public List<Marker> get(IResource res) {
        return this.markersByResource.get(res) == null ? Collections.emptyList() : Collections.unmodifiableList(this.markersByResource.get(res));
    }

    public List<Marker> get(CodeSmellType type) {
        if (this.markersByType.isEmpty()) {
            this.lazyInit();
        }
        return Collections.unmodifiableList(this.markersByType.get(type));
    }

    public int numberOfOccurrences(CodeSmellType type) {
        if (this.markersByType.isEmpty()) {
            this.lazyInit();
        }
        return this.markersByType.get(type).size();
    }

    private synchronized void lazyInit() {
        for (CodeSmellType type : CodeSmellType.values()) {
            this.markersByType.put(type, new ArrayList());
        }
        for (IResource res : this.markersByResource.keySet()) {
            for (Marker m : this.markersByResource.get(res)) {
                this.markersByType.get(m.getProblemType()).add(m);
            }
        }
    }

    public void showAll(IProject project) {
        IResource moduleResource;
        Module mod;
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser((IProject)project);
        Set knownModuleNames = projectSourceParser.getKnownModuleNames();
        org.eclipse.titan.designer.AST.MarkerHandler.markMarkersForRemoval((String)"org.eclipse.titanium.markers.CodeSmellMarker", (IResource)project);
        for (String moduleName : knownModuleNames) {
            mod = projectSourceParser.getModuleByName(moduleName);
            moduleResource = mod.getLocation().getFile();
            org.eclipse.titan.designer.AST.MarkerHandler.markMarkersForRemoval((String)"org.eclipse.titanium.markers.CodeSmellMarker", (IResource)moduleResource);
        }
        for (IResource res : this.markersByResource.keySet()) {
            this.refresh(res);
        }
        org.eclipse.titan.designer.AST.MarkerHandler.removeMarkedMarkers((String)"org.eclipse.titanium.markers.CodeSmellMarker", (IResource)project);
        for (String moduleName : knownModuleNames) {
            mod = projectSourceParser.getModuleByName(moduleName);
            moduleResource = mod.getLocation().getFile();
            org.eclipse.titan.designer.AST.MarkerHandler.removeMarkedMarkers((String)"org.eclipse.titanium.markers.CodeSmellMarker", (IResource)moduleResource);
        }
    }

    private void refresh(IResource res) {
        List<Marker> markers = this.markersByResource.get(res);
        if (markers != null) {
            for (Marker m : markers) {
                m.show();
            }
        }
    }

    public Map<IResource, List<Marker>> getMarkersByResource() {
        return this.markersByResource;
    }
}

