/**
 * Copyright (c) 2023 DB Netz AG and others.
 *  
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.Geodaten;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>ENUMTOP Anschluss</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.set.toolboxmodel.Geodaten.GeodatenPackage#getENUMTOPAnschluss()
 * @model extendedMetaData="name='ENUMTOP_Anschluss'"
 * @generated
 */
public enum ENUMTOPAnschluss implements Enumerator {
	/**
	 * The '<em><b>ENUMTOP Anschluss Ende</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMTOP_ANSCHLUSS_ENDE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMTOP_ANSCHLUSS_ENDE(0, "ENUMTOP_Anschluss_Ende", "Ende"),

	/**
	 * The '<em><b>ENUMTOP Anschluss Ende Bestdig</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMTOP_ANSCHLUSS_ENDE_BESTDIG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMTOP_ANSCHLUSS_ENDE_BESTDIG(1, "ENUMTOP_Anschluss_Ende_Bestdig", "Ende_Bestdig"),

	/**
	 * The '<em><b>ENUMTOP Anschluss Links</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMTOP_ANSCHLUSS_LINKS_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMTOP_ANSCHLUSS_LINKS(2, "ENUMTOP_Anschluss_Links", "Links"),

	/**
	 * The '<em><b>ENUMTOP Anschluss Meridiansprung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMTOP_ANSCHLUSS_MERIDIANSPRUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMTOP_ANSCHLUSS_MERIDIANSPRUNG(3, "ENUMTOP_Anschluss_Meridiansprung", "Meridiansprung"),

	/**
	 * The '<em><b>ENUMTOP Anschluss RB Grenze</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMTOP_ANSCHLUSS_RB_GRENZE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMTOP_ANSCHLUSS_RB_GRENZE(4, "ENUMTOP_Anschluss_RB_Grenze", "RB_Grenze"),

	/**
	 * The '<em><b>ENUMTOP Anschluss Rechts</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMTOP_ANSCHLUSS_RECHTS_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMTOP_ANSCHLUSS_RECHTS(5, "ENUMTOP_Anschluss_Rechts", "Rechts"),

	/**
	 * The '<em><b>ENUMTOP Anschluss Schnitt</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMTOP_ANSCHLUSS_SCHNITT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMTOP_ANSCHLUSS_SCHNITT(6, "ENUMTOP_Anschluss_Schnitt", "Schnitt"),

	/**
	 * The '<em><b>ENUMTOP Anschluss sonstige</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMTOP_ANSCHLUSS_SONSTIGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMTOP_ANSCHLUSS_SONSTIGE(7, "ENUMTOP_Anschluss_sonstige", "sonstige"),

	/**
	 * The '<em><b>ENUMTOP Anschluss Spitze</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMTOP_ANSCHLUSS_SPITZE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMTOP_ANSCHLUSS_SPITZE(8, "ENUMTOP_Anschluss_Spitze", "Spitze"),

	/**
	 * The '<em><b>ENUMTOP Anschluss Streckenwechsel</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMTOP_ANSCHLUSS_STRECKENWECHSEL_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMTOP_ANSCHLUSS_STRECKENWECHSEL(9, "ENUMTOP_Anschluss_Streckenwechsel", "Streckenwechsel"),

	/**
	 * The '<em><b>ENUMTOP Anschluss Verbindung</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMTOP_ANSCHLUSS_VERBINDUNG_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMTOP_ANSCHLUSS_VERBINDUNG(10, "ENUMTOP_Anschluss_Verbindung", "Verbindung");

	/**
	 * The '<em><b>ENUMTOP Anschluss Ende</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMTOP_ANSCHLUSS_ENDE
	 * @model name="ENUMTOP_Anschluss_Ende" literal="Ende"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMTOP_ANSCHLUSS_ENDE_VALUE = 0;

	/**
	 * The '<em><b>ENUMTOP Anschluss Ende Bestdig</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMTOP_ANSCHLUSS_ENDE_BESTDIG
	 * @model name="ENUMTOP_Anschluss_Ende_Bestdig" literal="Ende_Bestdig"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMTOP_ANSCHLUSS_ENDE_BESTDIG_VALUE = 1;

	/**
	 * The '<em><b>ENUMTOP Anschluss Links</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMTOP_ANSCHLUSS_LINKS
	 * @model name="ENUMTOP_Anschluss_Links" literal="Links"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMTOP_ANSCHLUSS_LINKS_VALUE = 2;

	/**
	 * The '<em><b>ENUMTOP Anschluss Meridiansprung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMTOP_ANSCHLUSS_MERIDIANSPRUNG
	 * @model name="ENUMTOP_Anschluss_Meridiansprung" literal="Meridiansprung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMTOP_ANSCHLUSS_MERIDIANSPRUNG_VALUE = 3;

	/**
	 * The '<em><b>ENUMTOP Anschluss RB Grenze</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMTOP_ANSCHLUSS_RB_GRENZE
	 * @model name="ENUMTOP_Anschluss_RB_Grenze" literal="RB_Grenze"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMTOP_ANSCHLUSS_RB_GRENZE_VALUE = 4;

	/**
	 * The '<em><b>ENUMTOP Anschluss Rechts</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMTOP_ANSCHLUSS_RECHTS
	 * @model name="ENUMTOP_Anschluss_Rechts" literal="Rechts"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMTOP_ANSCHLUSS_RECHTS_VALUE = 5;

	/**
	 * The '<em><b>ENUMTOP Anschluss Schnitt</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMTOP_ANSCHLUSS_SCHNITT
	 * @model name="ENUMTOP_Anschluss_Schnitt" literal="Schnitt"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMTOP_ANSCHLUSS_SCHNITT_VALUE = 6;

	/**
	 * The '<em><b>ENUMTOP Anschluss sonstige</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMTOP_ANSCHLUSS_SONSTIGE
	 * @model name="ENUMTOP_Anschluss_sonstige" literal="sonstige"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMTOP_ANSCHLUSS_SONSTIGE_VALUE = 7;

	/**
	 * The '<em><b>ENUMTOP Anschluss Spitze</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMTOP_ANSCHLUSS_SPITZE
	 * @model name="ENUMTOP_Anschluss_Spitze" literal="Spitze"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMTOP_ANSCHLUSS_SPITZE_VALUE = 8;

	/**
	 * The '<em><b>ENUMTOP Anschluss Streckenwechsel</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMTOP_ANSCHLUSS_STRECKENWECHSEL
	 * @model name="ENUMTOP_Anschluss_Streckenwechsel" literal="Streckenwechsel"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMTOP_ANSCHLUSS_STRECKENWECHSEL_VALUE = 9;

	/**
	 * The '<em><b>ENUMTOP Anschluss Verbindung</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMTOP_ANSCHLUSS_VERBINDUNG
	 * @model name="ENUMTOP_Anschluss_Verbindung" literal="Verbindung"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMTOP_ANSCHLUSS_VERBINDUNG_VALUE = 10;

	/**
	 * An array of all the '<em><b>ENUMTOP Anschluss</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ENUMTOPAnschluss[] VALUES_ARRAY =
		new ENUMTOPAnschluss[] {
			ENUMTOP_ANSCHLUSS_ENDE,
			ENUMTOP_ANSCHLUSS_ENDE_BESTDIG,
			ENUMTOP_ANSCHLUSS_LINKS,
			ENUMTOP_ANSCHLUSS_MERIDIANSPRUNG,
			ENUMTOP_ANSCHLUSS_RB_GRENZE,
			ENUMTOP_ANSCHLUSS_RECHTS,
			ENUMTOP_ANSCHLUSS_SCHNITT,
			ENUMTOP_ANSCHLUSS_SONSTIGE,
			ENUMTOP_ANSCHLUSS_SPITZE,
			ENUMTOP_ANSCHLUSS_STRECKENWECHSEL,
			ENUMTOP_ANSCHLUSS_VERBINDUNG,
		};

	/**
	 * A public read-only list of all the '<em><b>ENUMTOP Anschluss</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ENUMTOPAnschluss> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>ENUMTOP Anschluss</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMTOPAnschluss get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMTOPAnschluss result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUMTOP Anschluss</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMTOPAnschluss getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMTOPAnschluss result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUMTOP Anschluss</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMTOPAnschluss get(int value) {
		switch (value) {
			case ENUMTOP_ANSCHLUSS_ENDE_VALUE: return ENUMTOP_ANSCHLUSS_ENDE;
			case ENUMTOP_ANSCHLUSS_ENDE_BESTDIG_VALUE: return ENUMTOP_ANSCHLUSS_ENDE_BESTDIG;
			case ENUMTOP_ANSCHLUSS_LINKS_VALUE: return ENUMTOP_ANSCHLUSS_LINKS;
			case ENUMTOP_ANSCHLUSS_MERIDIANSPRUNG_VALUE: return ENUMTOP_ANSCHLUSS_MERIDIANSPRUNG;
			case ENUMTOP_ANSCHLUSS_RB_GRENZE_VALUE: return ENUMTOP_ANSCHLUSS_RB_GRENZE;
			case ENUMTOP_ANSCHLUSS_RECHTS_VALUE: return ENUMTOP_ANSCHLUSS_RECHTS;
			case ENUMTOP_ANSCHLUSS_SCHNITT_VALUE: return ENUMTOP_ANSCHLUSS_SCHNITT;
			case ENUMTOP_ANSCHLUSS_SONSTIGE_VALUE: return ENUMTOP_ANSCHLUSS_SONSTIGE;
			case ENUMTOP_ANSCHLUSS_SPITZE_VALUE: return ENUMTOP_ANSCHLUSS_SPITZE;
			case ENUMTOP_ANSCHLUSS_STRECKENWECHSEL_VALUE: return ENUMTOP_ANSCHLUSS_STRECKENWECHSEL;
			case ENUMTOP_ANSCHLUSS_VERBINDUNG_VALUE: return ENUMTOP_ANSCHLUSS_VERBINDUNG;
			default: return null;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ENUMTOPAnschluss(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ENUMTOPAnschluss
