/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.tools.launch.rwt.internal.shortcut;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.rap.tools.launch.rwt.internal.config.RWTLaunchConfig;
import org.eclipse.rap.tools.launch.rwt.internal.shortcut.TypeInspector;

class LaunchConfigFinder {
    private final LaunchConfigSelector launchConfigSelector;
    private List<ILaunchConfiguration> candidateConfigs;
    private IType type;

    LaunchConfigFinder(LaunchConfigSelector launchConfigSelector) {
        this.launchConfigSelector = launchConfigSelector;
    }

    ILaunchConfiguration forType(IType type) throws CoreException {
        this.initialize(type);
        this.collectCandidateLaunchConfigs();
        return this.chooseLaunchConfig();
    }

    private void initialize(IType type) {
        this.candidateConfigs = new LinkedList<ILaunchConfiguration>();
        this.type = type;
    }

    private void collectCandidateLaunchConfigs() throws CoreException {
        ILaunchConfiguration[] configs = LaunchConfigFinder.listExistingLaunchConfigs();
        int i = 0;
        while (i < configs.length) {
            RWTLaunchConfig config = new RWTLaunchConfig(configs[i]);
            if (this.isLaunchConfigForType(config)) {
                this.candidateConfigs.add(configs[i]);
            }
            ++i;
        }
    }

    private ILaunchConfiguration chooseLaunchConfig() {
        ILaunchConfiguration result = null;
        int candidateCount = this.candidateConfigs.size();
        if (candidateCount == 1) {
            result = this.candidateConfigs.get(0);
        } else if (candidateCount > 1) {
            result = this.launchConfigSelector.select(this.candidateConfigsAsArray());
        }
        return result;
    }

    private ILaunchConfiguration[] candidateConfigsAsArray() {
        ILaunchConfiguration[] result = new ILaunchConfiguration[this.candidateConfigs.size()];
        this.candidateConfigs.toArray(result);
        return result;
    }

    private boolean isLaunchConfigForType(RWTLaunchConfig config) throws JavaModelException {
        String projectName = this.type.getJavaProject().getElementName();
        boolean projectEquals = config.getProjectName().equals(projectName);
        boolean launchTargetEquals = RWTLaunchConfig.LaunchTarget.ENTRY_POINT.equals((Object)config.getLaunchTarget());
        boolean applicationEquals = config.getEntryPoint().equals(this.type.getFullyQualifiedName());
        if (new TypeInspector(this.type).isApplicationConfigurationType()) {
            launchTargetEquals = RWTLaunchConfig.LaunchTarget.APP_CONFIG.equals((Object)config.getLaunchTarget());
            applicationEquals = config.getAppConfig().equals(this.type.getFullyQualifiedName());
        }
        return projectEquals && launchTargetEquals && applicationEquals;
    }

    private static ILaunchConfiguration[] listExistingLaunchConfigs() throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        return launchManager.getLaunchConfigurations(RWTLaunchConfig.getType());
    }

    static interface LaunchConfigSelector {
        public ILaunchConfiguration select(ILaunchConfiguration[] var1);
    }
}

