/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ToolBarTab
extends ExampleTab {
    private ToolBar toolBar;
    private ToolItem pushItem1;
    private ToolItem pushItem2;
    private ToolItem pushItem3;
    private ToolItem checkItem;
    private ToolItem radioItem1;
    private ToolItem radioItem2;
    private ToolItem dropDownItem;
    private int count = 0;

    public ToolBarTab() {
        super("ToolBar");
    }

    @Override
    protected void createStyleControls(Composite parent) {
        this.createStyleButton("HORIZONTAL", 256);
        this.createStyleButton("VERTICAL", 512);
        this.createStyleButton("RIGHT", 131072);
        this.createStyleButton("BORDER", 2048);
        this.createStyleButton("FLAT", 0x800000);
        this.createStyleButton("NO_RADIO_GROUP", 0x400000);
        this.createOrientationButton();
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createFgColorButton();
        this.createBgColorButton();
        this.createBgImageButton();
        this.createFontChooser();
        this.createNewItemButton();
        this.createBadgeComposite(parent);
    }

    private void createNewItemButton() {
        Group group = new Group(this.styleComp, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText("New Item");
        Label label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        label.setText("Index:");
        final Text index = new Text((Composite)group, 18436);
        index.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        index.setText("0");
        Button addItemButton = new Button((Composite)group, 8);
        GridData gridData = new GridData(1, 0x1000000, false, false);
        gridData.horizontalSpan = 2;
        addItemButton.setLayoutData((Object)gridData);
        addItemButton.setText("Add Item");
        addItemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newIndex = Integer.parseInt(index.getText());
                ToolItem toolItem = new ToolItem(ToolBarTab.this.toolBar, 16, newIndex);
                toolItem.setText("Item");
            }
        });
    }

    @Override
    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new RowLayout());
        Image imageNewFile = this.loadImage("resources/newfile_wiz.gif");
        Image imagenewFolder = this.loadImage("resources/newfolder_wiz.gif");
        Image imageNewProj = this.loadImage("resources/newprj_wiz.gif");
        Image imageSearch = this.loadImage("resources/search_src.gif");
        this.toolBar = new ToolBar(parent, this.getStyle());
        ToolBarTab.addContextMenu(this.toolBar);
        this.registerControl((Control)this.toolBar);
        this.pushItem1 = new ToolItem(this.toolBar, 8);
        this.pushItem1.setText("new");
        this.pushItem1.setImage(imageNewFile);
        this.pushItem2 = new ToolItem(this.toolBar, 8);
        this.pushItem2.setText("open");
        this.pushItem2.setEnabled(false);
        this.pushItem2.setImage(imagenewFolder);
        new ToolItem(this.toolBar, 2);
        this.dropDownItem = new ToolItem(this.toolBar, 4);
        this.dropDownItem.setText("select");
        this.dropDownItem.setImage(imageNewProj);
        new ToolItem(this.toolBar, 2);
        ToolItem itemText = new ToolItem(this.toolBar, 2);
        Text text = new Text((Composite)this.toolBar, 2048);
        text.setText("A Text Field");
        itemText.setControl((Control)text);
        itemText.setWidth(100);
        this.checkItem = new ToolItem(this.toolBar, 32);
        this.checkItem.setImage(imageSearch);
        this.checkItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ToolBarTab.this.log("check changed" + event);
            }
        });
        this.radioItem1 = new ToolItem(this.toolBar, 16);
        this.radioItem1.setImage(imageSearch);
        this.radioItem2 = new ToolItem(this.toolBar, 16);
        SelectionAdapter radioSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ToolBarTab.this.log("radio changed - " + event);
            }
        };
        this.radioItem2.setImage(imageSearch);
        this.radioItem1.addSelectionListener((SelectionListener)radioSelectionListener);
        this.radioItem2.addSelectionListener((SelectionListener)radioSelectionListener);
        final Menu dropDownMenu = new Menu((Decorations)this.toolBar.getShell(), 8);
        int i = 0;
        while (i < 5) {
            MenuItem item = new MenuItem(dropDownMenu, 8);
            item.setText("Item " + this.count++);
            ++i;
        }
        this.dropDownItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 4) {
                    Point point = ToolBarTab.this.toolBar.toDisplay(event.x, event.y);
                    dropDownMenu.setOrientation(ToolBarTab.this.toolBar.getOrientation());
                    dropDownMenu.setLocation(point);
                    dropDownMenu.setVisible(true);
                }
            }
        });
        this.pushItem3 = new ToolItem(this.toolBar, 8);
        this.pushItem3.setText("w/o <image>");
    }

    private static void addContextMenu(ToolBar toolbar) {
        Menu menu = new Menu((Control)toolbar);
        MenuItem item = new MenuItem(menu, 8);
        item.setText("ToolBar context menu item");
        toolbar.setMenu(menu);
    }

    private void createBadgeComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        new Label(composite, 0).setText("Badge:");
        final Text text = new Text(composite, 2048);
        Listener setBadgeListener = new Listener(){

            public void handleEvent(Event event) {
                ToolBarTab.this.pushItem1.setData("org.eclipse.rap.rwt.badge", (Object)text.getText());
                ToolBarTab.this.pushItem2.setData("org.eclipse.rap.rwt.badge", (Object)text.getText());
                ToolBarTab.this.pushItem3.setData("org.eclipse.rap.rwt.badge", (Object)text.getText());
            }
        };
        Button button = new Button(composite, 8);
        button.setText("Set");
        button.addListener(13, setBadgeListener);
        text.addListener(14, setBadgeListener);
    }
}

