/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.IExpandBarAdapter;
import org.eclipse.swt.internal.widgets.IItemHolderAdapter;
import org.eclipse.swt.internal.widgets.ItemHolder;
import org.eclipse.swt.internal.widgets.MarkupUtil;
import org.eclipse.swt.internal.widgets.expandbarkit.ExpandBarLCA;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ExpandBar
extends Composite {
    ExpandItem focusItem;
    int spacing = 4;
    int allItemsHeight;
    private transient IExpandBarAdapter expandBarAdapter;
    private final ItemHolder<ExpandItem> itemHolder;
    private final ResizeListener resizeListener = new ResizeListener();

    public ExpandBar(Composite parent, int style) {
        super(parent, ExpandBar.checkStyle(style));
        this.addControlListener(this.resizeListener);
        this.itemHolder = new ItemHolder<ExpandItem>(ExpandItem.class);
    }

    public void addExpandListener(ExpandListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    public void removeExpandListener(ExpandListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.removeListener(17, listener);
        this.removeListener(18, listener);
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int height = 0;
        int width = 0;
        int itemCount = this.getItemCount();
        if ((wHint == -1 || hHint == -1) && itemCount > 0) {
            height += this.spacing;
            int i = 0;
            while (i < itemCount) {
                ExpandItem item = this.getItem(i);
                BoxDimensions itemBorder = item.getItemBorder();
                height += item.getHeaderHeight() + itemBorder.top + itemBorder.bottom;
                if (item.expanded) {
                    height += item.height;
                }
                height += this.spacing;
                int barPreferredWidth = item.getPreferredWidth() + 2 * this.spacing;
                width = Math.max(width, barPreferredWidth);
                ++i;
            }
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        BoxDimensions border = this.getBorder();
        width += border.left + border.right;
        height += border.top + border.bottom;
        if ((this.style & 0x200) != 0) {
            width += this.getVerticalBar().getSize().x;
        }
        return new Point(width, height);
    }

    void createItem(ExpandItem item, int index) {
        this.itemHolder.insert(item, index);
        if (this.focusItem == null) {
            this.focusItem = item;
        }
        this.layoutItems(index);
    }

    void destroyItem(ExpandItem item) {
        int index = 0;
        int itemCount = this.getItemCount();
        int i = 0;
        while (i < itemCount) {
            if (this.getItem(i) == item) {
                index = i;
            }
            ++i;
        }
        if (index != itemCount) {
            if (item == this.focusItem) {
                int focusIndex = index > 0 ? index - 1 : 1;
                this.focusItem = focusIndex < itemCount ? this.getItem(focusIndex) : null;
            }
            this.itemHolder.remove(item);
            this.layoutItems(index);
        }
    }

    @Override
    Control findBackgroundControl() {
        Control control = super.findBackgroundControl();
        if (!this.isAppThemed() && control == null) {
            control = this;
        }
        return control;
    }

    public ExpandItem getItem(int index) {
        this.checkWidget();
        return this.itemHolder.getItem(index);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemHolder.size();
    }

    public ExpandItem[] getItems() {
        this.checkWidget();
        return (ExpandItem[])this.itemHolder.getItems();
    }

    public int getSpacing() {
        this.checkWidget();
        return this.spacing;
    }

    public int indexOf(ExpandItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        return this.itemHolder.indexOf(item);
    }

    void layoutItems(int index) {
        if (!this.isInDispose()) {
            int itemCount = this.getItemCount();
            if (index < itemCount) {
                BoxDimensions itemBorder;
                ExpandItem item;
                int y = this.spacing;
                int i = 0;
                while (i < index) {
                    item = this.getItem(i);
                    if (item.expanded) {
                        y += item.height;
                    }
                    itemBorder = item.getItemBorder();
                    y += item.getHeaderHeight() + itemBorder.top + itemBorder.bottom + this.spacing;
                    ++i;
                }
                i = index;
                while (i < itemCount) {
                    item = this.getItem(i);
                    item.setBounds(this.spacing, y, 0, 0, true, false);
                    if (item.expanded) {
                        y += item.height;
                    }
                    itemBorder = item.getItemBorder();
                    y += item.getHeaderHeight() + itemBorder.top + itemBorder.bottom + this.spacing;
                    ++i;
                }
            }
            if (itemCount > 0) {
                ExpandItem lastItem = this.getItem(itemCount - 1);
                this.allItemsHeight = lastItem.y + lastItem.getBounds().height;
            }
            this.updateScrollBars();
            Rectangle bounds = this.getBounds();
            BoxDimensions border = this.getBorder();
            int scrollBarWidth = this.getVScrollBarWidth();
            int i = 0;
            while (i < itemCount) {
                int width;
                ExpandItem item = this.getItem(i);
                Rectangle itemBounds = item.getBounds();
                if (this.isVScrollBarVisible()) {
                    if (this.getOrientation() == 0x4000000) {
                        itemBounds.x = this.spacing + scrollBarWidth;
                    }
                    width = bounds.width - scrollBarWidth - (border.left + border.right) - 2 * this.spacing;
                    item.setBounds(itemBounds.x, itemBounds.y, width, item.height, true, true);
                } else {
                    width = bounds.width - (border.left + border.right) - 2 * this.spacing;
                    item.setBounds(this.spacing, itemBounds.y, width, item.height, true, true);
                }
                ++i;
            }
        }
    }

    public void setSpacing(int spacing) {
        this.checkWidget();
        if (spacing >= 0 && spacing != this.spacing) {
            this.spacing = spacing;
            this.layoutItems(0);
        }
    }

    @Override
    public void setOrientation(int orientation) {
        super.setOrientation(orientation);
        this.layoutItems(0);
    }

    @Override
    public void setData(String key, Object value) {
        if (!"org.eclipse.rap.rwt.markupEnabled".equals(key) || !MarkupUtil.isMarkupEnabledFor(this)) {
            super.setData(key, value);
        }
    }

    void showItem(ExpandItem item) {
        Control control = item.control;
        if (control != null && !control.isDisposed()) {
            control.setVisible(item.expanded);
        }
        int index = this.indexOf(item);
        this.layoutItems(index + 1);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int style) {
        int aStyle = style & 0xFFFFFEFF;
        return aStyle;
    }

    boolean isAppThemed() {
        return false;
    }

    private void updateScrollBars() {
        ScrollBar vScroll = this.getVerticalBar();
        if (vScroll != null) {
            BoxDimensions border = this.getBorder();
            int availableHeight = this.getBounds().height - (border.top + border.bottom) - this.spacing;
            vScroll.setVisible(this.allItemsHeight > availableHeight);
        }
    }

    private boolean isVScrollBarVisible() {
        ScrollBar vScroll = this.getVerticalBar();
        return vScroll != null && vScroll.getVisible();
    }

    Rectangle getBottomSpacingBounds() {
        return new Rectangle(this.spacing, this.allItemsHeight, 10, this.spacing);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IItemHolderAdapter.class) {
            return (T)this.itemHolder;
        }
        if (adapter == IExpandBarAdapter.class) {
            if (this.expandBarAdapter == null) {
                this.expandBarAdapter = new ExpandBarAdapter();
            }
            return (T)this.expandBarAdapter;
        }
        if (adapter == WidgetLCA.class) {
            return (T)ExpandBarLCA.INSTANCE;
        }
        return super.getAdapter(adapter);
    }

    @Override
    void releaseWidget() {
        if (this.resizeListener != null) {
            this.removeControlListener(this.resizeListener);
        }
        super.releaseWidget();
    }

    @Override
    void releaseChildren() {
        ExpandItem[] expandItems = new ExpandItem[this.getItemCount()];
        System.arraycopy(this.getItems(), 0, expandItems, 0, this.getItems().length);
        int i = 0;
        while (i < expandItems.length) {
            if (expandItems[i] != null) {
                ((Widget)expandItems[i]).dispose();
            }
            ++i;
        }
    }

    @Override
    int getVScrollBarWidth() {
        int result = 0;
        if ((this.style & 0x200) != 0) {
            result = this.getVerticalBar().getSize().x;
        }
        return result;
    }

    @Override
    void reskinChildren(int flags) {
        ExpandItem[] items = this.getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                ExpandItem item = items[i];
                if (item != null) {
                    item.reskin(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }

    private final class ExpandBarAdapter
    implements IExpandBarAdapter {
        private ExpandBarAdapter() {
        }

        @Override
        public Rectangle getBounds(ExpandItem item) {
            return item.getBounds();
        }

        @Override
        public Rectangle getBottomSpacingBounds() {
            return ExpandBar.this.getBottomSpacingBounds();
        }
    }

    private final class ResizeListener
    extends ControlAdapter {
        private ResizeListener() {
        }

        @Override
        public void controlResized(ControlEvent event) {
            ExpandBar.this.layoutItems(0);
        }
    }
}

