/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal;

public final class RWTProperties {
    public static final String SERVICE_HANDLER_BASE_URL = "org.eclipse.rap.rwt.serviceHandlerBaseURL";
    public static final String SERVICE_HANDLER_USE_RELATIVE_URL = "org.eclipse.rap.rwt.serviceHandlerUseRelativeURL";
    public static final String DEVELOPMEMT_MODE = "org.eclipse.rap.rwt.developmentMode";
    public static final String TEXT_SIZE_STORE_SIZE = "org.eclipse.rap.rwt.textSizeStoreSize";
    public static final String ENABLE_UI_TESTS = "org.eclipse.rap.rwt.enableUITests";

    private RWTProperties() {
    }

    public static String getServiceHandlerBaseUrl() {
        return System.getProperty(SERVICE_HANDLER_BASE_URL);
    }

    public static boolean isUseRelativeURL() {
        return RWTProperties.getBooleanProperty(SERVICE_HANDLER_USE_RELATIVE_URL, false);
    }

    public static boolean isDevelopmentMode() {
        return RWTProperties.getBooleanProperty(DEVELOPMEMT_MODE, false);
    }

    public static int getTextSizeStoreSize(int defaultValue) {
        return RWTProperties.getIntProperty(TEXT_SIZE_STORE_SIZE, defaultValue);
    }

    public static boolean getBooleanProperty(String name, boolean defaultValue) {
        String value = System.getProperty(name);
        return value == null ? defaultValue : value.equalsIgnoreCase("true");
    }

    public static int getIntProperty(String name, int defaultValue) {
        String value = System.getProperty(name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }
}

