/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme.css;

import org.eclipse.rap.rwt.internal.theme.css.AndConditionImpl;
import org.eclipse.rap.rwt.internal.theme.css.AttributeConditionImpl;
import org.eclipse.rap.rwt.internal.theme.css.ClassConditionImpl;
import org.eclipse.rap.rwt.internal.theme.css.CssFileReader;
import org.eclipse.rap.rwt.internal.theme.css.NullAttributeCondition;
import org.eclipse.rap.rwt.internal.theme.css.NullLangCondition;
import org.eclipse.rap.rwt.internal.theme.css.OneOfAttributeCondition;
import org.eclipse.rap.rwt.internal.theme.css.PseudoClassConditionImpl;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionFactory;
import org.w3c.css.sac.ContentCondition;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.NegativeCondition;
import org.w3c.css.sac.PositionalCondition;

public class ConditionFactoryImpl
implements ConditionFactory {
    private final CssFileReader reader;

    public ConditionFactoryImpl(CssFileReader reader) {
        this.reader = reader;
    }

    @Override
    public AttributeCondition createClassCondition(String namespaceURI, String value) throws CSSException {
        return new ClassConditionImpl(value);
    }

    @Override
    public AttributeCondition createPseudoClassCondition(String namespaceURI, String value) throws CSSException {
        return new PseudoClassConditionImpl(value);
    }

    @Override
    public AttributeCondition createAttributeCondition(String localName, String namespaceURI, boolean specified, String value) throws CSSException {
        return new AttributeConditionImpl(localName, value, specified);
    }

    @Override
    public AttributeCondition createOneOfAttributeCondition(String localName, String namespaceURI, boolean specified, String value) throws CSSException {
        return new OneOfAttributeCondition(localName, value, specified);
    }

    @Override
    public CombinatorCondition createAndCondition(Condition first, Condition second) throws CSSException {
        return new AndConditionImpl(first, second);
    }

    @Override
    public LangCondition createLangCondition(String lang) throws CSSException {
        String mesg = "Lang conditions not supported by RAP - ignored";
        this.reader.addProblem(new CSSException(mesg));
        return new NullLangCondition();
    }

    @Override
    public AttributeCondition createIdCondition(String value) throws CSSException {
        String mesg = "Id conditions not supported by RAP - ignored";
        this.reader.addProblem(new CSSException(mesg));
        return new NullAttributeCondition();
    }

    @Override
    public AttributeCondition createBeginHyphenAttributeCondition(String localName, String namespaceURI, boolean specified, String value) throws CSSException {
        String mesg = "Begin hyphen attribute conditions not supported by RAP - ignored";
        this.reader.addProblem(new CSSException(mesg));
        return new NullAttributeCondition();
    }

    @Override
    public CombinatorCondition createOrCondition(Condition first, Condition second) throws CSSException {
        throw new CSSException("Or conditions not supported by CSS2");
    }

    @Override
    public NegativeCondition createNegativeCondition(Condition condition) throws CSSException {
        throw new CSSException("Negative conditions not supported by CSS2");
    }

    @Override
    public PositionalCondition createPositionalCondition(int position, boolean typeNode, boolean type) throws CSSException {
        throw new CSSException("Positional conditions not supported by CSS2");
    }

    @Override
    public Condition createOnlyChildCondition() throws CSSException {
        throw new CSSException("Only-one-child conditions not supported by CSS2");
    }

    @Override
    public Condition createOnlyTypeCondition() throws CSSException {
        throw new CSSException("Only-one-type conditions not supported by CSS2");
    }

    @Override
    public ContentCondition createContentCondition(String data) throws CSSException {
        throw new CSSException("Content conditions not supported by CSS2");
    }
}

