/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.internal.util.ClassUtil;
import org.eclipse.rwt.internal.util.SharedInstanceBuffer;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.swt.internal.SerializableCompatibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonManager
implements SerializableCompatibility {
    private static final String ATTR_SINGLETON_MANAGER = String.valueOf(SingletonManager.class.getName()) + "#instance";
    private final Map<Class, Object> singletons = Collections.synchronizedMap(new HashMap());
    private transient SharedInstanceBuffer<Class, Object> typeLocks;

    public static void install(ISessionStore sessionStore) {
        SingletonManager.checkNotInstalled(sessionStore);
        sessionStore.setAttribute(ATTR_SINGLETON_MANAGER, new SingletonManager());
    }

    public static SingletonManager getInstance(ISessionStore sessionStore) {
        return (SingletonManager)sessionStore.getAttribute(ATTR_SINGLETON_MANAGER);
    }

    private SingletonManager() {
        this.initialize();
    }

    private void initialize() {
        this.typeLocks = new SharedInstanceBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getSingleton(Class<T> type) {
        Object object = this.getTypeLock(type);
        synchronized (object) {
            Object result = this.singletons.get(type);
            if (result == null) {
                result = ClassUtil.newInstance(type);
                this.singletons.put(type, result);
            }
            return (T)result;
        }
    }

    private Object getTypeLock(Class type) {
        Object result = this.typeLocks.get(type, new SharedInstanceBuffer.IInstanceCreator<Object>(){

            @Override
            public Object createInstance() {
                return new Object();
            }
        });
        return result;
    }

    private static void checkNotInstalled(ISessionStore sessionStore) {
        if (SingletonManager.getInstance(sessionStore) != null) {
            String msg = "SingletonManager already installed for session: " + sessionStore.getId();
            throw new IllegalStateException(msg);
        }
    }

    private Object readResolve() {
        this.initialize();
        return this;
    }
}

