/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.engine;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rwt.internal.application.RWTFactory;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.ServiceContext;
import org.eclipse.rwt.internal.service.ServiceStore;

public class RWTServlet
extends HttpServlet {
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getPathInfo() == null) {
            this.handleValidRequest(request, response);
        } else {
            RWTServlet.handleInvalidRequest(request, response);
        }
    }

    public String getServletInfo() {
        return "RWT Servlet";
    }

    private void handleValidRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServiceContext context = RWTServlet.createServiceContext(request, response);
        ContextProvider.setContext(context);
        try {
            this.createSessionStore();
            RWTFactory.getServiceManager().getHandler().service();
        }
        finally {
            ContextProvider.disposeContext();
        }
    }

    private static ServiceContext createServiceContext(HttpServletRequest request, HttpServletResponse response) {
        ServiceContext context = new ServiceContext(request, response);
        context.setServiceStore(new ServiceStore());
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSessionStore() {
        Class<RWTServlet> clazz = RWTServlet.class;
        synchronized (RWTServlet.class) {
            ContextProvider.getSessionStore();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static void handleInvalidRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if ("/".equals(request.getPathInfo())) {
            String redirectUrl = RWTServlet.createRedirectUrl(request);
            response.sendRedirect(response.encodeRedirectURL(redirectUrl));
        } else {
            response.sendError(404);
        }
    }

    static String createRedirectUrl(HttpServletRequest request) {
        String result = String.valueOf(request.getContextPath()) + request.getServletPath();
        Enumeration parameterNames = request.getParameterNames();
        if (parameterNames.hasMoreElements()) {
            result = String.valueOf(result) + "?";
            boolean first = true;
            while (parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                if (!first) {
                    result = String.valueOf(result) + "&";
                }
                result = String.valueOf(result) + parameterName;
                result = String.valueOf(result) + "=";
                result = String.valueOf(result) + request.getParameter(parameterName);
                first = false;
            }
        }
        return result;
    }
}

