/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.tab;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

public final class ExtensionUtil {
    static IPluginExtension[] getWorkspaceExtensions(String extensionPoint, IProgressMonitor monitor) {
        return ExtensionUtil.getWorkspacePluginExtensions(null, extensionPoint, monitor);
    }

    static IPluginExtension[] getWorkspacePluginExtensions(String[] pluginIds, String extensionPoint, IProgressMonitor monitor) {
        IPluginModelBase[] pluginModels = PluginRegistry.getWorkspaceModels();
        return ExtensionUtil.getExtensions(pluginIds, extensionPoint, pluginModels, monitor);
    }

    static IPluginExtension[] getActiveExtensions(String extensionPoint, IProgressMonitor monitor) {
        IPluginModelBase[] pluginModels = PluginRegistry.getActiveModels();
        return ExtensionUtil.getExtensions(null, extensionPoint, pluginModels, monitor);
    }

    static IPluginExtension[] getActivePluginExtensions(String[] pluginIds, String extensionPoint, IProgressMonitor monitor) {
        IPluginModelBase[] pluginModels = PluginRegistry.getActiveModels();
        return ExtensionUtil.getExtensions(pluginIds, extensionPoint, pluginModels, monitor);
    }

    static String getAttribute(IPluginElement element, String attributeName) {
        IPluginAttribute attribute = element.getAttribute(attributeName);
        return attribute == null ? null : attribute.getValue();
    }

    static String getProjectName(IPluginExtension pluginExtension) {
        String name = null;
        IPluginModelBase pluginModel = pluginExtension.getPluginModel();
        IResource workspaceResource = pluginModel.getUnderlyingResource();
        name = workspaceResource == null ? pluginModel.getBundleDescription().getSymbolicName() : workspaceResource.getProject().getName();
        return name;
    }

    private static IPluginExtension[] getExtensions(String[] pluginIds, String extensionPoint, IPluginModelBase[] pluginModels, IProgressMonitor monitor) {
        IPluginExtension[] result;
        ArrayList<IPluginExtension> list = new ArrayList<IPluginExtension>();
        int i = 0;
        while (!ExtensionUtil.isCanceled(monitor) && i < pluginModels.length) {
            String pluginId = pluginModels[i].getPluginBase().getId();
            if (ExtensionUtil.isContained(pluginIds, pluginId)) {
                IPluginExtension[] extensions = pluginModels[i].getExtensions().getExtensions();
                int k = 0;
                while (k < extensions.length) {
                    if (extensionPoint.equals(extensions[k].getPoint())) {
                        list.add(extensions[k]);
                    }
                    ++k;
                }
            }
            ++i;
        }
        if (ExtensionUtil.isCanceled(monitor)) {
            result = new IPluginExtension[]{};
        } else {
            result = new IPluginExtension[list.size()];
            list.toArray(result);
        }
        return result;
    }

    private static boolean isCanceled(IProgressMonitor monitor) {
        return monitor != null && monitor.isCanceled();
    }

    private static boolean isContained(String[] pluginIds, String pluginId) {
        boolean result;
        if (pluginIds == null) {
            result = true;
        } else {
            result = false;
            int i = 0;
            while (!result && i < pluginIds.length) {
                if (pluginId.equals(pluginIds[i])) {
                    result = true;
                }
                ++i;
            }
        }
        return result;
    }

    private ExtensionUtil() {
    }
}

