/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.rap.ui.internal.launch.Activator;
import org.eclipse.rap.ui.internal.launch.LaunchMessages;
import org.eclipse.rap.ui.internal.launch.RAPLaunchConfig;
import org.eclipse.rap.ui.internal.launch.URLBuilder;
import org.eclipse.rap.ui.internal.launch.tab.ApplicationExtension;
import org.eclipse.rap.ui.internal.launch.tab.BrandingExtension;
import org.eclipse.rap.ui.internal.launch.tab.EntryPointExtension;
import org.eclipse.rap.ui.internal.launch.util.LauncherSerializationUtil;

public final class RAPLaunchConfigValidator {
    private static final String DEFAULT_BRANDING = "rap";
    public static final String WS_RAP = "rap";
    public static final int ERR_SERVLET_NAME = 6001;
    public static final int ERR_PORT = 6004;
    public static final int ERR_URL = 6005;
    public static final int ERR_LOG_LEVEL = 6006;
    public static final int ERR_TIMEOUT = 6007;
    public static final int ERR_ENTRY_POINT = 6008;
    public static final int ERR_SERVLET_BUNDLE = 6009;
    public static final int ERR_DATA_LOCATION = 6010;
    public static final int ERR_CONTEXT_PATH = 6011;
    public static final int WARN_OSGI_FRAMEWORK = 7002;
    public static final int WARN_WS_WRONG = 7003;
    private static final String RAP_LAUNCH_CONFIG_TYPE = "org.eclipse.rap.ui.launch.RAPLauncher";
    private static final String EMPTY = "";
    private static final String WORKSPACE_BUNDLES_KEY = "workspace_bundles";
    private static final String TARGET_BUNDLES_KEY = "target_bundles";
    private static final String PARAM_WS = "-ws";
    private final RAPLaunchConfig config;

    public RAPLaunchConfigValidator(RAPLaunchConfig config) {
        this.config = config;
    }

    public IStatus[] validate() {
        ArrayList<IStatus> states = new ArrayList<IStatus>();
        try {
            this.addNonOKState(states, this.validateServletName());
            this.addNonOKState(states, this.validatePort());
            this.addNonOKState(states, this.validateUniquePort());
            this.addNonOKState(states, this.validateContextPath());
            this.addNonOKState(states, this.validateURL());
            this.addNonOKState(states, this.validateLogLevel());
            this.addNonOKState(states, this.validateSessionTimeout());
            this.addNonOKState(states, this.validateEntryPoint());
            this.addNonOKState(states, this.validateDataLocation());
        }
        catch (CoreException e) {
            String text = LaunchMessages.RAPLaunchConfigValidator_ErrorWhileValidating;
            Object[] args = new Object[]{e.getLocalizedMessage()};
            String msg = MessageFormat.format(text, args);
            states.add(this.createError(msg, 0, e));
        }
        IStatus[] result = new IStatus[states.size()];
        states.toArray(result);
        return result;
    }

    private IStatus validateDataLocation() throws CoreException {
        IStatus result = Status.OK_STATUS;
        String dataLocation = this.config.getDataLocation();
        if (dataLocation == null || dataLocation.length() == 0) {
            String msg = LaunchMessages.RAPLaunchConfigValidator_DataLocationErrorMsg;
            result = this.createError(msg, 6010, null);
        }
        return result;
    }

    private IStatus validateServletName() throws CoreException {
        ILaunchConfiguration launchConfig;
        String[] selectedBundleIds;
        BrandingExtension[] selBrandingExtensions;
        boolean isValid;
        IStatus result = Status.OK_STATUS;
        String servletName = this.config.getServletName();
        if (servletName == null || EMPTY.equals(servletName)) {
            String msg = LaunchMessages.RAPLaunchConfigValidator_ServletNameEmpty;
            result = this.createError(msg, 6001, null);
        } else if (!servletName.equals("rap") && !(isValid = this.isValidBranding(servletName, selBrandingExtensions = BrandingExtension.findInActivePlugins(selectedBundleIds = RAPLaunchConfigValidator.getSelectedBundleIds(launchConfig = this.config.getUnderlyingLaunchConfig()), (IProgressMonitor)new NullProgressMonitor())))) {
            String unformatedMsg = LaunchMessages.RAPLaunchConfigValidator_BrandingMissing;
            String msg = MessageFormat.format(unformatedMsg, servletName);
            result = this.createError(msg, 6009, null);
        }
        return result;
    }

    private IStatus validateContextPath() throws CoreException {
        String contextPath;
        boolean isValid;
        IStatus result = Status.OK_STATUS;
        boolean useManualContextPath = this.config.getUseManualContextPath();
        if (useManualContextPath && !(isValid = this.isValidContextPath(contextPath = this.config.getContextPath()))) {
            String unformatedMsg = LaunchMessages.RAPLaunchConfigValidator_InvalidContextPath;
            String msg = MessageFormat.format(unformatedMsg, contextPath);
            result = this.createError(msg, 6011, null);
        }
        return result;
    }

    private boolean isValidContextPath(String contextPath) {
        boolean result = true;
        int length = contextPath.length();
        if (contextPath.indexOf("//") != -1) {
            result = false;
        }
        int i = 0;
        while (i < length && result) {
            boolean isValidSpecialChar;
            char ch = contextPath.charAt(i);
            boolean isLetterOrDigit = Character.isLetterOrDigit(ch);
            boolean bl = isValidSpecialChar = "/_-.".indexOf(ch) != -1;
            if (!isLetterOrDigit && !isValidSpecialChar) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    private IStatus validatePort() throws CoreException {
        int port;
        IStatus result = Status.OK_STATUS;
        if (this.config.getUseManualPort() && ((port = this.config.getPort()) < 0 || port > 65535)) {
            String text = LaunchMessages.RAPLaunchConfigValidator_PortNumberInvalid;
            Object[] args = new Object[]{new Integer(0), new Integer(65535)};
            String msg = MessageFormat.format(text, args);
            result = this.createError(msg, 6004, null);
        }
        return result;
    }

    private IStatus validateUniquePort() throws CoreException {
        IStatus result = Status.OK_STATUS;
        if (this.config.getUseManualPort()) {
            RAPLaunchConfig duplicate = null;
            ILaunchConfiguration[] launchConfigs = RAPLaunchConfigValidator.getLaunchConfigs();
            int i = 0;
            while (duplicate == null && i < launchConfigs.length) {
                RAPLaunchConfig otherConfig = new RAPLaunchConfig(launchConfigs[i]);
                if (this.hasSamePort(otherConfig)) {
                    duplicate = otherConfig;
                }
                ++i;
            }
            if (duplicate != null) {
                String text = LaunchMessages.RAPLaunchConfigValidator_PortInUse;
                Object[] args = new Object[]{new Integer(this.config.getPort()), duplicate.getName()};
                String msg = MessageFormat.format(text, args);
                result = this.createWarning(msg, 0, null);
            }
        }
        return result;
    }

    private IStatus validateURL() throws CoreException {
        IStatus result = Status.OK_STATUS;
        try {
            String url = URLBuilder.fromLaunchConfig(this.config, 80, false);
            new URI(url);
        }
        catch (URISyntaxException exception) {
            String text = LaunchMessages.RAPLaunchConfigValidator_MalformedUrl;
            result = this.createError(text, 6005, exception);
        }
        return result;
    }

    private IStatus validateLogLevel() throws CoreException {
        IStatus result = Status.OK_STATUS;
        boolean isValid = false;
        Level logLevel = this.config.getLogLevel();
        int i = 0;
        while (!isValid && i < RAPLaunchConfig.LOG_LEVELS.length) {
            if (RAPLaunchConfig.LOG_LEVELS[i].equals(logLevel)) {
                isValid = true;
            }
            ++i;
        }
        if (!isValid) {
            Object[] args = new Object[]{logLevel.getName()};
            String msg = LaunchMessages.RAPLaunchConfigValidator_LogLevelInvalid;
            String msgFmt = MessageFormat.format(msg, args);
            result = this.createError(msgFmt, 6006, null);
        }
        return result;
    }

    private IStatus validateSessionTimeout() throws CoreException {
        boolean isValid;
        IStatus result = Status.OK_STATUS;
        boolean bl = isValid = this.config.getSessionTimeout() >= 0;
        if (!isValid) {
            String msg = LaunchMessages.RAPLaunchConfigValidator_TimeoutInvalid;
            result = this.createError(msg, 6007, null);
        }
        return result;
    }

    private IStatus validateEntryPoint() throws CoreException {
        IStatus result = Status.OK_STATUS;
        String entryPoint = this.config.getEntryPoint();
        if (entryPoint != null && !EMPTY.equals(entryPoint)) {
            ILaunchConfiguration underlyingLaunchConfig = this.config.getUnderlyingLaunchConfig();
            String[] selectedBundleIds = RAPLaunchConfigValidator.getSelectedBundleIds(underlyingLaunchConfig);
            EntryPointExtension[] selEntryPointExtensions = EntryPointExtension.findInActivePlugins(selectedBundleIds, (IProgressMonitor)new NullProgressMonitor());
            ApplicationExtension[] selApplicationExtensions = ApplicationExtension.findInActivePlugins(selectedBundleIds, (IProgressMonitor)new NullProgressMonitor());
            boolean validEntryPoint = this.isValidEntryPoint(entryPoint, selEntryPointExtensions);
            boolean validApplication = this.isValidApplication(entryPoint, selApplicationExtensions);
            if (!validApplication && !validEntryPoint) {
                String unformatedMsg = LaunchMessages.RAPLaunchConfigValidator_EntryPointMissing;
                String msg = MessageFormat.format(unformatedMsg, entryPoint);
                result = this.createError(msg, 6008, null);
            }
        }
        return result;
    }

    private IStatus validateWS() throws CoreException {
        IStatus result = Status.OK_STATUS;
        ILaunchConfiguration launchConfig = this.config.getUnderlyingLaunchConfig();
        String[] programArguments = LaunchArgumentsHelper.getUserProgramArgumentArray((ILaunchConfiguration)launchConfig);
        String wsValue = this.extractParameterValue(PARAM_WS, programArguments);
        String warnMessagePattern = null;
        if (wsValue == null || EMPTY.equals(wsValue)) {
            warnMessagePattern = LaunchMessages.RAPLaunchConfigValidator_WsEmpty;
        } else if (!"rap".equals(wsValue)) {
            warnMessagePattern = LaunchMessages.RAPLaunchConfigValidator_WsWrong;
        }
        if (warnMessagePattern != null) {
            Object[] args = new Object[]{PARAM_WS, "rap"};
            String warnMessage = MessageFormat.format(warnMessagePattern, args);
            result = this.createWarning(warnMessage, 7003, null);
        }
        return result;
    }

    private String extractParameterValue(String name, String[] parameters) {
        String result = null;
        int i = 0;
        while (i < parameters.length) {
            String key = parameters[i];
            if (name.equals(key) && i < parameters.length - 1) {
                result = parameters[i + 1];
            }
            ++i;
        }
        return result;
    }

    private void addNonOKState(List states, IStatus state) {
        if (state != null && !state.isOK()) {
            states.add(state);
        }
    }

    private IStatus createWarning(String msg, int code, Throwable thr) {
        String pluginId = Activator.getPluginId();
        return new Status(2, pluginId, code, msg, thr);
    }

    private IStatus createError(String msg, int code, Throwable thr) {
        return new Status(4, Activator.getPluginId(), code, msg, thr);
    }

    private static ILaunchConfiguration[] getLaunchConfigs() throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType(RAP_LAUNCH_CONFIG_TYPE);
        return launchManager.getLaunchConfigurations(type);
    }

    private boolean hasSamePort(RAPLaunchConfig otherConfig) throws CoreException {
        return otherConfig.getUseManualPort() && !this.config.getName().equals(otherConfig.getName()) && this.config.getPort() == otherConfig.getPort();
    }

    private static String[] getSelectedBundleIds(ILaunchConfiguration launchConfiguration) throws CoreException {
        String[] result = launchConfiguration.getAttribute("useCustomFeatures", false) ? RAPLaunchConfigValidator.getBundleIdsFromFeatures(launchConfiguration) : RAPLaunchConfigValidator.getBundleIdsFromBundles(launchConfiguration);
        return result;
    }

    private static String[] getBundleIdsFromFeatures(ILaunchConfiguration launchConfiguration) throws CoreException {
        IPluginModelBase[] mergedBundles = BundleLauncherHelper.getMergedBundles((ILaunchConfiguration)launchConfiguration, (boolean)true);
        String[] result = new String[mergedBundles.length];
        int i = 0;
        while (i < mergedBundles.length) {
            result[i] = mergedBundles[i].getBundleDescription().getSymbolicName();
            ++i;
        }
        return result;
    }

    private static String[] getBundleIdsFromBundles(ILaunchConfiguration launchConfiguration) throws CoreException {
        String selectedWorkspaceBundles = launchConfiguration.getAttribute(WORKSPACE_BUNDLES_KEY, EMPTY);
        String selectedTargetBundles = launchConfiguration.getAttribute(TARGET_BUNDLES_KEY, EMPTY);
        ArrayList selectedBundleIds = new ArrayList();
        RAPLaunchConfigValidator.addBundleIds(selectedBundleIds, selectedWorkspaceBundles);
        RAPLaunchConfigValidator.addBundleIds(selectedBundleIds, selectedTargetBundles);
        List resultAsList = RAPLaunchConfigValidator.filterNotActiveSelectedBundleIds(selectedBundleIds);
        String[] result = new String[resultAsList.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (String)resultAsList.get(i);
            ++i;
        }
        return result;
    }

    private static void addBundleIds(List selectedBundles, String bundlesInCsvFormat) {
        if (bundlesInCsvFormat != null && !EMPTY.equals(bundlesInCsvFormat)) {
            String[] bundles = bundlesInCsvFormat.split(",");
            int i = 0;
            while (i < bundles.length) {
                int indexOf = bundles[i].indexOf("@");
                if (indexOf != -1) {
                    String bundleId = bundles[i].substring(0, indexOf);
                    selectedBundles.add(bundleId);
                }
                ++i;
            }
        }
    }

    private static List filterNotActiveSelectedBundleIds(List selectedBundleIds) {
        IPluginModelBase[] activeModels = PluginRegistry.getActiveModels();
        ArrayList<String> resultAsList = new ArrayList<String>();
        int i = 0;
        while (i < activeModels.length) {
            BundleDescription description = activeModels[i].getBundleDescription();
            String bundleId = description.getSymbolicName();
            if (selectedBundleIds.contains(bundleId)) {
                resultAsList.add(bundleId);
            }
            ++i;
        }
        return resultAsList;
    }

    private boolean isValidEntryPoint(String entryPoint, EntryPointExtension[] extensions) {
        boolean result = false;
        int i = 0;
        while (i < extensions.length && !result) {
            EntryPointExtension extension = extensions[i];
            String availableEntryPoint = LauncherSerializationUtil.serializeEntryPointExntesion(extension);
            result = entryPoint.equals(availableEntryPoint);
            ++i;
        }
        return result;
    }

    private boolean isValidApplication(String application, ApplicationExtension[] extensions) {
        boolean result = false;
        int i = 0;
        while (i < extensions.length && !result) {
            ApplicationExtension extension = extensions[i];
            String availableApplication = LauncherSerializationUtil.serializeApplicationExtension(extension);
            result = application.equals(availableApplication);
            ++i;
        }
        return result;
    }

    private boolean isValidBranding(String brandingt, BrandingExtension[] extensions) {
        boolean result = false;
        int i = 0;
        while (i < extensions.length && !result) {
            BrandingExtension extension = extensions[i];
            String availableBranding = LauncherSerializationUtil.serializeBrandingExtension(extension);
            result = brandingt.equals(availableBranding);
            ++i;
        }
        return result;
    }
}

