/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.util.ClassUtil;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.lifecycle.IEntryPoint;
import org.eclipse.rwt.service.ISessionStore;

public class EntryPointManager {
    public static final String DEFAULT = "default";
    private static final String CURRENT_ENTRY_POINT;
    private final Map registry = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.lifecycle.EntryPointManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CURRENT_ENTRY_POINT = String.valueOf(clazz.getName()) + "#currentEntryPointName";
    }

    public static String getCurrentEntryPoint() {
        ISessionStore session = ContextProvider.getSession();
        return (String)session.getAttribute(CURRENT_ENTRY_POINT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String name, Class clazz) {
        ParamCheck.notNull(name, "name");
        ParamCheck.notNull(clazz, "clazz");
        EntryPointManager.checkClass(clazz);
        Map map = this.registry;
        synchronized (map) {
            if (this.registry.containsKey(name)) {
                String msg = "Entry point already exists: " + name;
                throw new IllegalArgumentException(msg);
            }
            this.registry.put(name, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(String name) {
        ParamCheck.notNull(name, "name");
        Map map = this.registry;
        synchronized (map) {
            this.checkNameExists(name);
            this.registry.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createUI(String name) {
        Class clazz;
        ParamCheck.notNull(name, "name");
        Map map = this.registry;
        synchronized (map) {
            this.checkNameExists(name);
            clazz = (Class)this.registry.get(name);
        }
        IEntryPoint entryPoint = (IEntryPoint)ClassUtil.newInstance(clazz);
        EntryPointManager.setCurrentEntryPoint(name);
        return entryPoint.createUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getEntryPoints() {
        Map map = this.registry;
        synchronized (map) {
            String[] result = new String[this.registry.keySet().size()];
            this.registry.keySet().toArray(result);
            return result;
        }
    }

    private static void checkClass(Class clazz) {
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.rwt.lifecycle.IEntryPoint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz2.isAssignableFrom(clazz)) {
            StringBuffer stringBuffer = new StringBuffer("Entry point class must implement ");
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.eclipse.rwt.lifecycle.IEntryPoint");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String msg = stringBuffer.append(clazz3.getName()).toString();
            throw new IllegalArgumentException(msg);
        }
    }

    private void checkNameExists(String name) {
        if (!this.registry.containsKey(name)) {
            String msg = "Entry point does not exist: " + name;
            throw new IllegalArgumentException(msg);
        }
    }

    private static void setCurrentEntryPoint(String name) {
        ISessionStore session = ContextProvider.getSession();
        session.setAttribute(CURRENT_ENTRY_POINT, name);
    }
}

