/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.toolitemkit;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.internal.widgets.toolitemkit.ToolItemDelegateLCA;
import org.eclipse.swt.internal.widgets.toolitemkit.ToolItemLCAUtil;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

final class SeparatorToolItemLCA
extends ToolItemDelegateLCA {
    private static final String QX_TYPE = "org.eclipse.rwt.widgets.ToolSeparator";
    private static final String PARAM_LINE_VISIBLE = "lineVisible";

    SeparatorToolItemLCA() {
    }

    void preserveValues(ToolItem toolItem) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)toolItem);
        adapter.preserve(PARAM_LINE_VISIBLE, (Object)SeparatorToolItemLCA.isLineVisible(toolItem));
        ToolItemLCAUtil.preserveValues(toolItem);
    }

    void readData(ToolItem toolItem) {
    }

    void renderInitialization(ToolItem toolItem) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)toolItem);
        ToolBar toolBar = toolItem.getParent();
        Boolean flat = (toolBar.getStyle() & 0x800000) != 0;
        Boolean vertical = (toolBar.getStyle() & 0x200) != 0;
        writer.newWidget(QX_TYPE, new Object[]{flat, vertical});
        writer.call((Widget)toolBar, "add", new Object[]{toolItem});
    }

    void renderChanges(ToolItem toolItem) throws IOException {
        WidgetLCAUtil.writeEnabled((Widget)toolItem, toolItem.getEnabled());
        ToolItemLCAUtil.writeVisible(toolItem);
        ToolItemLCAUtil.writeBounds(toolItem);
        WidgetLCAUtil.writeCustomVariant((Widget)toolItem);
        SeparatorToolItemLCA.writeLineVisible(toolItem);
    }

    static void writeLineVisible(ToolItem toolItem) throws IOException {
        boolean isLineVisible = SeparatorToolItemLCA.isLineVisible(toolItem);
        Boolean defValue = Boolean.TRUE;
        String prop = PARAM_LINE_VISIBLE;
        Boolean actValue = isLineVisible;
        if (WidgetLCAUtil.hasChanged((Widget)toolItem, prop, actValue, defValue)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)toolItem);
            writer.set(PARAM_LINE_VISIBLE, actValue);
        }
    }

    static boolean isLineVisible(ToolItem toolItem) {
        return toolItem.getControl() == null;
    }
}

