/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.shellkit;

import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.rwt.internal.theme.WidgetMatcher;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.controlkit.ControlThemeAdapter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class ShellThemeAdapter
extends ControlThemeAdapter {
    private static final int MENU_BAR_MIN_HEIGHT = 20;

    protected void configureMatcher(WidgetMatcher matcher) {
        super.configureMatcher(matcher);
        matcher.addStyle("TITLE", 32);
        matcher.addState("maximized", new WidgetMatcher.Constraint(){

            public boolean matches(Widget widget) {
                return ((Shell)widget).getMaximized();
            }
        });
    }

    public Rectangle getTitleBarMargin(Shell shell) {
        Rectangle result = (shell.getStyle() & 0x20) != 0 ? this.getCssBoxDimensions("Shell-Titlebar", "margin", shell) : new Rectangle(0, 0, 0, 0);
        return result;
    }

    public int getTitleBarHeight(Shell shell) {
        int result = 0;
        if ((shell.getStyle() & 0x20) != 0) {
            result = this.getCssDimension("Shell-Titlebar", "height", shell);
        }
        return result;
    }

    public int getMenuBarHeight(Shell shell) {
        int result = 0;
        if (shell.getMenuBar() != null) {
            Font font = this.getCssFont("Shell", "font", shell);
            int fontHeight = Graphics.getCharHeight(font);
            result = Math.max(20, fontHeight);
        }
        return result;
    }
}

