/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.wizards;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

public class FilteredTreeWithoutWorkbench
extends FilteredTree {
    private final Object refreshJobFamily = new Object();

    public FilteredTreeWithoutWorkbench(Composite parent, int style) {
        super(parent, style, new PatternFilter(), true);
    }

    public Object getRefreshJobFamily() {
        return this.refreshJobFamily;
    }

    protected WorkbenchJob doCreateRefreshJob() {
        return new WorkbenchJob("Refresh Filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                boolean initial;
                if (FilteredTreeWithoutWorkbench.this.treeViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                PatternFilter patternFilter = FilteredTreeWithoutWorkbench.this.getPatternFilter();
                String text = FilteredTreeWithoutWorkbench.this.getFilterString();
                if (StringUtil.isEmpty((String)text)) {
                    patternFilter.setPattern(null);
                    FilteredTreeWithoutWorkbench.this.treeViewer.refresh(true);
                    return Status.OK_STATUS;
                }
                boolean bl = initial = FilteredTreeWithoutWorkbench.this.initialText != null && FilteredTreeWithoutWorkbench.this.initialText.equals(text);
                if (initial) {
                    patternFilter.setPattern(null);
                } else {
                    patternFilter.setPattern(text);
                }
                Composite redrawFalseControl = FilteredTreeWithoutWorkbench.this.treeComposite != null ? FilteredTreeWithoutWorkbench.this.treeComposite : FilteredTreeWithoutWorkbench.this.treeViewer.getControl();
                try {
                    redrawFalseControl.setRedraw(false);
                    TreeItem[] is = FilteredTreeWithoutWorkbench.this.treeViewer.getTree().getItems();
                    int i = 0;
                    while (i < is.length) {
                        TreeItem item = is[i];
                        if (item.getExpanded()) {
                            FilteredTreeWithoutWorkbench.this.treeViewer.setExpandedState(item.getData(), false);
                        }
                        ++i;
                    }
                    FilteredTreeWithoutWorkbench.this.treeViewer.refresh(true);
                    if (text.length() > 0 && !initial) {
                        TreeItem[] items = FilteredTreeWithoutWorkbench.this.getViewer().getTree().getItems();
                        int treeHeight = FilteredTreeWithoutWorkbench.this.getViewer().getTree().getBounds().height;
                        int numVisibleItems = treeHeight / FilteredTreeWithoutWorkbench.this.getViewer().getTree().getItemHeight();
                        long stopTime = 200L + System.currentTimeMillis();
                        boolean cancel = false;
                        if (items.length > 0 && this.recursiveExpand(items, monitor, stopTime, new int[]{numVisibleItems})) {
                            cancel = true;
                        }
                        FilteredTreeWithoutWorkbench.this.updateToolbar(true);
                        if (cancel) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                    } else {
                        FilteredTreeWithoutWorkbench.this.updateToolbar(false);
                    }
                }
                finally {
                    TreeItem[] items = FilteredTreeWithoutWorkbench.this.getViewer().getTree().getItems();
                    if (items.length > 0 && FilteredTreeWithoutWorkbench.this.getViewer().getTree().getSelectionCount() == 0) {
                        FilteredTreeWithoutWorkbench.this.treeViewer.getTree().setTopItem(items[0]);
                    }
                    redrawFalseControl.setRedraw(true);
                }
                return Status.OK_STATUS;
            }

            private boolean recursiveExpand(TreeItem[] items, IProgressMonitor monitor, long cancelTime, int[] numItemsLeft) {
                boolean canceled = false;
                int i = 0;
                while (!canceled && i < items.length) {
                    boolean visible;
                    TreeItem item = items[i];
                    int n = numItemsLeft[0];
                    numItemsLeft[0] = n - 1;
                    boolean bl = visible = n >= 0;
                    if (monitor.isCanceled() || !visible && System.currentTimeMillis() > cancelTime) {
                        canceled = true;
                    } else {
                        Object itemData = item.getData();
                        if (itemData != null) {
                            if (!item.getExpanded()) {
                                FilteredTreeWithoutWorkbench.this.treeViewer.setExpandedState(itemData, true);
                            }
                            TreeItem[] children = item.getItems();
                            if (items.length > 0) {
                                canceled = this.recursiveExpand(children, monitor, cancelTime, numItemsLeft);
                            }
                        }
                    }
                    ++i;
                }
                return canceled;
            }

            public Display getDisplay() {
                return UIUtil.getDisplay();
            }

            public boolean shouldSchedule() {
                return true;
            }

            public boolean shouldRun() {
                return true;
            }

            public boolean belongsTo(Object family) {
                return family == FilteredTreeWithoutWorkbench.this.refreshJobFamily;
            }
        };
    }
}

