/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.AbstractMethodMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.FieldAccessSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.MethodSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.ParameterMapping;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleTypeCreator;

public class CalloutMappingDeclaration
extends AbstractMethodMappingDeclaration {
    public int calloutKind;
    public int declaredModifiers = 0;
    public int modifiersSourceStart;
    public MethodSpec baseMethodSpec;
    private static final boolean ALLOW_DECAPSULATION = true;

    public CalloutMappingDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    public void setCalloutKind(boolean isOverride) {
        this.calloutKind = isOverride ? 105 : 75;
    }

    public void checkAddBasemethodSpec(MethodSpec baseSpec) {
        if (this.baseMethodSpec == null) {
            this.baseMethodSpec = baseSpec;
        }
    }

    public boolean internalCheckParametersCompatibility(MethodSpec methodSpec, TypeBinding[] roleParams, TypeBinding[] baseParams) {
        if (roleParams.length < baseParams.length) {
            if (methodSpec != null) {
                this.scope.problemReporter().tooFewArgumentsInMethodMapping(this.roleMethodSpec, methodSpec, true);
                this.binding.tagBits |= Long.MIN_VALUE;
            }
            return false;
        }
        int j = 0;
        while (j < baseParams.length) {
            Config oldConfig = Config.createOrResetConfig(this);
            try {
                TypeBinding baseParam;
                TypeBinding roleParam = roleParams[j];
                if (roleParam instanceof UnresolvedReferenceBinding) {
                    roleParam = ((UnresolvedReferenceBinding)roleParam).resolve(this.scope.environment(), false);
                }
                TypeBinding roleParamLeaf = roleParam.leafComponentType();
                ReferenceBinding roleBaseLeaf = null;
                if (roleParamLeaf instanceof ReferenceBinding && ((ReferenceBinding)roleParamLeaf).isRole()) {
                    roleParam = TeamModel.strengthenRoleType(this.scope.enclosingSourceType(), roleParam);
                    roleBaseLeaf = ((ReferenceBinding)roleParam.leafComponentType()).baseclass();
                }
                if (!roleParam.isCompatibleWith(baseParam = baseParams[j])) {
                    if (!RoleTypeCreator.isCompatibleViaBaseAnchor(this.scope, baseParam, roleParam, 75) && !this.scope.isBoxingCompatibleWith(roleParam, baseParam)) {
                        if (methodSpec == null) {
                            return false;
                        }
                        if (methodSpec.hasSignature && roleBaseLeaf != null) {
                            this.scope.problemReporter().typeMismatchErrorPotentialLower(methodSpec.arguments[j], roleParam, baseParam, roleBaseLeaf);
                        } else {
                            this.scope.problemReporter().incompatibleMappedArgument(roleParam, baseParam, methodSpec, j, true);
                        }
                        this.binding.tagBits |= Long.MIN_VALUE;
                    }
                } else {
                    this.roleMethodSpec.argNeedsTranslation[j] = Config.getLoweringRequired();
                }
            }
            finally {
                Config.removeOrRestore(oldConfig, this);
            }
            ++j;
        }
        return true;
    }

    public void checkReturnCompatibility(MethodSpec methodSpec) {
        TypeBinding roleReturn = this.roleMethodSpec.resolvedType();
        TypeBinding baseReturn = methodSpec.resolvedType();
        if (roleReturn != null) {
            if (baseReturn == null) {
                this.scope.problemReporter().returnRequiredInMethodMapping(methodSpec, roleReturn, true);
            } else {
                AstGenerator gen = new AstGenerator(methodSpec.sourceStart, methodSpec.sourceEnd);
                SingleNameReference baseRef = gen.singleNameReference(IOTConstants._OT_BASE);
                baseRef.binding = RoleTypeCreator.findResolvedVariable(this.scope.classScope(), IOTConstants._OT_BASE);
                baseReturn = RoleTypeCreator.maybeWrapQualifiedRoleType(this.scope, baseRef, baseReturn, methodSpec.returnType);
                if (this.roleMethodSpec.returnType == null) {
                    this.roleMethodSpec.returnType = gen.typeReference(roleReturn);
                }
                if (roleReturn == TypeBinding.VOID || baseReturn.isCompatibleWith(roleReturn)) {
                    this.roleMethodSpec.returnType.resolvedType = roleReturn;
                } else {
                    TypeBinding roleToLiftTo = TeamModel.getRoleToLiftTo(this.scope, baseReturn, roleReturn, false, methodSpec);
                    if (roleToLiftTo != null) {
                        this.roleMethodSpec.returnNeedsTranslation = true;
                        this.roleMethodSpec.returnType.resolvedType = roleToLiftTo;
                        return;
                    }
                    if (this.scope.isBoxingCompatibleWith(baseReturn, roleReturn)) {
                        this.roleMethodSpec.returnType.resolvedType = roleReturn;
                        return;
                    }
                    this.scope.problemReporter().calloutIncompatibleReturnType(this.roleMethodSpec, methodSpec);
                    this.binding.tagBits |= Long.MIN_VALUE;
                }
            }
        }
    }

    protected void checkTypeCompatibility(FieldAccessSpec fieldSpec) {
        if (this.roleMethodSpec.returnType == null) {
            AstGenerator gen = new AstGenerator(this.roleMethodSpec.sourceStart, this.roleMethodSpec.sourceEnd);
            this.roleMethodSpec.returnType = gen.typeReference(this.roleMethodSpec.resolvedType());
        }
        TypeBinding requiredType = null;
        TypeBinding providedType = null;
        if (fieldSpec.calloutModifier == 122) {
            requiredType = this.roleMethodSpec.resolvedType();
            providedType = fieldSpec.resolvedType();
            if (providedType.isCompatibleWith(requiredType)) {
                if (this.roleMethodSpec.returnType.resolvedType == null) {
                    this.roleMethodSpec.returnType.resolvedType = requiredType;
                }
                return;
            }
            TypeBinding roleToLiftTo = TeamModel.getRoleToLiftTo(this.scope, providedType, requiredType, false, fieldSpec);
            if (roleToLiftTo != null) {
                this.roleMethodSpec.returnNeedsTranslation = true;
                this.roleMethodSpec.returnType.resolvedType = roleToLiftTo;
                return;
            }
            if (requiredType == TypeBinding.VOID) {
                this.scope.problemReporter().fieldAccessHasNoEffect(this.roleMethodSpec, fieldSpec);
                this.roleMethodSpec.returnType.resolvedType = requiredType;
                return;
            }
            if (this.roleMethodSpec.returnType.resolvedType == null) {
                this.roleMethodSpec.returnType.resolve(this.scope);
            }
        } else {
            if (this.roleMethodSpec.resolvedMethod.returnType != TypeBinding.VOID) {
                this.scope.problemReporter().calloutSetCantReturn(this.roleMethodSpec);
                this.binding.tagBits |= Long.MIN_VALUE;
            }
            this.roleMethodSpec.returnType.resolvedType = TypeBinding.VOID;
            TypeBinding[] params = this.roleMethodSpec.resolvedMethod.parameters;
            if (params == null || params.length == 0) {
                this.scope.problemReporter().calloutToFieldMissingParameter(this.roleMethodSpec, fieldSpec);
                this.binding.tagBits |= Long.MIN_VALUE;
                return;
            }
            providedType = params[0];
            requiredType = fieldSpec.resolvedType();
            if (providedType.isCompatibleWith(requiredType)) {
                return;
            }
        }
        this.scope.problemReporter().calloutIncompatibleFieldType(this.roleMethodSpec, fieldSpec, requiredType, providedType);
        this.binding.tagBits |= Long.MIN_VALUE;
    }

    protected void checkModifiers(boolean haveBaseMethods, ReferenceBinding baseType) {
        AbstractMethodDeclaration methodDecl;
        boolean roleHasImplementation = false;
        MethodBinding roleMethod = this.roleMethodSpec.resolvedMethod;
        if (!roleMethod.isValidBinding()) {
            return;
        }
        if (roleMethod.isAbstract() && roleMethod.copyInheritanceSrc != null && !roleMethod.copyInheritanceSrc.isAbstract()) {
            roleMethod.modifiers &= 0xFFFFFBFF;
        }
        boolean bl = roleHasImplementation = !roleMethod.isAbstract();
        if (roleHasImplementation != this.isCalloutOverride()) {
            if (roleHasImplementation) {
                if (this.isCalloutMethod(roleMethod)) {
                    if (roleMethod.declaringClass != this.scope.enclosingSourceType() || roleMethod.copyInheritanceSrc != null) {
                        this.scope.problemReporter().regularCalloutOverridesCallout(this, roleMethod);
                    }
                } else {
                    this.scope.problemReporter().regularCalloutOverrides(this);
                }
            } else {
                this.scope.problemReporter().abstractMethodBoundAsOverrideCallout(this);
                AbstractMethodDeclaration roleMethodDeclaration = roleMethod.sourceMethod();
                if (roleMethodDeclaration != null) {
                    roleMethodDeclaration.ignoreFurtherInvestigation = true;
                    this.ignoreFurtherInvestigation = true;
                }
            }
        }
        if (roleMethod.isCallin()) {
            this.scope.problemReporter().calloutBindingCallin(this.roleMethodSpec);
        }
        if (this.hasErrors() && this.roleMethodSpec.resolvedMethod != null && this.roleMethodSpec.resolvedMethod.isAbstract() && (methodDecl = this.roleMethodSpec.resolvedMethod.sourceMethod()) != null) {
            methodDecl.tagAsHavingErrors();
        }
    }

    private boolean isCalloutMethod(MethodBinding method) {
        CallinCalloutBinding[] bindings;
        if (method.copyInheritanceSrc != null) {
            method = method.copyInheritanceSrc;
        }
        if (method.declaringClass.isBinaryBinding()) {
            Dependencies.ensureBindingState(method.declaringClass, 14);
        }
        if ((bindings = method.declaringClass.callinCallouts) != null) {
            int i = 0;
            while (i < bindings.length) {
                if (bindings[i]._roleMethodBinding == method) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void checkThrownExceptions(MethodSpec baseSpec) {
        if (this.hasSignature && !this.roleMethodSpec.resolvedMethod.isValidBinding() && this.roleMethodSpec.problemId() == 1) {
            return;
        }
        this.checkThrownExceptions(baseSpec.resolvedMethod, this.roleMethodSpec.resolvedMethod);
    }

    public StringBuffer print(int indent, StringBuffer output) {
        CalloutMappingDeclaration.printIndent(indent, output);
        if (this.declaredModifiers != 0) {
            CalloutMappingDeclaration.printModifiers(this.declaredModifiers, output);
        }
        this.printShort(0, output);
        if (this.mappings != null) {
            output.append(" with {\n");
            int length = this.mappings.length;
            int t = 0;
            while (t < length) {
                CalloutMappingDeclaration.printIndent(indent + 1, output);
                this.mappings[t].print(0, output);
                if (t < length - 1) {
                    output.append(",\n");
                } else {
                    output.append("\n");
                }
                ++t;
            }
            CalloutMappingDeclaration.printIndent(indent, output);
            output.append("}");
        } else {
            output.append(";");
        }
        return output;
    }

    public StringBuffer printShort(int indent, StringBuffer output) {
        CalloutMappingDeclaration.printIndent(indent, output);
        this.roleMethodSpec.print(0, output);
        if (this.calloutKind == 105) {
            output.append(" => ");
        } else {
            output.append(" -> ");
        }
        if (this.baseMethodSpec != null) {
            this.baseMethodSpec.print(0, output);
        } else {
            output.append(" <nullBaseMethod>");
        }
        return output;
    }

    public void traverse(ASTVisitor visitor, ClassScope classScope) {
        if (visitor.visit(this, classScope)) {
            if (this.roleMethodSpec != null) {
                this.roleMethodSpec.traverse(visitor, this.scope);
            }
            if (this.baseMethodSpec != null) {
                this.baseMethodSpec.traverse(visitor, this.scope);
            }
            if (this.mappings != null) {
                int i = 0;
                while (i < this.mappings.length) {
                    ParameterMapping mapping = this.mappings[i];
                    mapping.traverse(visitor, this.scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, classScope);
    }

    public boolean isCallin() {
        return false;
    }

    public boolean isCallout() {
        return true;
    }

    public boolean isCalloutOverride() {
        return this.calloutKind == 105;
    }

    public boolean isCalloutToField() {
        return this.baseMethodSpec instanceof FieldAccessSpec;
    }

    public boolean canAccessInvisibleBase() {
        return true;
    }

    public int arrowSourceStart() {
        return this.roleMethodSpec.sourceEnd + 1;
    }

    public int arrowSourceEnd() {
        return this.baseMethodSpec.sourceStart - 1;
    }

    public MethodSpec getImplementationMethodSpec() {
        return this.baseMethodSpec;
    }

    public MethodSpec[] getBaseMethodSpecs() {
        if (this.baseMethodSpec != null) {
            return new MethodSpec[]{this.baseMethodSpec};
        }
        this.tagAsHavingErrors();
        return new MethodSpec[0];
    }

    public void updateRoleMethod(MethodBinding method) {
        this.roleMethodSpec.resolvedMethod = method;
        this.binding._roleMethodBinding = method;
    }
}

