/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.cda.xml.ui.handlers;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mdht.uml.cda.ClinicalDocument;
import org.eclipse.mdht.uml.cda.Section;
import org.eclipse.mdht.uml.cda.util.CDAUtil;
import org.eclipse.mdht.uml.hl7.datatypes.util.DatatypesUtil;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class AnalyzeCDAHandler
extends AbstractHandler {
    public IFile codeMetricsFile;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block5: {
            try {
                ProgressMonitorDialog pd = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
                if (!(selection instanceof IStructuredSelection)) break block5;
                final CDAAnalaysisInput cdaAnalaysisInput = new CDAAnalaysisInput();
                final IStructuredSelection iss = (IStructuredSelection)selection;
                try {
                    pd.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                Iterator iter = iss.iterator();
                                block3: while (iter.hasNext() && !monitor.isCanceled()) {
                                    Object o = iter.next();
                                    if (!(o instanceof IFolder)) continue;
                                    IFolder folder = (IFolder)o;
                                    monitor.beginTask("Analyze CDA Documents", folder.members().length);
                                    AnalyzeCDAHandler.this.codeMetricsFile = folder.getFile("codemetrics.cfg");
                                    IResource[] iResourceArray = folder.members();
                                    int n = iResourceArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IFile file;
                                        IResource resource = iResourceArray[n2];
                                        if (monitor.isCanceled()) {
                                            monitor.done();
                                            continue block3;
                                        }
                                        if (resource instanceof IFile && "XML".equalsIgnoreCase((file = (IFile)resource).getFileExtension())) {
                                            monitor.worked(1);
                                            monitor.subTask("Processing " + file.getName());
                                            cdaAnalaysisInput.getMetrics().add(AnalyzeCDAHandler.this.analyzePluginMode(file));
                                        }
                                        ++n2;
                                    }
                                }
                            }
                            catch (PartInitException partInitException) {
                            }
                            catch (CoreException coreException) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                IWorkbench wb = PlatformUI.getWorkbench();
                IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                IWorkbenchPage page = win.getActivePage();
                IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().findEditor("org.eclipse.mdht.cda.xml.ui.editors.CDAAnalyzer2");
                page.openEditor((IEditorInput)cdaAnalaysisInput, desc.getId());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private int getMetric(ClinicalDocument cd, String ocl) throws Exception {
        HashSet o = (HashSet)CDAUtil.query((EObject)cd, (String)ocl);
        return o.size();
    }

    public CDAAnalaysisInput.CDAMetrics analyzePluginMode(IFile file) {
        CDAAnalaysisInput.CDAMetrics cdaMetrics = new CDAAnalaysisInput.CDAMetrics();
        cdaMetrics.file = file;
        cdaMetrics.fileName = file.getName();
        try {
            URI cdaURI = URI.createFileURI((String)file.getLocation().toOSString());
            Handler handler = new Handler();
            ClinicalDocument cd = CDAUtil.load((URI)cdaURI, (CDAUtil.ValidationHandler)handler);
            cdaMetrics.totalErrors = handler.errorCount;
            cdaMetrics.totalSections = cd.getSections().size();
            for (Section section : cd.getAllSections()) {
                cdaMetrics.totalEntries += section.getEntries().size();
            }
            cdaMetrics.totalCodedElements = this.getMetric(cd, "datatypes::CD.allInstances()");
            cdaMetrics.totalClinicalStatements = this.getMetric(cd, "cda::ClinicalStatement.allInstances()");
            LinkedHashMap<String, String> codedMetrics = this.getCodedMetrics();
            cdaMetrics.codedMetricsCount = codedMetrics.size();
            for (String key : ((HashMap)codedMetrics).keySet()) {
                String ocl = (String)((HashMap)codedMetrics).get(key);
                Object o = CDAUtil.query((EObject)cd, (String)ocl);
                if (o instanceof Collection && !((Collection)o).isEmpty()) {
                    ++cdaMetrics.totalCodedMetrics;
                    cdaMetrics.codedMetrics.put(key, Boolean.TRUE);
                    continue;
                }
                cdaMetrics.codedMetrics.put(key, Boolean.FALSE);
            }
            cd.eResource().unload();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return cdaMetrics;
    }

    private LinkedHashMap<String, String> getCodedMetrics() {
        LinkedHashMap<String, String> codedMetrics;
        block18: {
            codedMetrics = new LinkedHashMap<String, String>();
            BufferedReader br = null;
            String line = "";
            String cvsSplitBy = ",";
            try {
                try {
                    if (this.codeMetricsFile != null) {
                        br = new BufferedReader(new FileReader(this.codeMetricsFile.getLocation().toOSString()));
                        while ((line = br.readLine()) != null) {
                            String[] s = line.split(cvsSplitBy);
                            if (s.length != 2) continue;
                            codedMetrics.put(s[0], s[1]);
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (br == null) break block18;
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (IOException iOException) {
                    if (br == null) break block18;
                    try {
                        br.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return codedMetrics;
    }

    public static class CDAAnalaysisInput
    implements IEditorInput {
        public ArrayList<CDAMetrics> metrics = new ArrayList();

        public ArrayList<CDAMetrics> getMetrics() {
            return this.metrics;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public boolean exists() {
            return false;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return "MDHT CDA Batch Analyzer";
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            return "MDHT CDA Batch Analyzer";
        }

        public static class CDAMetrics {
            public String fileName;
            public int totalSections;
            public int totalErrors;
            public int totalEntries;
            public int totalCodedElements;
            public int totalCodedMetrics;
            public int codedMetricsCount;
            public int totalClinicalStatements;
            public LinkedHashMap<String, Boolean> codedMetrics = new LinkedHashMap();
            public IFile file;
        }
    }

    class Handler
    implements CDAUtil.ValidationHandler {
        public int errorCount = 0;

        Handler() {
        }

        public void handleError(Diagnostic diagnostic) {
            ++this.errorCount;
        }

        public void handleWarning(Diagnostic diagnostic) {
        }

        public void handleInfo(Diagnostic diagnostic) {
        }

        public boolean isCaptureValidationStatistics() {
            return false;
        }

        public DatatypesUtil.ValidationStatistics getValidationStatistics() {
            return null;
        }

        public void setValidationStatistics(DatatypesUtil.ValidationStatistics validationStatistics) {
        }
    }
}

