/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.navigator.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.ui.navigator.internal.l10n.Messages;
import org.eclipse.mdht.uml.ui.navigator.internal.plugin.Logger;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.uml2.uml.resource.XMI2UMLExtendedMetaData;
import org.eclipse.uml2.uml.resource.XMI2UMLResource;

public class ExportToXMIAction
extends ActionDelegate
implements IObjectActionDelegate {
    protected IWorkbenchPart activePart = null;
    protected List<URI> resourceURIs = new ArrayList<URI>();

    public void dispose() {
        this.resourceURIs = null;
        super.dispose();
    }

    public void run(IAction action) {
        DirectoryDialog dialog = new DirectoryDialog(this.activePart.getSite().getShell(), 0);
        dialog.setMessage(Messages.ExportToXMIAction_dialogMessage);
        dialog.setText(Messages.ExportToXMIAction_dialogTitle);
        String directoryPath = dialog.open();
        if (directoryPath != null) {
            try {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Map contentTypeToFactoryMap = resourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap();
                contentTypeToFactoryMap.put("org.omg.uml_2_5", XMI2UMLResource.Factory.INSTANCE);
                Map uriMap = resourceSet.getURIConverter().getURIMap();
                uriMap.putAll(XMI2UMLExtendedMetaData.getURIMap());
                for (URI resourceURI : this.resourceURIs) {
                    resourceSet.getResource(resourceURI, true);
                }
                EcoreUtil.resolveAll((ResourceSet)resourceSet);
                EList resources = resourceSet.getResources();
                for (Resource resource : resources) {
                    EList resourceContents = resource.getContents();
                    for (Resource controlledResource : UMLUtil.getControlledResources((Resource)resource)) {
                        ListIterator contentsIterator = controlledResource.getContents().listIterator();
                        while (contentsIterator.hasNext()) {
                            EObject next = (EObject)contentsIterator.next();
                            contentsIterator.remove();
                            if (next.eContainer() != null) continue;
                            resourceContents.add((Object)next);
                        }
                    }
                }
                ListIterator resourcesIterator = resources.listIterator();
                while (resourcesIterator.hasNext()) {
                    if (!((Resource)resourcesIterator.next()).getContents().isEmpty()) continue;
                    resourcesIterator.remove();
                }
                UniqueEList exportedResources = new UniqueEList();
                URI destinationURI = URI.createFileURI((String)directoryPath);
                int i = 0;
                while (i < resources.size()) {
                    Resource resource = (Resource)resources.get(i);
                    if (this.shouldExport(resource)) {
                        exportedResources.add((Object)this.exportResource((ResourceSet)resourceSet, resource, destinationURI));
                    }
                    ++i;
                }
                for (Resource resource : exportedResources) {
                    resource.save(null);
                }
            }
            catch (Exception e) {
                String message = NLS.bind((String)Messages.ExportToXMIAction_errorMessage, (Object[])new String[]{e.getLocalizedMessage()});
                Logger.logException(message, e);
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.ExportToXMIAction_errorTitle, (String)message);
            }
        }
    }

    protected boolean shouldExport(Resource resource) {
        URI resourceURI = resource.getURI();
        return "uml".equals(resourceURI.fileExtension()) && !URI.createURI((String)"pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml").equals(resourceURI) && !URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml").equals(resourceURI) && !URI.createURI((String)"pathmap://UML_PROFILES/Ecore.profile.uml").equals(resourceURI);
    }

    protected Resource exportResource(ResourceSet resourceSet, Resource resource, URI destinationURI) {
        URI xmiURI = destinationURI.appendSegment(resource.getURI().lastSegment()).trimFileExtension().appendFileExtension("xmi");
        Resource xmiResource = resourceSet.createResource(xmiURI, "org.omg.uml_2_5");
        EList xmiContents = xmiResource.getContents();
        Iterator contents = resource.getContents().iterator();
        while (contents.hasNext()) {
            EObject next = (EObject)contents.next();
            contents.remove();
            xmiContents.add((Object)next);
        }
        EList resources = resourceSet.getResources();
        int index = resources.indexOf((Object)resource);
        resources.remove(index);
        resources.move(index, (Object)xmiResource);
        return xmiResource;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.resourceURIs.clear();
        if (selection instanceof IStructuredSelection) {
            for (Object element : ((IStructuredSelection)selection).toList()) {
                try {
                    this.resourceURIs.add(URI.createPlatformResourceURI((String)((IFile)element).getFullPath().toString(), (boolean)true));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        action.setEnabled(!this.resourceURIs.isEmpty());
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.activePart = targetPart;
    }
}

