/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.hl7.vocab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EntityNamePartQualifier implements Enumerator
{
    AC(0, "AC", "AC"),
    AD(1, "AD", "AD"),
    BR(2, "BR", "BR"),
    CL(3, "CL", "CL"),
    IN(4, "IN", "IN"),
    LS(5, "LS", "LS"),
    NB(6, "NB", "NB"),
    PR(7, "PR", "PR"),
    SP(8, "SP", "SP"),
    TITLE(9, "TITLE", "TITLE"),
    VV(10, "VV", "VV");

    public static final int AC_VALUE = 0;
    public static final int AD_VALUE = 1;
    public static final int BR_VALUE = 2;
    public static final int CL_VALUE = 3;
    public static final int IN_VALUE = 4;
    public static final int LS_VALUE = 5;
    public static final int NB_VALUE = 6;
    public static final int PR_VALUE = 7;
    public static final int SP_VALUE = 8;
    public static final int TITLE_VALUE = 9;
    public static final int VV_VALUE = 10;
    private static final EntityNamePartQualifier[] VALUES_ARRAY;
    public static final List<EntityNamePartQualifier> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EntityNamePartQualifier[]{AC, AD, BR, CL, IN, LS, NB, PR, SP, TITLE, VV};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EntityNamePartQualifier get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EntityNamePartQualifier result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EntityNamePartQualifier getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EntityNamePartQualifier result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EntityNamePartQualifier get(int value) {
        switch (value) {
            case 0: {
                return AC;
            }
            case 1: {
                return AD;
            }
            case 2: {
                return BR;
            }
            case 3: {
                return CL;
            }
            case 4: {
                return IN;
            }
            case 5: {
                return LS;
            }
            case 6: {
                return NB;
            }
            case 7: {
                return PR;
            }
            case 8: {
                return SP;
            }
            case 9: {
                return TITLE;
            }
            case 10: {
                return VV;
            }
        }
        return null;
    }

    private EntityNamePartQualifier(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

