/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.properties.internal.sections;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mdht.uml.common.ui.dialogs.DialogLaunchUtil;
import org.eclipse.mdht.uml.common.ui.search.IElementFilter;
import org.eclipse.mdht.uml.common.ui.search.PropertyTypeFilter;
import org.eclipse.mdht.uml.common.ui.search.StereotypePropertyTypeFilter;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.ui.properties.sections.WrapperAwareModelerPropertySection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class PropertySection
extends WrapperAwareModelerPropertySection {
    private Property property;
    private CLabel typeName;
    private Button typeButton;
    private CCombo multiplicityCombo;
    private boolean multiplicityModified = false;
    private CCombo aggregationCombo;
    private boolean aggregationModified = false;
    private Button isDerived;
    private boolean isDerivedModified = false;
    private Button isReadOnly;
    private boolean isReadOnlyModified = false;
    private Button isOrdered;
    private boolean isOrderedModified = false;
    private Button isUnique;
    private boolean isUniqueModified = false;
    private List<Property> inheritedProperties;
    private List<Property> inheritedCollectionProperties;
    private CCombo redefinesCombo;
    private boolean redefinesModified = false;
    private CCombo subsetsCombo;
    private boolean subsetsModified = false;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if ('\r' == e.character || '\u1000050' == e.character) {
                PropertySection.this.modifyFields();
            }
        }
    };
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent event) {
            PropertySection.this.modifyFields();
        }
    };

    private void modifyFields() {
        if (!(this.multiplicityModified || this.aggregationModified || this.isDerivedModified || this.isReadOnlyModified || this.isUniqueModified || this.isOrderedModified || this.redefinesModified || this.subsetsModified)) {
            return;
        }
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.property);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    if (PropertySection.this.multiplicityModified) {
                        PropertySection.this.multiplicityModified = false;
                        this.setLabel("Set Multiplicity");
                        try {
                            PropertySection.this.setMultiplicity((MultiplicityElement)PropertySection.this.property, PropertySection.this.multiplicityCombo.getText());
                        }
                        catch (IllegalArgumentException e) {
                            return Status.CANCEL_STATUS;
                        }
                    } else if (PropertySection.this.aggregationModified) {
                        PropertySection.this.aggregationModified = false;
                        this.setLabel("Set Aggregation");
                        try {
                            PropertySection.this.property.setAggregation(AggregationKind.get((String)PropertySection.this.aggregationCombo.getText()));
                        }
                        catch (IllegalArgumentException e) {
                            return Status.CANCEL_STATUS;
                        }
                    } else if (PropertySection.this.isDerivedModified) {
                        PropertySection.this.isDerivedModified = false;
                        this.setLabel("Set Derived");
                        PropertySection.this.property.setIsDerived(PropertySection.this.isDerived.getSelection());
                    } else if (PropertySection.this.isReadOnlyModified) {
                        PropertySection.this.isReadOnlyModified = false;
                        this.setLabel("Set ReadOnly");
                        PropertySection.this.property.setIsReadOnly(PropertySection.this.isReadOnly.getSelection());
                    } else if (PropertySection.this.isUniqueModified) {
                        PropertySection.this.isUniqueModified = false;
                        this.setLabel("Set Unique");
                        PropertySection.this.property.setIsUnique(PropertySection.this.isUnique.getSelection());
                    } else if (PropertySection.this.isOrderedModified) {
                        PropertySection.this.isOrderedModified = false;
                        this.setLabel("Set Ordered");
                        PropertySection.this.property.setIsOrdered(PropertySection.this.isOrdered.getSelection());
                    } else if (PropertySection.this.redefinesModified) {
                        PropertySection.this.redefinesModified = false;
                        PropertySection.this.property.getRedefinedProperties().clear();
                        if (PropertySection.this.redefinesCombo.getSelectionIndex() > 0) {
                            Property redefined = (Property)PropertySection.this.inheritedProperties.get(PropertySection.this.redefinesCombo.getSelectionIndex() - 1);
                            PropertySection.this.property.getRedefinedProperties().add((Object)redefined);
                            PropertySection.this.property.getSubsettedProperties().clear();
                            PropertySection.this.subsetsCombo.select(0);
                        }
                    } else if (PropertySection.this.subsetsModified) {
                        PropertySection.this.subsetsModified = false;
                        PropertySection.this.property.getSubsettedProperties().clear();
                        if (PropertySection.this.subsetsCombo.getSelectionIndex() > 0) {
                            Property subsetted = (Property)PropertySection.this.inheritedCollectionProperties.get(PropertySection.this.subsetsCombo.getSelectionIndex() - 1);
                            PropertySection.this.property.getSubsettedProperties().add((Object)subsetted);
                            PropertySection.this.property.getRedefinedProperties().clear();
                            PropertySection.this.redefinesCombo.select(0);
                        }
                    } else {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private void openPropertyTypeDialog(final Property property) {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)property);
        Package topPackage = UMLUtil.getTopPackage((Element)property);
        Object type = null;
        type = topPackage instanceof Profile ? (property.getAssociation() instanceof Extension ? DialogLaunchUtil.chooseUMLMetaclass((ResourceSet)editingDomain.getResourceSet(), (Shell)this.getPart().getSite().getShell()) : (property.getClass_() instanceof Stereotype ? DialogLaunchUtil.chooseElement((IElementFilter)new StereotypePropertyTypeFilter(), (Package)topPackage, (Shell)this.getPart().getSite().getShell()) : DialogLaunchUtil.chooseElement((IElementFilter)new PropertyTypeFilter(), (Package)topPackage, (Shell)this.getPart().getSite().getShell()))) : DialogLaunchUtil.chooseElement((IElementFilter)new PropertyTypeFilter(), (Package)topPackage, (Shell)this.getPart().getSite().getShell());
        if (type instanceof Classifier) {
            final Classifier classifier = (Classifier)type;
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "Set Type"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    property.setType((Type)classifier);
                    if (property.getAssociation() instanceof Extension && classifier instanceof Class) {
                        Class metaclass = (Class)classifier;
                        Profile profile = (Profile)property.getAssociation().getPackage();
                        if (!profile.getReferencedMetaclasses().contains((Object)metaclass) && !profile.getReferencedMetamodels().contains((Object)metaclass.getModel())) {
                            profile.createMetaclassReference((PackageableElement)metaclass);
                        }
                    }
                    Class owner = property.getClass_();
                    int position = owner.getOwnedAttributes().lastIndexOf((Object)property);
                    owner.getOwnedAttributes().remove((Object)property);
                    owner.getOwnedAttributes().add(position, (Object)property);
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
    }

    private void computeInheritedProperties() {
        this.inheritedProperties = new ArrayList<Property>();
        this.inheritedCollectionProperties = new ArrayList<Property>();
        if (this.property.getClass_() != null) {
            for (Classifier parent : this.property.getClass_().allParents()) {
                for (Property inherited : ((Class)parent).getOwnedAttributes()) {
                    this.inheritedProperties.add(inherited);
                    if (inherited.upperBound() <= 1 && inherited.upperBound() != -1) continue;
                    this.inheritedCollectionProperties.add(inherited);
                }
            }
        }
    }

    private void fillInheritedPropertiesCombo(CCombo propertiesCombo, List<Property> properties) {
        propertiesCombo.removeAll();
        ArrayList<String> items = new ArrayList<String>();
        items.add("");
        for (Property inherited : properties) {
            items.add(UMLUtil.getPackageQualifiedName((NamedElement)inherited));
        }
        propertiesCombo.setItems(items.toArray(new String[items.size()]));
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        FormData data = null;
        Shell shell = new Shell();
        GC gc = new GC((Drawable)shell);
        gc.setFont(shell.getFont());
        Point point = gc.textExtent("");
        int buttonHeight = point.y + 10;
        gc.dispose();
        shell.dispose();
        CLabel typeLabel = this.getWidgetFactory().createCLabel(composite, "Type:");
        this.typeName = this.getWidgetFactory().createCLabel(composite, "");
        this.typeButton = this.getWidgetFactory().createButton(composite, "Select Type...", 8);
        this.typeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PropertySection.this.openPropertyTypeDialog(PropertySection.this.property);
            }
        });
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.typeName, -5);
        data.top = new FormAttachment(0, 0);
        typeLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 105);
        data.right = new FormAttachment((Control)this.typeButton, -5);
        data.top = new FormAttachment(0, 0);
        this.typeName.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(80, 0);
        data.top = new FormAttachment(0, 0);
        data.height = buttonHeight;
        this.typeButton.setLayoutData((Object)data);
        CLabel multiplicityLabel = this.getWidgetFactory().createCLabel(composite, "Multiplicity:");
        this.multiplicityCombo = this.getWidgetFactory().createCCombo(composite, 0x800000);
        this.multiplicityCombo.setItems(new String[]{"*", "0..1", "1", "1..*"});
        this.multiplicityCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PropertySection.this.multiplicityModified = true;
                PropertySection.this.modifyFields();
            }

            public void widgetSelected(SelectionEvent e) {
                PropertySection.this.multiplicityModified = true;
                PropertySection.this.modifyFields();
            }
        });
        data = new FormData();
        data.left = new FormAttachment((Control)this.typeButton, 5);
        data.right = new FormAttachment((Control)this.multiplicityCombo, -5);
        data.top = new FormAttachment(0, 0);
        multiplicityLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.typeButton, 90);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        this.multiplicityCombo.setLayoutData((Object)data);
        this.isDerived = this.getWidgetFactory().createButton(composite, "Derived", 32);
        this.isDerived.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PropertySection.this.isDerivedModified = true;
                PropertySection.this.modifyFields();
            }

            public void widgetSelected(SelectionEvent e) {
                PropertySection.this.isDerivedModified = true;
                PropertySection.this.modifyFields();
            }
        });
        this.isReadOnly = this.getWidgetFactory().createButton(composite, "Read Only", 32);
        this.isReadOnly.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PropertySection.this.isReadOnlyModified = true;
                PropertySection.this.modifyFields();
            }

            public void widgetSelected(SelectionEvent e) {
                PropertySection.this.isReadOnlyModified = true;
                PropertySection.this.modifyFields();
            }
        });
        this.isUnique = this.getWidgetFactory().createButton(composite, "Unique", 32);
        this.isUnique.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PropertySection.this.isUniqueModified = true;
                PropertySection.this.modifyFields();
            }

            public void widgetSelected(SelectionEvent e) {
                PropertySection.this.isUniqueModified = true;
                PropertySection.this.modifyFields();
            }
        });
        this.isOrdered = this.getWidgetFactory().createButton(composite, "Ordered", 32);
        this.isOrdered.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PropertySection.this.isOrderedModified = true;
                PropertySection.this.modifyFields();
            }

            public void widgetSelected(SelectionEvent e) {
                PropertySection.this.isOrderedModified = true;
                PropertySection.this.modifyFields();
            }
        });
        this.aggregationCombo = this.getWidgetFactory().createCCombo(composite, 0x800008);
        this.aggregationCombo.setItems(new String[]{AggregationKind.NONE_LITERAL.getName(), AggregationKind.SHARED_LITERAL.getName(), AggregationKind.COMPOSITE_LITERAL.getName()});
        this.aggregationCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PropertySection.this.aggregationModified = true;
                PropertySection.this.modifyFields();
            }

            public void widgetSelected(SelectionEvent e) {
                PropertySection.this.aggregationModified = true;
                PropertySection.this.modifyFields();
            }
        });
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.top = new FormAttachment((Control)this.aggregationCombo, 0, 0x1000000);
        this.isDerived.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.isDerived, 5);
        data.top = new FormAttachment((Control)this.aggregationCombo, 0, 0x1000000);
        this.isReadOnly.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.isReadOnly, 5);
        data.top = new FormAttachment((Control)this.aggregationCombo, 0, 0x1000000);
        this.isUnique.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.isUnique, 5);
        data.top = new FormAttachment((Control)this.aggregationCombo, 0, 0x1000000);
        this.isOrdered.setLayoutData((Object)data);
        CLabel aggregationLabel = this.getWidgetFactory().createCLabel(composite, "Aggregation:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.isOrdered, 5);
        data.top = new FormAttachment((Control)this.aggregationCombo, 0, 0x1000000);
        aggregationLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.isOrdered, 90);
        data.top = new FormAttachment(1, 3, 6);
        this.aggregationCombo.setLayoutData((Object)data);
        CLabel redefinesLabel = this.getWidgetFactory().createCLabel(composite, "Redefines:");
        this.redefinesCombo = this.getWidgetFactory().createCCombo(composite, 0x800000);
        this.redefinesCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PropertySection.this.redefinesModified = true;
                PropertySection.this.modifyFields();
            }

            public void widgetSelected(SelectionEvent e) {
                PropertySection.this.redefinesModified = true;
                PropertySection.this.modifyFields();
            }
        });
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(2, 3, 6);
        redefinesLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)redefinesLabel, 5);
        data.right = new FormAttachment(50, 0);
        data.top = new FormAttachment(2, 3, 6);
        this.redefinesCombo.setLayoutData((Object)data);
        CLabel subsetsLabel = this.getWidgetFactory().createCLabel(composite, "Subsets:");
        this.subsetsCombo = this.getWidgetFactory().createCCombo(composite, 0x800000);
        this.subsetsCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PropertySection.this.subsetsModified = true;
                PropertySection.this.modifyFields();
            }

            public void widgetSelected(SelectionEvent e) {
                PropertySection.this.subsetsModified = true;
                PropertySection.this.modifyFields();
            }
        });
        data = new FormData();
        data.left = new FormAttachment((Control)this.redefinesCombo, 5);
        data.top = new FormAttachment(2, 3, 6);
        subsetsLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)subsetsLabel, 5);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(2, 3, 6);
        this.subsetsCombo.setLayoutData((Object)data);
    }

    @Override
    protected boolean isReadOnly() {
        TransactionalEditingDomain editingDomain;
        if (this.property != null && (editingDomain = TransactionUtil.getEditingDomain((EObject)this.property)) != null && editingDomain.isReadOnly(this.property.eResource())) {
            return true;
        }
        return super.isReadOnly();
    }

    protected boolean addToEObjectList(Object object) {
        boolean added = super.addToEObjectList(object);
        if (!added && object instanceof Element) {
            this.getEObjectList().add(object);
            added = true;
        }
        return added;
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        EObject element = this.getEObject();
        if (element instanceof View) {
            element = ((View)element).getElement();
        }
        if (element instanceof Association) {
            element = UMLUtil.getNavigableEnd((Association)((Association)element));
        }
        this.property = element instanceof Property ? (Property)element : null;
    }

    public void dispose() {
        super.dispose();
        this.property = null;
    }

    public void refresh() {
        Property subsetted;
        Property redefined;
        int index;
        if (this.property == null) {
            return;
        }
        if (this.property.getType() != null && this.property.getType().getName() != null) {
            this.typeName.setText(this.property.getType().getQualifiedName());
        } else {
            this.typeName.setText("");
        }
        this.multiplicityCombo.setText(this.displayMultiplicity((MultiplicityElement)this.property));
        this.aggregationCombo.setText(this.property.getAggregation().getName());
        this.isDerived.setSelection(this.property.isDerived());
        this.isReadOnly.setSelection(this.property.isReadOnly());
        this.isUnique.setSelection(this.property.isUnique());
        this.isOrdered.setSelection(this.property.isOrdered());
        this.computeInheritedProperties();
        this.fillInheritedPropertiesCombo(this.redefinesCombo, this.inheritedProperties);
        this.fillInheritedPropertiesCombo(this.subsetsCombo, this.inheritedCollectionProperties);
        this.redefinesCombo.select(0);
        this.subsetsCombo.select(0);
        if (this.property.getRedefinedProperties().size() == 1 && (index = this.inheritedProperties.indexOf(redefined = (Property)this.property.getRedefinedProperties().get(0))) >= 0) {
            this.redefinesCombo.select(index + 1);
        }
        if (this.property.getSubsettedProperties().size() == 1 && (index = this.inheritedCollectionProperties.indexOf(subsetted = (Property)this.property.getSubsettedProperties().get(0))) >= 0) {
            this.subsetsCombo.select(index + 1);
        }
        if (this.isReadOnly()) {
            this.isDerived.setEnabled(false);
            this.isReadOnly.setEnabled(false);
            this.isUnique.setEnabled(false);
            this.isOrdered.setEnabled(false);
            this.typeButton.setEnabled(false);
            this.multiplicityCombo.setEnabled(false);
            this.aggregationCombo.setEnabled(false);
            this.redefinesCombo.setEnabled(false);
            this.subsetsCombo.setEnabled(false);
        } else {
            this.isDerived.setEnabled(true);
            this.isReadOnly.setEnabled(true);
            this.isUnique.setEnabled(true);
            this.isOrdered.setEnabled(true);
            this.typeButton.setEnabled(true);
            this.multiplicityCombo.setEnabled(true);
            this.aggregationCombo.setEnabled(true);
            this.redefinesCombo.setEnabled(true);
            this.subsetsCombo.setEnabled(true);
        }
    }

    public void update(final Notification notification, EObject element) {
        if (!this.isDisposed()) {
            this.postUpdateRequest(new Runnable(){

                @Override
                public void run() {
                    if (!PropertySection.this.isDisposed() && !PropertySection.this.isNotifierDeleted(notification)) {
                        PropertySection.this.refresh();
                    }
                }
            });
        }
    }

    protected String displayMultiplicity(MultiplicityElement multElement) {
        StringBuffer multDisplay = new StringBuffer();
        multDisplay.append(multElement.getLower());
        multDisplay.append("..");
        multDisplay.append(multElement.getUpper() == -1 ? "*" : Integer.toString(multElement.getUpper()));
        return multDisplay.toString();
    }

    private void setMultiplicity(MultiplicityElement multiplicityElement, String value) {
        int lower = 1;
        int upper = 1;
        StringTokenizer stk = new StringTokenizer(value, ". ");
        if (stk.hasMoreTokens()) {
            lower = this.parseMultiplicityRangeToken(stk.nextToken());
            if (!stk.hasMoreTokens()) {
                if (lower == -1) {
                    lower = 0;
                    upper = -1;
                } else {
                    upper = lower;
                }
            } else {
                upper = this.parseMultiplicityRangeToken(stk.nextToken());
                if (stk.hasMoreTokens()) {
                    throw new IllegalArgumentException("illegal range specification: " + value);
                }
            }
        }
        if (multiplicityElement.getLowerValue() != null) {
            multiplicityElement.getLowerValue().destroy();
        }
        if (multiplicityElement.getUpperValue() != null) {
            multiplicityElement.getUpperValue().destroy();
        }
        multiplicityElement.setUpper(upper);
        multiplicityElement.setLower(lower);
    }

    private int parseMultiplicityRangeToken(String token) {
        block3: {
            try {
                if (!token.equalsIgnoreCase("n") && !token.equals("*") && !token.equalsIgnoreCase("unbounded")) break block3;
                return -1;
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("illegal range bound: " + token);
            }
        }
        return Integer.parseInt(token);
    }
}

