/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.resolver;

import io.netty.resolver.AddressResolverGroup;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.impl.resolver.DefaultResolverProvider;
import io.vertx.core.impl.resolver.DnsResolverProvider;
import java.net.InetSocketAddress;

public interface ResolverProvider {
    public static final String DISABLE_DNS_RESOLVER_PROP_NAME = "vertx.disableDnsResolver";

    public static ResolverProvider factory(Vertx vertx, AddressResolverOptions options) {
        try {
            if (!Boolean.getBoolean(DISABLE_DNS_RESOLVER_PROP_NAME)) {
                return DnsResolverProvider.create((VertxInternal)vertx, options);
            }
        }
        catch (Throwable e) {
            if (e instanceof VertxException) {
                throw e;
            }
            Logger logger2 = LoggerFactory.getLogger(ResolverProvider.class);
            logger2.info("Using the default address resolver as the dns resolver could not be loaded");
        }
        return new DefaultResolverProvider();
    }

    public AddressResolverGroup<InetSocketAddress> resolver(AddressResolverOptions var1);

    public void close(Handler<Void> var1);
}

