/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.undoredo;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.ActionHandler;
import org.eclipse.glsp.server.features.core.model.ModelSubmissionHandler;
import org.eclipse.glsp.server.features.undoredo.RedoAction;
import org.eclipse.glsp.server.features.undoredo.UndoAction;
import org.eclipse.glsp.server.model.GModelState;

public class UndoRedoActionHandler
implements ActionHandler {
    protected static final Logger LOGGER = LogManager.getLogger(UndoRedoActionHandler.class);
    @Inject
    protected ModelSubmissionHandler modelSubmissionHandler;
    @Inject
    protected GModelState modelState;

    @Override
    public List<Action> execute(Action action) {
        if (action instanceof UndoAction && this.modelState.canUndo()) {
            this.modelState.undo();
            return this.modelSubmissionHandler.submitModel("undo");
        }
        if (action instanceof RedoAction && this.modelState.canRedo()) {
            this.modelState.redo();
            return this.modelSubmissionHandler.submitModel("redo");
        }
        LOGGER.warn("Cannot undo or redo");
        return this.none();
    }

    @Override
    public List<Class<? extends Action>> getHandledActionTypes() {
        return Lists.newArrayList((Object[])new Class[]{UndoAction.class, RedoAction.class});
    }
}

