/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import com.sun.webui.jsf.util.LogUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class FacesMessageUtils {
    public static Iterator getMessageIterator(FacesContext context, String forComponentId, UIComponent msgComponent) {
        Iterator messageIterator = null;
        if (forComponentId != null) {
            if (forComponentId.length() == 0) {
                messageIterator = context.getMessages(null);
            } else {
                UIComponent forComponent = FacesMessageUtils.getForComponent(context, forComponentId, msgComponent);
                if (forComponent != null) {
                    String clientId = forComponent.getClientId(context);
                    messageIterator = context.getMessages(clientId);
                } else {
                    messageIterator = Collections.EMPTY_LIST.iterator();
                }
            }
        } else {
            messageIterator = context.getMessages();
        }
        return messageIterator;
    }

    private static UIComponent getForComponent(FacesContext context, String forComponentId, UIComponent msgComponent) {
        if (forComponentId == null || forComponentId.length() == 0) {
            return null;
        }
        UIComponent forComponent = null;
        try {
            for (UIComponent currentParent = msgComponent; currentParent != null && (forComponent = currentParent.findComponent(forComponentId)) == null; currentParent = currentParent.getParent()) {
            }
            if (forComponent == null) {
                forComponent = FacesMessageUtils.findUIComponentBelow((UIComponent)context.getViewRoot(), forComponentId);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (forComponent == null && LogUtil.warningEnabled(FacesMessageUtils.class)) {
            LogUtil.warning(FacesMessageUtils.class, "FacesMesageUtils.componentNotFound", forComponentId);
        }
        return forComponent;
    }

    private static UIComponent findUIComponentBelow(UIComponent startComponent, String forComponentId) {
        UIComponent forComponent = null;
        List children = startComponent.getChildren();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            UIComponent comp = (UIComponent)children.get(i);
            if (comp instanceof NamingContainer) {
                forComponent = comp.findComponent(forComponentId);
            }
            if (forComponent == null && comp.getChildCount() > 0) {
                forComponent = FacesMessageUtils.findUIComponentBelow(comp, forComponentId);
            }
            if (forComponent != null) break;
        }
        return forComponent;
    }
}

