/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dse;

import fr.inria.diverse.k3.al.annotationprocessor.InitializeModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.commons.ConcurrentModelExecutionContext;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.concurrentmse.FeedbackMSE;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dse.ASynchroneExecution;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dse.DefaultMSEStateController;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dse.OperationExecution;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dse.SynchroneExecution;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IConcurrentExecutionContext;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IConcurrentExecutionEngine;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IConcurrentExecutionPlatform;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IConcurrentRunConfiguration;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IFutureAction;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.ILogicalStepDecider;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dsa.executors.CodeExecutionException;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dsa.executors.ICodeExecutor;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dse.IMSEStateController;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.moc.ISolver;
import org.eclipse.gemoc.executionframework.engine.Activator;
import org.eclipse.gemoc.executionframework.engine.core.AbstractExecutionEngine;
import org.eclipse.gemoc.executionframework.engine.core.CommandExecution;
import org.eclipse.gemoc.executionframework.engine.core.EngineStoppedException;
import org.eclipse.gemoc.moccml.mapping.feedback.feedback.ActionModel;
import org.eclipse.gemoc.moccml.mapping.feedback.feedback.When;
import org.eclipse.gemoc.trace.commons.model.trace.MSE;
import org.eclipse.gemoc.trace.commons.model.trace.ParallelStep;
import org.eclipse.gemoc.trace.commons.model.trace.SmallStep;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.xdsmlframework.api.core.EngineStatus;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionContext;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;

public class ConcurrentExecutionEngine
extends AbstractExecutionEngine<IConcurrentExecutionContext, IConcurrentRunConfiguration>
implements IConcurrentExecutionEngine {
    protected IMSEStateController _mseStateController;
    protected ILogicalStepDecider _logicalStepDecider;
    protected List<Step<?>> _possibleLogicalSteps = new ArrayList();
    protected Step<?> _selectedLogicalStep;
    protected ISolver _solver;
    protected ArrayList<IFutureAction> _futureActions = new ArrayList();
    protected Object _futureActionsLock = new Object();

    public ConcurrentExecutionEngine(IConcurrentExecutionContext concurrentexecutionContext, ISolver s) throws CoreException {
        this._solver = s;
        this.initialize((IExecutionContext)concurrentexecutionContext);
    }

    private void switchDeciderIfNecessary() {
        if (this.getLogicalStepDecider() != null && this.getLogicalStepDecider() != this._logicalStepDecider) {
            this._logicalStepDecider = this.getLogicalStepDecider();
        }
    }

    public ILogicalStepDecider getLogicalStepDecider() {
        return this._logicalStepDecider;
    }

    public void changeLogicalStepDecider(ILogicalStepDecider newDecider) {
        this._logicalStepDecider = newDecider;
    }

    public void computePossibleLogicalSteps() {
        this._possibleLogicalSteps = this.getSolver().computeAndGetPossibleLogicalSteps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePossibleLogicalSteps() {
        for (IMSEStateController c : ((IConcurrentExecutionPlatform)this.getConcurrentExecutionContext().getExecutionPlatform()).getMSEStateControllers()) {
            c.applyMSEFutureStates(this.getSolver());
        }
        ConcurrentExecutionEngine concurrentExecutionEngine = this;
        synchronized (concurrentExecutionEngine) {
            this._possibleLogicalSteps = this.getSolver().updatePossibleLogicalSteps();
        }
    }

    public void recomputePossibleLogicalSteps() {
        this.getSolver().revertForceClockEffect();
        this.updatePossibleLogicalSteps();
        this.notifyProposedLogicalStepsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Step<?>> getPossibleLogicalSteps() {
        ConcurrentExecutionEngine concurrentExecutionEngine = this;
        synchronized (concurrentExecutionEngine) {
            return new ArrayList(this._possibleLogicalSteps);
        }
    }

    protected final void performStop() {
        this.setSelectedLogicalStep(null);
        if (this.getLogicalStepDecider() != null) {
            this.getLogicalStepDecider().preempt();
        }
    }

    public void notifyLogicalStepSelected() {
        for (IEngineAddon addon : ((IConcurrentExecutionPlatform)((IConcurrentExecutionContext)this.getExecutionContext()).getExecutionPlatform()).getEngineAddons()) {
            try {
                addon.stepSelected((IExecutionEngine)this, this.getSelectedLogicalStep());
            }
            catch (Exception e) {
                Activator.getDefault().error("Exception in Addon " + addon + ", " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void notifyAboutToSelectLogicalStep() {
        for (IEngineAddon addon : ((IConcurrentExecutionPlatform)((IConcurrentExecutionContext)this.getExecutionContext()).getExecutionPlatform()).getEngineAddons()) {
            try {
                addon.aboutToSelectStep((IExecutionEngine)this, this.getPossibleLogicalSteps());
            }
            catch (Exception e) {
                Activator.getDefault().error("Exception in Addon " + addon + ", " + e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Step<?> getSelectedLogicalStep() {
        ConcurrentExecutionEngine concurrentExecutionEngine = this;
        synchronized (concurrentExecutionEngine) {
            return this._selectedLogicalStep;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedLogicalStep(Step<?> ls) {
        ConcurrentExecutionEngine concurrentExecutionEngine = this;
        synchronized (concurrentExecutionEngine) {
            this._selectedLogicalStep = ls;
        }
    }

    public IConcurrentExecutionContext getConcurrentExecutionContext() {
        IExecutionContext context = this.getExecutionContext();
        if (context instanceof IConcurrentExecutionContext) {
            return (IConcurrentExecutionContext)context;
        }
        return null;
    }

    public ISolver getSolver() {
        return this._solver;
    }

    public void notifyProposedLogicalStepsChanged() {
        for (IEngineAddon addon : ((IConcurrentExecutionPlatform)((IConcurrentExecutionContext)this.getExecutionContext()).getExecutionPlatform()).getEngineAddons()) {
            try {
                addon.proposedStepsChanged((IExecutionEngine)this, this.getPossibleLogicalSteps());
            }
            catch (Exception e) {
                Activator.getDefault().error("Exception in Addon " + addon + ", " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "@[Executor=" + this.getCodeExecutor() + " ; Solver=" + this.getSolver() + " ; ModelResource=" + ((IConcurrentExecutionContext)this._executionContext).getResourceModel() + "]";
    }

    public void performExecutionStep() throws InterruptedException {
        this.switchDeciderIfNecessary();
        this.computePossibleLogicalSteps();
        this.updatePossibleLogicalSteps();
        if (this._possibleLogicalSteps.size() == 0) {
            Activator.getDefault().debug("No more LogicalStep to run");
            this.stop();
        } else {
            Step<?> selectedLogicalStep = this.selectAndExecuteLogicalStep();
            if (selectedLogicalStep != null) {
                this.getSolver().applyLogicalStep(selectedLogicalStep);
                this.engineStatus.incrementNbLogicalStepRun();
            }
        }
    }

    private Step<?> selectAndExecuteLogicalStep() throws InterruptedException {
        this.setEngineStatus(EngineStatus.RunStatus.WaitingLogicalStepSelection);
        this.notifyAboutToSelectLogicalStep();
        Step selectedLogicalStep = this.getLogicalStepDecider().decide((IConcurrentExecutionEngine)this, this.getPossibleLogicalSteps());
        if (selectedLogicalStep != null) {
            this.setSelectedLogicalStep(selectedLogicalStep);
            this.setEngineStatus(EngineStatus.RunStatus.Running);
            this.notifyLogicalStepSelected();
            this.executeSelectedLogicalStep();
        }
        return selectedLogicalStep;
    }

    public void executeSelectedLogicalStep() {
        if (!this._isStopped) {
            this.beforeExecutionStep(this._selectedLogicalStep);
            for (Step step : ((ParallelStep)this._selectedLogicalStep).getSubSteps()) {
                SmallStep sstep = (SmallStep)step;
                this.executeAssociatedActions(sstep.getMseoccurrence().getMse());
                this.executeSmallStep(sstep);
            }
            this.afterExecutionStep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAssociatedActions(MSE mse) {
        Object object = this._futureActionsLock;
        synchronized (object) {
            ArrayList<IFutureAction> actionsToRemove = new ArrayList<IFutureAction>();
            for (IFutureAction action : this._futureActions) {
                if (action.getTriggeringMSE() != mse) continue;
                actionsToRemove.add(action);
                action.perform();
            }
            this._futureActions.removeAll(actionsToRemove);
        }
    }

    private void executeSmallStep(SmallStep<?> smallStep) {
        MSE mse = smallStep.getMseoccurrence().getMse();
        if (mse.getAction() != null) {
            ArrayList<When> whenStatements = new ArrayList<When>();
            if (mse instanceof FeedbackMSE) {
                ActionModel feedbackModel = ((IConcurrentExecutionContext)this._executionContext).getFeedbackModel();
                for (When w : feedbackModel.getWhenStatements()) {
                    if (w.getSource() != ((FeedbackMSE)mse).getFeedbackModelSpecificEvent()) continue;
                    whenStatements.add(w);
                }
            }
            OperationExecution execution = null;
            Consumer<Step<?>> beforeStep = s -> this.beforeExecutionStep((Step)s);
            Runnable afterStep = () -> this.afterExecutionStep();
            execution = whenStatements.size() == 0 ? new SynchroneExecution(smallStep, this, beforeStep, afterStep) : new ASynchroneExecution(smallStep, whenStatements, this._mseStateController, this, beforeStep, afterStep);
            ((OperationExecution)execution).run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFutureAction(IFutureAction action) {
        Object object = this._futureActionsLock;
        synchronized (object) {
            this._futureActions.add(action);
        }
    }

    protected void performStart() {
        this.engineStatus.setNbLogicalStepRun(0L);
        try {
            while (!this._isStopped) {
                this.performExecutionStep();
            }
        }
        catch (EngineStoppedException ese) {
            throw ese;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void setSolver(ISolver solver) {
        this._solver = solver;
    }

    public ICodeExecutor getCodeExecutor() {
        return ((IConcurrentExecutionPlatform)this.getConcurrentExecutionContext().getExecutionPlatform()).getCodeExecutor();
    }

    protected final void finishDispose() {
        this._solver.dispose();
    }

    public final void performInitialize(IConcurrentExecutionContext executionContext) {
        if (!(executionContext instanceof IConcurrentExecutionContext)) {
            throw new IllegalArgumentException("executionContext must be an IConcurrentExecutionContext when used in ConcurrentExecutionEngine");
        }
        IConcurrentExecutionContext concurrentExecutionContext = this.getConcurrentExecutionContext();
        this._solver.setExecutableModelResource(concurrentExecutionContext.getResourceModel());
        this.changeLogicalStepDecider(concurrentExecutionContext.getLogicalStepDecider());
        this._mseStateController = new DefaultMSEStateController();
        ((IConcurrentExecutionPlatform)concurrentExecutionContext.getExecutionPlatform()).getMSEStateControllers().add(this._mseStateController);
        this.executeInitializeModelMethod(executionContext);
        ((ConcurrentModelExecutionContext)executionContext).setUpMSEModel();
        ((ConcurrentModelExecutionContext)executionContext).setUpFeedbackModel();
        Activator.getDefault().debug("*** Engine initialization done. ***");
    }

    protected void executeInitializeModelMethod(IConcurrentExecutionContext executionContext) {
        String modelInitializationMethodQName = ((IConcurrentRunConfiguration)executionContext.getRunConfiguration()).getModelInitializationMethod();
        if (!modelInitializationMethodQName.isEmpty()) {
            final Object target = executionContext.getResourceModel().getContents().get(0);
            final String modelInitializationMethodName = modelInitializationMethodQName.substring(modelInitializationMethodQName.lastIndexOf(".") + 1);
            Activator.getDefault().debug("*** Calling Model initialization method " + modelInitializationMethodName + "(). ***");
            final ArrayList<Object> modelInitializationParameters = new ArrayList<Object>();
            final ICodeExecutor codeExecutor = ((IConcurrentExecutionPlatform)this.getConcurrentExecutionContext().getExecutionPlatform()).getCodeExecutor();
            ArrayList<Object> parameters = new ArrayList<Object>();
            parameters.add(new String[1]);
            List methods = codeExecutor.findCompatibleMethodsWithAnnotation(target, parameters, InitializeModel.class);
            if (!methods.isEmpty()) {
                modelInitializationParameters.add(((IConcurrentRunConfiguration)executionContext.getRunConfiguration()).getModelInitializationArguments().split("\\r?\\n"));
            } else {
                String s;
                BasicEList modelInitializationArgs;
                parameters.clear();
                parameters.add(new ArrayList());
                methods.addAll(codeExecutor.findCompatibleMethodsWithAnnotation(target, parameters, InitializeModel.class));
                if (!methods.isEmpty()) {
                    modelInitializationArgs = new ArrayList();
                    String[] stringArray = ((IConcurrentRunConfiguration)executionContext.getRunConfiguration()).getModelInitializationArguments().split("\\r?\\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        s = stringArray[n2];
                        modelInitializationArgs.add(s);
                        ++n2;
                    }
                    modelInitializationParameters.add(modelInitializationArgs);
                } else {
                    parameters.clear();
                    parameters.add(new BasicEList());
                    methods.addAll(codeExecutor.findCompatibleMethodsWithAnnotation(target, parameters, InitializeModel.class));
                    if (!methods.isEmpty()) {
                        modelInitializationArgs = new BasicEList();
                        String[] stringArray = ((IConcurrentRunConfiguration)executionContext.getRunConfiguration()).getModelInitializationArguments().split("\\r?\\n");
                        int n = stringArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            s = stringArray[n3];
                            modelInitializationArgs.add((Object)s);
                            ++n3;
                        }
                        modelInitializationParameters.add(modelInitializationArgs);
                    }
                }
            }
            TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Factory.INSTANCE.getEditingDomain(((IConcurrentExecutionContext)this.getExecutionContext()).getResourceModel().getResourceSet());
            if (editingDomain != null) {
                RecordingCommand command = new RecordingCommand(editingDomain, "execute  " + modelInitializationMethodQName){
                    private List<Object> result;
                    {
                        super($anonymous0, $anonymous1);
                        this.result = new ArrayList<Object>();
                    }

                    protected void doExecute() {
                        try {
                            this.result.add(codeExecutor.execute(target, modelInitializationMethodName, (List)modelInitializationParameters));
                            Activator.getDefault().debug("*** Model initialization done. ***");
                        }
                        catch (CodeExecutionException e) {
                            Activator.getDefault().error("Exception while initializing model " + e.getMessage(), (Throwable)e);
                        }
                    }

                    public Collection<?> getResult() {
                        return this.result;
                    }
                };
                CommandExecution.execute((TransactionalEditingDomain)editingDomain, (RecordingCommand)command);
            } else {
                try {
                    codeExecutor.execute(target, modelInitializationMethodName, modelInitializationParameters);
                    Activator.getDefault().debug("*** Model initialization done. ***");
                }
                catch (CodeExecutionException e) {
                    Activator.getDefault().error("Exception while initializing model " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            Activator.getDefault().debug("*** Model initialization done. (no modelInitialization method defined for the language) ***");
        }
    }

    public String engineKindName() {
        return "GEMOC Concurrent Engine";
    }

    protected void beforeStart() {
    }
}

