/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dsa.executors;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dsa.executors.CodeExecutionException;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dsa.executors.ICodeExecutor;
import org.eclipse.gemoc.trace.commons.model.trace.MSEOccurrence;

public class JavaCodeExecutor
implements ICodeExecutor {
    public Object execute(MSEOccurrence mseOccurrence) throws CodeExecutionException {
        return this.execute(mseOccurrence.getMse().getCaller(), mseOccurrence.getMse().getAction().getName(), (Collection<Object>)mseOccurrence.getParameters(), mseOccurrence);
    }

    public Object execute(Object caller, String methodName, List<Object> parameters) throws CodeExecutionException {
        Class[] parameterTypes = new Class[]{};
        ArrayList parameterTypesList = new ArrayList();
        if (parameters != null) {
            for (Object param : parameters) {
                parameterTypesList.add(param.getClass());
            }
        }
        Object result = null;
        try {
            Method method = caller.getClass().getMethod(methodName, parameterTypes);
            result = method.invoke(caller, parameters);
        }
        catch (NoSuchMethodException e) {
            throw new CodeExecutionException("No applicable method " + methodName + "for this code executor. Could not perform action call, see inner exception.", (Exception)e, null, false);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new CodeExecutionException("Could not perform action call, see inner exception.", e, null, true);
        }
        return result;
    }

    private Object execute(Object caller, String methodName, Collection<Object> parameters, MSEOccurrence mseoccurrence) throws CodeExecutionException {
        Class[] parameterTypes = new Class[]{};
        ArrayList parameterTypesList = new ArrayList();
        if (mseoccurrence.getParameters() != null) {
            for (Object param : mseoccurrence.getParameters()) {
                parameterTypesList.add(param.getClass());
            }
        }
        Object result = null;
        try {
            Method method = caller.getClass().getMethod(methodName, parameterTypes);
            result = method.invoke(caller, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new CodeExecutionException("No applicable method " + methodName + "for this code executor. Could not perform action call, see inner exception.", (Exception)e, mseoccurrence, false);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new CodeExecutionException("Could not perform action call, see inner exception.", e, mseoccurrence, true);
        }
        return result;
    }

    public List<Method> findCompatibleMethodsWithAnnotation(Object caller, List<Object> parameters, Class<? extends Annotation> annotationClass) {
        ArrayList<Method> result = new ArrayList<Method>();
        Method[] methodArray = caller.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            Class<?>[] evaluatedMethodParamTypes = m.getParameterTypes();
            if (m.isAnnotationPresent(annotationClass) && evaluatedMethodParamTypes.length == parameters.size()) {
                boolean isAllParamCompatible = true;
                int i = 0;
                while (i < evaluatedMethodParamTypes.length) {
                    Object p = parameters.get(i);
                    if (evaluatedMethodParamTypes[i].isPrimitive()) {
                        if (evaluatedMethodParamTypes[i].equals(Integer.TYPE) && !Integer.class.isInstance(p)) {
                            isAllParamCompatible = false;
                            break;
                        }
                        if (evaluatedMethodParamTypes[i].equals(Boolean.TYPE) && !Boolean.class.isInstance(p)) {
                            isAllParamCompatible = false;
                            break;
                        }
                    } else if (!evaluatedMethodParamTypes[i].isInstance(p)) {
                        isAllParamCompatible = false;
                        break;
                    }
                    ++i;
                }
                if (isAllParamCompatible) {
                    result.add(m);
                }
            }
            ++n2;
        }
        return result;
    }

    public String getExcutorID() {
        return this.getClass().getSimpleName();
    }
}

