/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumLiteral;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.ExternalType;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.generator.fsm.generic.ILanguageExtensionBase;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.etrice.generator.java.Main;
import org.eclipse.etrice.generator.java.setup.GeneratorOptionsHelper;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
public class JavaExtensions
implements ILanguageExtension {
    @Inject
    private TypeHelpers typeHelpers;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;

    public String getTypedDataDefinition(EObject msg) {
        String string = null;
        string = msg instanceof Message ? this.generateArglistAndTypedData((EObject)((Message)msg).getData())[ILanguageExtensionBase.TypedDataKind.DECLARATION_AND_INITIALIZATION.ordinal()] : "";
        return string;
    }

    public String getJavaFileName(RoomClass rc) {
        String string = rc.getName();
        return string + ".java";
    }

    public String getJavaFactoryName(ActorClass rc) {
        String string = rc.getName();
        return string + "Factory";
    }

    public String getJavaFactoryFileName(ActorClass rc) {
        String string = this.getJavaFactoryName(rc);
        return string + ".java";
    }

    public String getJavaScalarInterfaceName(ActorClass rc) {
        String string = rc.getName();
        return string + "Interface";
    }

    public String getJavaScalarInterfaceFileName(ActorClass rc) {
        String string = this.getJavaScalarInterfaceName(rc);
        return string + ".java";
    }

    public String getJavaReplicatedInterfaceName(ActorClass rc) {
        String string = rc.getName();
        return string + "ReplicatedInterface";
    }

    public String getJavaReplicatedInterfaceFileName(ActorClass rc) {
        String string = this.getJavaReplicatedInterfaceName(rc);
        return string + ".java";
    }

    public String getJavaInterfaceName(ActorClass ac, boolean replicated) {
        String string = null;
        string = replicated ? this.getJavaReplicatedInterfaceName(ac) : this.getJavaScalarInterfaceName(ac);
        return string;
    }

    public String getJavaInterfaceFileName(ActorClass ac, boolean replicated) {
        String string = null;
        string = replicated ? this.getJavaReplicatedInterfaceFileName(ac) : this.getJavaScalarInterfaceFileName(ac);
        return string;
    }

    public String getJavaClassName(NodeRef nr, SubSystemInstance ssi) {
        String string = nr.getName();
        String string2 = "Node_" + string;
        String string3 = string2 + "_";
        String string4 = ssi.getName();
        return string3 + string4;
    }

    public String getJavaFileName(NodeRef nr, SubSystemInstance ssi) {
        String string = this.getJavaClassName(nr, ssi);
        return string + ".java";
    }

    public String toWrapper(String type) {
        String string;
        block12: {
            block10: {
                string = null;
                if (type == null) break block10;
                switch (type) {
                    case "int": {
                        string = "Integer";
                        break;
                    }
                    case "char": {
                        string = "Character";
                        break;
                    }
                    default: {
                        string = StringExtensions.toFirstUpper((String)type);
                        break;
                    }
                }
                break block12;
            }
            string = StringExtensions.toFirstUpper((String)type);
        }
        return string;
    }

    public boolean needsInitialization(Attribute a) {
        return a.getSize() > 0 || !this.typeHelpers.isEnumerationOrPrimitive(a.getType().getType()) || this.typeHelpers.typeName(a.getType().getType()).equals("String");
    }

    public String accessLevelPrivate() {
        return "private ";
    }

    public String accessLevelProtected() {
        return "protected ";
    }

    public String accessLevelPublic() {
        return "public ";
    }

    public String memberAccess() {
        return "this.";
    }

    public String selfPointer(String classname, boolean hasArgs) {
        return "";
    }

    public String selfPointer(boolean hasArgs) {
        return "";
    }

    public String operationScope(String classname, boolean isDeclaration) {
        return "";
    }

    public String scopeSeparator() {
        return ".";
    }

    public String memberInDeclaration(String namespace, String member) {
        return member;
    }

    public String memberInUse(String namespace, String member) {
        return namespace + "." + member;
    }

    public boolean usesInheritance() {
        return true;
    }

    public boolean usesPointers() {
        return false;
    }

    public String genEnumeration(String name, List<Pair<String, String>> entries) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        for (Pair<String, String> entry : entries) {
            stringConcatenation.append("public static final int ");
            String string = (String)entry.getFirst();
            stringConcatenation.append(string);
            stringConcatenation.append(" = ");
            String string2 = (String)entry.getSecond();
            stringConcatenation.append(string2);
            stringConcatenation.append(";");
            stringConcatenation.newLineIfNotEmpty();
        }
        return stringConcatenation.toString();
    }

    public String booleanConstant(boolean b) {
        return Boolean.valueOf(b).toString();
    }

    public String pointerLiteral() {
        return "";
    }

    public String nullPointer() {
        return "null";
    }

    public String voidPointer() {
        return "Object";
    }

    public String arrayType(String type, int size, boolean isRef) {
        return type + "[]";
    }

    public String arrayDeclaration(String type, int size, boolean isRef, String name) {
        return type + " " + name + "[]";
    }

    public String superCall(String baseClassName, String method, String args) {
        return "super." + method + "(" + args + ");";
    }

    public String toValueLiteral(PrimitiveType type, String value) {
        String string = null;
        if (!this.typeHelpers.isCharacterType(type) && (value.contains(",") || value.contains("{"))) {
            String string2 = null;
            String[] singleValues = value.replace("{", "").replace("}", "").trim().split(",");
            StringConcatenation stringConcatenation = new StringConcatenation();
            stringConcatenation.append("{ ");
            boolean bl = false;
            String[] stringArray = singleValues;
            int n = singleValues.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (!bl) {
                    bl = true;
                } else {
                    stringConcatenation.appendImmediate((Object)", ", "");
                }
                String string3 = this.castValue(type, v.trim());
                stringConcatenation.append(string3);
                ++n2;
            }
            stringConcatenation.append(" }");
            string = string2 = stringConcatenation.toString();
        } else {
            string = this.castValue(type, value);
        }
        return string;
    }

    public String toEnumLiteral(EnumerationType type, String value) {
        String string = null;
        if (value.contains(",") || value.contains("{")) {
            String string2 = null;
            String[] singleValues = value.replace("{", "").replace("}", "").trim().split(",");
            StringConcatenation stringConcatenation = new StringConcatenation();
            stringConcatenation.append("{ ");
            boolean bl = false;
            String[] stringArray = singleValues;
            int n = singleValues.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (!bl) {
                    bl = true;
                } else {
                    stringConcatenation.appendImmediate((Object)", ", "");
                }
                String string3 = this.convertStringEnumLiteral(type, v.trim());
                stringConcatenation.append(string3);
                ++n2;
            }
            stringConcatenation.append(" }");
            string = string2 = stringConcatenation.toString();
        } else {
            string = this.convertStringEnumLiteral(type, value);
        }
        return string;
    }

    private String convertStringEnumLiteral(EnumerationType type, String value) {
        String v = value;
        boolean bl = v.startsWith(type.getName());
        if (bl) {
            int n = type.getName().length();
            int n2 = n + 1;
            v = v.substring(n2);
        }
        EList eList = type.getLiterals();
        for (EnumLiteral l : eList) {
            boolean bl2 = l.getName().equals(v);
            if (!bl2) continue;
            String string = type.getName();
            String string2 = string + ".";
            String string3 = l.getName();
            return string2 + string3;
        }
        return null;
    }

    private String castValue(PrimitiveType type, String value) {
        Object object;
        block37: {
            block35: {
                object = null;
                String string = type.getTargetName();
                if (string == null) break block35;
                switch (string) {
                    case "boolean": {
                        object = value.toLowerCase();
                        break block37;
                    }
                    case "byte": {
                        object = "(byte)" + value;
                        break block37;
                    }
                    case "short": {
                        object = "(short)" + value;
                        break block37;
                    }
                    case "int": {
                        object = value;
                        break block37;
                    }
                    case "long": {
                        object = value + "L";
                        break block37;
                    }
                    case "float": {
                        object = value + "f";
                        break block37;
                    }
                    case "double": {
                        object = value + "d";
                        break block37;
                    }
                    case "char": {
                        Object object2 = null;
                        boolean bl = value.isEmpty();
                        if (bl) {
                            object2 = "(char) 0";
                        } else {
                            boolean bl2;
                            String string2 = null;
                            int n = value.length();
                            boolean bl3 = bl2 = n == 1;
                            if (bl2) {
                                char c = value.charAt(0);
                                String string3 = "'" + String.valueOf(Character.valueOf(c));
                                string2 = string3 + "'";
                            } else {
                                String string4 = value.replace("\\", "\\\\").replace("\"", "\\\"");
                                String string5 = "\"" + string4;
                                string2 = string5 + "\".toCharArray()";
                            }
                            object2 = string2;
                        }
                        object = object2;
                        break block37;
                    }
                    case "String": {
                        String string6 = value.replace("\\", "\\\\").replace("\"", "\\\"");
                        String string7 = "\"" + string6;
                        object = string7 + "\"";
                        break block37;
                    }
                    default: {
                        String string8 = type.getTargetName();
                        throw new UnsupportedOperationException(string8);
                    }
                }
            }
            String string = type.getTargetName();
            throw new UnsupportedOperationException(string);
        }
        return object;
    }

    public String defaultValue(DataType dt) {
        String string;
        String string2;
        Object object = null;
        boolean bl = false;
        if (dt instanceof PrimitiveType) {
            bl = true;
            object = this.toValueLiteral((PrimitiveType)dt, ((PrimitiveType)dt).getDefaultValueLiteral());
        }
        if (!bl && dt instanceof EnumerationType) {
            bl = true;
            object = this.getDefaultValue((EnumerationType)dt);
        }
        if (!bl && dt instanceof ExternalType) {
            bl = true;
            string2 = ((ExternalType)dt).getTargetName();
            string = "new " + string2;
            object = (String)string + "()";
        }
        if (!bl) {
            string2 = dt.getName();
            string = "new " + string2;
            object = string + "()";
        }
        return object;
    }

    public String getDefaultValue(EnumerationType type) {
        String string = null;
        boolean bl = type.getLiterals().isEmpty();
        string = bl ? "" : this.getCastedValue((EnumLiteral)type.getLiterals().get(0));
        return string;
    }

    public String initializationWithDefaultValues(DataType dt, int size) {
        String string = null;
        String dv = this.defaultValue(dt);
        Object object = null;
        if (size > 1) {
            String string2 = null;
            Object res = "{";
            int i = 0;
            while (i < size) {
                res = (String)res + dv;
                if (++i >= size) continue;
                res = (String)res + ",";
            }
            string2 = (String)res + "}";
            object = string2;
        } else {
            object = dv;
        }
        string = object;
        return string;
    }

    public String[] generateArglistAndTypedData(EObject d) {
        Object object;
        String typeName;
        if (d == null || !(d instanceof MessageData)) {
            return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{"", "", ""}), String.class);
        }
        MessageData data = (MessageData)d;
        String castTypeName = typeName = data.getRefType().getType().getName();
        DataType dataType = data.getRefType().getType();
        if (dataType instanceof PrimitiveType) {
            object = data.getRefType().getType();
            typeName = ((PrimitiveType)object).getTargetName();
            var7_7 = data.getRefType().getType();
            ct = ((PrimitiveType)var7_7).getCastName();
            if (ct != null && !ct.isEmpty()) {
                castTypeName = ct;
            }
        } else {
            object = data.getRefType().getType();
            if (object instanceof EnumerationType) {
                var7_7 = data.getRefType().getType();
                typeName = this.getTargetType((EnumerationType)var7_7);
                ct = data.getRefType().getType();
                castTypeName = this.getCastType((EnumerationType)ct);
            }
        }
        object = null;
        object = this._generatorOptionsHelper.isOldStyleTransitionData(Main.getSettings()) && data.getDeprecatedName() != null && !data.getDeprecatedName().trim().isEmpty() ? data.getDeprecatedName() : "transitionData";
        Object dataName = object;
        String dataArg = ", " + (String)dataName;
        String typedData = typeName + " " + (String)dataName + " = (" + castTypeName + ") generic_data__et;\n";
        String typedArgList = ", " + typeName + " " + (String)dataName;
        return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{dataArg, typedData, typedArgList}), String.class);
    }

    public String getTargetType(EnumerationType type) {
        String string = null;
        PrimitiveType primitiveType = type.getPrimitiveType();
        boolean bl = primitiveType != null;
        string = bl ? type.getPrimitiveType().getTargetName() : "int";
        return string;
    }

    public String getCastedValue(EnumLiteral literal) {
        boolean bl;
        String string = null;
        EObject eObject = literal.eContainer();
        EnumerationType type = (EnumerationType)eObject;
        String cast = this.getTargetType(type);
        Object object = null;
        PrimitiveType primitiveType = type.getPrimitiveType();
        boolean bl2 = bl = primitiveType == null;
        if (bl) {
            object = Long.toString(literal.getLiteralValue());
        } else {
            String string2 = Long.toString(literal.getLiteralValue());
            String string3 = "((" + cast + ")" + string2;
            object = string3 + ")";
        }
        string = object;
        return string;
    }

    public String getCastType(EnumerationType type) {
        String string = null;
        PrimitiveType primitiveType = type.getPrimitiveType();
        boolean bl = primitiveType != null;
        string = bl ? type.getPrimitiveType().getCastName() : "int";
        return string;
    }

    public String makeOverridable() {
        return "";
    }

    public String getTypeSignature(RefableType type) {
        boolean bl;
        Object object = null;
        RefableType it = type;
        boolean bl2 = false;
        if (Objects.equals(it, null)) {
            bl2 = true;
            object = "void";
        }
        if (!bl2 && (bl = it.isRef())) {
            bl2 = true;
            String string = this.getDataTypeName(type.getType());
            String string2 = this.pointerLiteral();
            object = string + string2;
        }
        if (!bl2) {
            object = this.getDataTypeName(type.getType());
        }
        return object;
    }

    public String getDataTypeName(DataType it) {
        String string = null;
        boolean bl = false;
        if (it instanceof PrimitiveType) {
            bl = true;
            string = ((PrimitiveType)it).getTargetName();
        }
        if (!bl && it instanceof EnumerationType) {
            bl = true;
            string = this.getTargetType((EnumerationType)it);
        }
        if (!bl && it instanceof ExternalType) {
            bl = true;
            string = ((ExternalType)it).getTargetName();
        }
        if (!bl) {
            string = it.getName();
        }
        return string;
    }

    public String toParameterDecl(VarDecl it) {
        String string;
        String string2;
        String string3;
        String string4 = null;
        boolean bl = false;
        boolean bl2 = it.isVarargs();
        if (bl2) {
            bl = true;
            string3 = this.getTypeSignature(it.getRefType());
            string2 = string3 + "... ";
            string = it.getName();
            string4 = string2 + string;
        }
        if (!bl) {
            string3 = this.getTypeSignature(it.getRefType());
            string2 = string3 + " ";
            string = it.getName();
            string4 = string2 + string;
        }
        return string4;
    }
}

