/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.commands.ECPCommand;
import org.eclipse.emf.ecp.editor.ModelElementChangeListener;
import org.eclipse.emf.ecp.editor.mecontrols.AbstractMEControl;
import org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol.AddReferenceAction;
import org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol.MELinkControl;
import org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol.MELinkControlFactory;
import org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol.MEMultiLinkControlDropAdapter;
import org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol.NewReferenceAction;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class MEMultiLinkControl
extends AbstractMEControl {
    private EReference eReference;
    private int style;
    private ScrolledComposite scrollPane;
    private Section section;
    private Composite linkArea;
    private Composite composite;
    private ArrayList<MELinkControl> linkControls;
    private GridLayout tableLayout;
    private Composite scrollClient;
    private DropTarget sectionDropTarget;
    private static final int PRIORITY = 1;
    private Object feature;
    private ModelElementChangeListener modelElementChangeListener;

    private void createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolbar.setCursor(handCursor);
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        toolBarManager.add((IAction)new AddReferenceAction(this.getModelElement(), this.eReference, this.getItemPropertyDescriptor(), this.getContext()));
        toolBarManager.add((IAction)new NewReferenceAction(this.getModelElement(), this.eReference, this.getItemPropertyDescriptor(), this.getContext()));
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    public Control createControl(Composite parent, int style) {
        this.linkControls = new ArrayList();
        this.feature = this.getItemPropertyDescriptor().getFeature((Object)this.getModelElement());
        this.eReference = (EReference)this.feature;
        this.modelElementChangeListener = new ModelElementChangeListener(this.getModelElement()){

            public void onChange(Notification notification) {
                if (notification.getEventType() != 9 && notification.getFeature().equals(MEMultiLinkControl.this.feature)) {
                    MEMultiLinkControl.this.rebuildLinkSection();
                }
            }
        };
        this.style = style;
        this.tableLayout = new GridLayout(1, false);
        this.section = this.getToolkit().createSection(parent, 322);
        this.section.setText(this.getItemPropertyDescriptor().getDisplayName((Object)this.getModelElement()));
        this.createSectionToolbar(this.section, this.getToolkit());
        this.composite = this.getToolkit().createComposite((Composite)this.section, style);
        this.composite.setLayout((Layout)this.tableLayout);
        if (!this.getItemPropertyDescriptor().canSetProperty((Object)this.getModelElement())) {
            this.composite.setEnabled(false);
        }
        this.rebuildLinkSection();
        this.section.setClient((Control)this.composite);
        this.addDnDSupport();
        return this.section;
    }

    private void addDnDSupport() {
        this.sectionDropTarget = new DropTarget((Control)this.section, 1);
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        this.sectionDropTarget.setTransfer(transfers);
        this.sectionDropTarget.addDropListener((DropTargetListener)new MEMultiLinkControlDropAdapter(this.getModelElement(), this.eReference, this.getContext()));
    }

    private void rebuildLinkSection() {
        int sizeLimit = 5;
        for (MELinkControl link : this.linkControls) {
            link.dispose();
        }
        if (this.scrollPane != null) {
            this.scrollPane.dispose();
        }
        if (this.linkArea != null) {
            this.linkArea.dispose();
        }
        this.linkControls.clear();
        new RebuildLinksCommand(this.getModelElement(), 5).run(false);
    }

    public void dispose() {
        this.modelElementChangeListener.remove();
        for (MELinkControl link : this.linkControls) {
            link.dispose();
        }
        if (this.sectionDropTarget != null) {
            this.sectionDropTarget.dispose();
        }
    }

    public int canRender(IItemPropertyDescriptor itemPropertyDescriptor, EObject modelElement) {
        Object feature = itemPropertyDescriptor.getFeature((Object)modelElement);
        if (feature instanceof EReference && EObject.class.isAssignableFrom(((EReference)feature).getEType().getInstanceClass()) && ((EReference)feature).isMany()) {
            return 1;
        }
        return -1;
    }

    private final class RebuildLinksCommand
    extends ECPCommand {
        private final int sizeLimit;

        public RebuildLinksCommand(EObject modelElement, int sizeLimit) {
            super(modelElement);
            this.sizeLimit = sizeLimit;
        }

        protected void doRun() {
            Object objectList = MEMultiLinkControl.this.getModelElement().eGet((EStructuralFeature)MEMultiLinkControl.this.eReference);
            if (objectList instanceof EList) {
                EList eList = (EList)objectList;
                if (eList.size() <= this.sizeLimit) {
                    MEMultiLinkControl.this.linkArea = MEMultiLinkControl.this.getToolkit().createComposite(MEMultiLinkControl.this.composite, MEMultiLinkControl.this.style);
                    MEMultiLinkControl.this.linkArea.setLayout((Layout)MEMultiLinkControl.this.tableLayout);
                    MEMultiLinkControl.this.linkArea.setLayoutData((Object)new GridData(768));
                } else {
                    MEMultiLinkControl.this.scrollPane = new ScrolledComposite(MEMultiLinkControl.this.composite, 768);
                    MEMultiLinkControl.this.scrollPane.setBackgroundMode(2);
                    MEMultiLinkControl.this.scrollClient = new Composite((Composite)MEMultiLinkControl.this.scrollPane, MEMultiLinkControl.this.style);
                    MEMultiLinkControl.this.scrollPane.setContent((Control)MEMultiLinkControl.this.scrollClient);
                    MEMultiLinkControl.this.getToolkit().getColors().createColor("white", 255, 255, 255);
                    MEMultiLinkControl.this.scrollClient.setBackground(MEMultiLinkControl.this.getToolkit().getColors().getColor("white"));
                    MEMultiLinkControl.this.scrollPane.setExpandVertical(true);
                    MEMultiLinkControl.this.scrollPane.setExpandHorizontal(true);
                    RowLayout layout = new RowLayout(512);
                    layout.wrap = true;
                    MEMultiLinkControl.this.scrollClient.setLayout((Layout)layout);
                    GridData spec = new GridData(400, 150);
                    spec.horizontalAlignment = 4;
                    spec.grabExcessHorizontalSpace = true;
                    MEMultiLinkControl.this.scrollPane.setLayoutData((Object)spec);
                    MEMultiLinkControl.this.scrollPane.setMinSize(150, 150);
                }
                for (EObject object : eList) {
                    MELinkControlFactory controlFactory = new MELinkControlFactory();
                    MELinkControl meControl = controlFactory.createMELinkControl(MEMultiLinkControl.this.getItemPropertyDescriptor(), object, MEMultiLinkControl.this.getModelElement(), MEMultiLinkControl.this.getContext());
                    meControl.createControl(eList.size() <= this.sizeLimit ? MEMultiLinkControl.this.linkArea : MEMultiLinkControl.this.scrollClient, MEMultiLinkControl.this.style, MEMultiLinkControl.this.getItemPropertyDescriptor(), object, MEMultiLinkControl.this.getModelElement(), MEMultiLinkControl.this.getToolkit(), MEMultiLinkControl.this.getContext());
                    MEMultiLinkControl.this.linkControls.add(meControl);
                }
                if (MEMultiLinkControl.this.scrollPane != null && !MEMultiLinkControl.this.scrollPane.isDisposed()) {
                    MEMultiLinkControl.this.scrollPane.setMinSize(MEMultiLinkControl.this.scrollClient.computeSize(-1, -1));
                    MEMultiLinkControl.this.scrollClient.layout();
                    MEMultiLinkControl.this.scrollPane.layout();
                } else {
                    MEMultiLinkControl.this.linkArea.layout();
                }
                if (eList.size() > 0) {
                    MEMultiLinkControl.this.section.setExpanded(false);
                    MEMultiLinkControl.this.section.setExpanded(true);
                }
            }
        }
    }
}

