/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Assignments;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferencingType;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class Embedded_PDV_Type
extends ASN1Type
implements IReferencingType {
    private static final String EMBEDDED_PDV = "EMBEDDED PDV";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for type `EMBEDDED PDV''";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for type `EMBEDDED PDV''";

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_EMBEDDED_PDV;
    }

    @Override
    public IASN1Type newInstance() {
        return new Embedded_PDV_Type();
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        return IType.Type_type.TYPE_TTCN3_SEQUENCE;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        return false;
    }

    @Override
    public String getTypename() {
        return EMBEDDED_PDV;
    }

    @Override
    public String getOutlineIcon() {
        return "record.gif";
    }

    @Override
    public IType getTypeRefd(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (null == this.myScope) {
            this.setIsErroneous(true);
            return this;
        }
        Identifier identifier = new Identifier(Identifier.Identifier_type.ID_ASN, EMBEDDED_PDV);
        Assignments assignments = this.myScope.getAssignmentsScope();
        if (!assignments.hasAssignmentWithId(timestamp, identifier)) {
            this.setIsErroneous(true);
            return this;
        }
        Assignment assignment = assignments.getLocalAssignmentByID(timestamp, identifier);
        if (null == assignment || null == assignment.getType(timestamp)) {
            this.setIsErroneous(true);
            return this;
        }
        return assignment.getType(timestamp);
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (null != this.constraints) {
            this.constraints.check(timestamp);
        }
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        IType last = this.getTypeRefd(timestamp, null);
        if (null != last && last != this) {
            last.checkThisValue(timestamp, value, valueCheckingOptions);
        }
        value.setLastTimeChecked(timestamp);
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName()));
        if (null != template.getLengthRestriction()) {
            template.getLocation().reportSemanticError(LENGTHRESTRICTIONNOTALLOWED);
        }
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("embedded PDV");
    }
}

