/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.Object;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.designer.AST.ASN1.ASN1Object;
import org.eclipse.titan.designer.AST.ASN1.Block;
import org.eclipse.titan.designer.AST.ASN1.Object.FieldSetting;
import org.eclipse.titan.designer.AST.ASN1.Object.FieldSpecification;
import org.eclipse.titan.designer.AST.ASN1.Object.FieldSpecifications;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectClassSyntax_Builder;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectClassSyntax_root;
import org.eclipse.titan.designer.AST.ASN1.Object.Object_Definition;
import org.eclipse.titan.designer.AST.ASN1.ObjectClass;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ParserMarkerSupport;
import org.eclipse.titan.designer.parsers.asn1parser.Asn1Parser;
import org.eclipse.titan.designer.parsers.asn1parser.BlockLevelTokenStreamTracker;

public final class ObjectClass_Definition
extends ObjectClass {
    private static final String MISSINGSETTING = "Missing setting for `{0}''";
    private final Block fieldSpecsBlock;
    private final Block withSyntaxBlock;
    protected FieldSpecifications fieldSpecifications;
    protected ObjectClassSyntax_root ocsRoot;

    public ObjectClass_Definition(Block fieldSpecsBlock, Block withSyntaxBlock) {
        this.fieldSpecsBlock = fieldSpecsBlock;
        this.withSyntaxBlock = withSyntaxBlock;
    }

    public ObjectClass_Definition() {
        this.fieldSpecsBlock = null;
        this.withSyntaxBlock = null;
    }

    @Override
    public ObjectClass_Definition newInstance() {
        return new ObjectClass_Definition(this.fieldSpecsBlock, this.withSyntaxBlock);
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.isErroneous = false;
        if (null != this.ocsRoot) {
            return;
        }
        if (null == this.fieldSpecifications) {
            this.parseBlockFieldSpecs();
        }
        if (this.getIsErroneous(timestamp) || null == this.fieldSpecifications) {
            return;
        }
        this.fieldSpecifications.check(timestamp);
        if (null == this.ocsRoot) {
            this.ocsRoot = new ObjectClassSyntax_root();
            ObjectClassSyntax_Builder builder = null;
            builder = new ObjectClassSyntax_Builder(this.withSyntaxBlock, this.fieldSpecifications);
            this.ocsRoot.accept(builder);
        }
    }

    @Override
    public void checkThisObject(CompilationTimeStamp timestamp, ASN1Object object) {
        if (null == object || this.isErroneous) {
            return;
        }
        if (null == this.fieldSpecifications) {
            return;
        }
        Object_Definition objectDefinition = object.getRefdLast(timestamp, null);
        for (int i = 0; i < this.fieldSpecifications.getNofFieldSpecifications(); ++i) {
            FieldSpecification fieldSpecification = this.fieldSpecifications.getFieldSpecificationByIndex(i).getLast();
            if (objectDefinition.hasFieldSettingWithName(fieldSpecification.getIdentifier())) {
                FieldSetting fieldSetting = objectDefinition.getFieldSettingByName(fieldSpecification.getIdentifier());
                if (null == fieldSetting) continue;
                fieldSetting.check(timestamp, fieldSpecification);
                continue;
            }
            if (fieldSpecification.getIsOptional() || fieldSpecification.hasDefault() || objectDefinition.getIsErroneous(timestamp)) continue;
            objectDefinition.getLocation().reportSemanticError(MessageFormat.format(MISSINGSETTING, fieldSpecification.identifier.getDisplayName()));
            objectDefinition.setIsErroneous(true);
        }
    }

    private void parseBlockFieldSpecs() {
        if (null == this.fieldSpecsBlock) {
            return;
        }
        Asn1Parser parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.fieldSpecsBlock);
        if (null == parser) {
            return;
        }
        this.fieldSpecifications = parser.pr_special_FieldSpecList().fieldSpecifications;
        List<SyntacticErrorStorage> errors = parser.getErrorStorage();
        if (null != errors && !errors.isEmpty()) {
            this.fieldSpecifications = null;
            for (int i = 0; i < errors.size(); ++i) {
                ParserMarkerSupport.createOnTheFlyMixedMarker((IFile)this.fieldSpecsBlock.getLocation().getFile(), errors.get(i), 2);
            }
        }
        if (null == this.fieldSpecifications) {
            this.isErroneous = true;
            return;
        }
        this.fieldSpecifications.setFullNameParent(this);
        this.fieldSpecifications.setMyObjectClass(this);
    }

    @Override
    public ObjectClassSyntax_root getObjectClassSyntax(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.ocsRoot;
    }

    @Override
    public FieldSpecifications getFieldSpecifications() {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.fieldSpecifications;
    }

    @Override
    public ObjectClass_Definition getRefdLast(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        this.check(timestamp);
        return this;
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subreferences = propCollector.getReference().getSubreferences();
        if (subreferences.size() <= i) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
            if (subreferences.size() > i + 1) {
                FieldSpecification fieldSpecification = this.fieldSpecifications.getFieldSpecificationByIdentifier(subreference.getId());
                if (null == fieldSpecification) {
                    return;
                }
                fieldSpecification.addProposal(propCollector, i + 1);
            } else {
                List<FieldSpecification> fieldSpecs = this.fieldSpecifications.getFieldSpecificationsWithPrefix(subreference.getId().getName());
                for (FieldSpecification field : fieldSpecs) {
                    propCollector.addProposal(field.getIdentifier(), " - ObjectClass field", null, "ObjectClass field");
                }
            }
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subreferences = declarationCollector.getReference().getSubreferences();
        if (subreferences.size() <= i) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
            if (subreferences.size() > i + 1) {
                Identifier identifier = subreference.getId();
                FieldSpecification fieldSpecification = this.fieldSpecifications.getFieldSpecificationByIdentifier(identifier);
                if (null == fieldSpecification) {
                    return;
                }
                fieldSpecification.addDeclaration(declarationCollector, i + 1);
            } else {
                String name = subreference.getId().getName();
                List<FieldSpecification> fieldSpecs = this.fieldSpecifications.getFieldSpecificationsWithPrefix(name);
                for (FieldSpecification field : fieldSpecs) {
                    declarationCollector.addDeclaration(field.getIdentifier().getDisplayName(), field.getLocation(), this);
                }
            }
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.fieldSpecifications == null || this.fieldSpecifications.accept(v);
    }
}

