/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure.constraints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsModel;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.CompilationUnitRange;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ConstraintVariable2;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;

public final class SuperTypeConstraintsCreator
extends HierarchicalASTVisitor {
    private static final String PROPERTY_CONSTRAINT_VARIABLE = "cv";
    private final Stack<ASTNode> fCurrentMethodsAndLambdas = new Stack();
    private final boolean fInstanceOf;
    private final SuperTypeConstraintsModel fModel;

    private static void getOriginalMethods(IMethodBinding binding, ITypeBinding type, Collection<IMethodBinding> originals, boolean implementations) {
        ITypeBinding ancestor = type.getSuperclass();
        if (!implementations) {
            ITypeBinding[] types = type.getInterfaces();
            int index = 0;
            while (index < types.length) {
                SuperTypeConstraintsCreator.getOriginalMethods(binding, types[index], originals, implementations);
                ++index;
            }
            if (ancestor != null) {
                SuperTypeConstraintsCreator.getOriginalMethods(binding, ancestor, originals, implementations);
            }
        }
        if (implementations && ancestor != null) {
            SuperTypeConstraintsCreator.getOriginalMethods(binding, ancestor, originals, implementations);
        }
        IMethodBinding[] methods = type.getDeclaredMethods();
        IMethodBinding method = null;
        int index = 0;
        while (index < methods.length) {
            method = methods[index];
            if (!binding.getKey().equals(method.getKey())) {
                boolean match = false;
                IMethodBinding current2 = null;
                for (IMethodBinding current2 : originals) {
                    if (!Bindings.isSubsignature(method, current2)) continue;
                    match = true;
                }
                if (!match && Bindings.isSubsignature(binding, method)) {
                    originals.add(method);
                }
            }
            ++index;
        }
    }

    public SuperTypeConstraintsCreator(SuperTypeConstraintsModel model, boolean instanceofs) {
        Assert.isNotNull((Object)model);
        this.fModel = model;
        this.fInstanceOf = instanceofs;
    }

    @Override
    public final void endVisit(ArrayAccess node) {
        node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, node.getArray().getProperty(PROPERTY_CONSTRAINT_VARIABLE));
    }

    @Override
    public final void endVisit(ArrayCreation node) {
        ConstraintVariable2 descendant;
        ConstraintVariable2 ancestor = (ConstraintVariable2)node.getType().getProperty(PROPERTY_CONSTRAINT_VARIABLE);
        node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)ancestor);
        ArrayInitializer initializer = node.getInitializer();
        if (initializer != null && (descendant = (ConstraintVariable2)initializer.getProperty(PROPERTY_CONSTRAINT_VARIABLE)) != null) {
            this.fModel.createSubtypeConstraint(descendant, ancestor);
        }
    }

    @Override
    public final void endVisit(ArrayInitializer node) {
        ConstraintVariable2 ancestor;
        ITypeBinding binding = node.resolveTypeBinding();
        if (binding != null && binding.isArray() && (ancestor = this.fModel.createIndependentTypeVariable(binding.getElementType())) != null) {
            node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)ancestor);
            Expression expression = null;
            ConstraintVariable2 descendant = null;
            List expressions = node.expressions();
            int index = 0;
            while (index < expressions.size()) {
                expression = (Expression)expressions.get(index);
                descendant = (ConstraintVariable2)expression.getProperty(PROPERTY_CONSTRAINT_VARIABLE);
                if (descendant != null) {
                    this.fModel.createSubtypeConstraint(descendant, ancestor);
                }
                ++index;
            }
        }
    }

    @Override
    public final void endVisit(ArrayType node) {
        Type elementType = node.getElementType();
        ConstraintVariable2 variable = this.fModel.createTypeVariable(elementType);
        if (variable != null) {
            elementType.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)variable);
            node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)variable);
        }
    }

    @Override
    public final void endVisit(Assignment node) {
        ConstraintVariable2 ancestor = (ConstraintVariable2)node.getLeftHandSide().getProperty(PROPERTY_CONSTRAINT_VARIABLE);
        ConstraintVariable2 descendant = (ConstraintVariable2)node.getRightHandSide().getProperty(PROPERTY_CONSTRAINT_VARIABLE);
        node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)ancestor);
        if (ancestor != null && descendant != null) {
            this.fModel.createSubtypeConstraint(descendant, ancestor);
        }
    }

    @Override
    public final void endVisit(CastExpression node) {
        ConstraintVariable2 first = (ConstraintVariable2)node.getType().getProperty(PROPERTY_CONSTRAINT_VARIABLE);
        if (first != null) {
            node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)first);
            ConstraintVariable2 second = (ConstraintVariable2)node.getExpression().getProperty(PROPERTY_CONSTRAINT_VARIABLE);
            if (second != null) {
                this.fModel.createCastVariable(node, second);
            }
        }
    }

    @Override
    public final void endVisit(CatchClause node) {
        ConstraintVariable2 ancestor;
        ITypeBinding binding;
        ConstraintVariable2 descendant;
        SingleVariableDeclaration declaration = node.getException();
        if (declaration != null && (descendant = (ConstraintVariable2)declaration.getProperty(PROPERTY_CONSTRAINT_VARIABLE)) != null && (binding = node.getAST().resolveWellKnownType("java.lang.Throwable")) != null && (ancestor = this.fModel.createImmutableTypeVariable(binding)) != null) {
            this.fModel.createSubtypeConstraint(descendant, ancestor);
        }
    }

    @Override
    public final void endVisit(ClassInstanceCreation node) {
        IMethodBinding binding = node.resolveConstructorBinding();
        if (binding != null) {
            this.endVisit(node.arguments(), binding);
            ConstraintVariable2 variable = null;
            AnonymousClassDeclaration declaration = node.getAnonymousClassDeclaration();
            if (declaration != null) {
                ITypeBinding type = declaration.resolveBinding();
                if (type != null) {
                    variable = this.fModel.createImmutableTypeVariable(type);
                }
            } else {
                ITypeBinding type = node.resolveTypeBinding();
                if (type != null) {
                    variable = this.fModel.createImmutableTypeVariable(type);
                }
            }
            if (variable != null) {
                node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)variable);
            }
        }
    }

    @Override
    public final void endVisit(ConditionalExpression node) {
        ITypeBinding binding;
        Expression elseExpression;
        ConstraintVariable2 thenVariable = null;
        ConstraintVariable2 elseVariable = null;
        Expression thenExpression = node.getThenExpression();
        if (thenExpression != null) {
            thenVariable = (ConstraintVariable2)thenExpression.getProperty(PROPERTY_CONSTRAINT_VARIABLE);
        }
        if ((elseExpression = node.getElseExpression()) != null) {
            elseVariable = (ConstraintVariable2)elseExpression.getProperty(PROPERTY_CONSTRAINT_VARIABLE);
        }
        if ((binding = node.resolveTypeBinding()) != null) {
            ConstraintVariable2 ancestor;
            if (binding.isArray()) {
                binding = binding.getElementType();
            }
            if ((ancestor = this.fModel.createIndependentTypeVariable(binding)) != null) {
                node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)ancestor);
                if (thenVariable != null) {
                    this.fModel.createSubtypeConstraint(thenVariable, ancestor);
                }
                if (elseVariable != null) {
                    this.fModel.createSubtypeConstraint(elseVariable, ancestor);
                }
                if (thenVariable != null && elseVariable != null) {
                    this.fModel.createConditionalTypeConstraint(ancestor, thenVariable, elseVariable);
                }
            }
        }
    }

    @Override
    public final void endVisit(ConstructorInvocation node) {
        IMethodBinding binding = node.resolveConstructorBinding();
        if (binding != null) {
            this.endVisit(node.arguments(), binding);
        }
    }

    @Override
    public final void endVisit(FieldAccess node) {
        IVariableBinding binding = node.resolveFieldBinding();
        if (binding != null) {
            this.endVisit(binding, node.getExpression(), (Expression)node);
        }
    }

    @Override
    public final void endVisit(FieldDeclaration node) {
        this.endVisit(node.fragments(), node.getType(), (ASTNode)node);
    }

    private void endVisit(IMethodBinding binding) {
        IMethodBinding method2 = null;
        ConstraintVariable2 ancestor = null;
        ConstraintVariable2 descendant = this.fModel.createReturnTypeVariable(binding);
        if (descendant != null) {
            Collection<IMethodBinding> originals = this.getOriginalMethods(binding);
            for (IMethodBinding method2 : originals) {
                if (method2.getKey().equals(binding.getKey()) || (ancestor = this.fModel.createReturnTypeVariable(method2)) == null) continue;
                this.fModel.createCovariantTypeConstraint(descendant, ancestor);
            }
        }
    }

    private void endVisit(IMethodBinding binding, ConstraintVariable2 descendant) {
        ITypeBinding declaring = null;
        IMethodBinding method2 = null;
        Collection<IMethodBinding> originals = this.getOriginalMethods(binding);
        for (IMethodBinding method2 : originals) {
            ConstraintVariable2 ancestor;
            declaring = method2.getDeclaringClass();
            if (declaring == null || (ancestor = this.fModel.createDeclaringTypeVariable(declaring)) == null) continue;
            this.fModel.createSubtypeConstraint(descendant, ancestor);
        }
    }

    private void endVisit(ITypeBinding binding, Name node) {
        ConstraintVariable2 variable = this.fModel.createExceptionVariable(node);
        if (variable != null) {
            node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)variable);
        }
    }

    private void endVisit(IVariableBinding binding, Expression qualifier, Expression access) {
        ConstraintVariable2 descendant;
        ConstraintVariable2 ancestor;
        ITypeBinding type;
        access.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)this.fModel.createVariableVariable(binding));
        if (qualifier != null && (type = binding.getDeclaringClass()) != null && (ancestor = this.fModel.createDeclaringTypeVariable(type)) != null && (descendant = (ConstraintVariable2)qualifier.getProperty(PROPERTY_CONSTRAINT_VARIABLE)) != null) {
            this.fModel.createSubtypeConstraint(descendant, ancestor);
        }
    }

    private void endVisit(List<Expression> arguments, IMethodBinding binding) {
        Expression expression = null;
        ConstraintVariable2 ancestor = null;
        ConstraintVariable2 descendant = null;
        int index = 0;
        while (index < arguments.size()) {
            expression = arguments.get(index);
            descendant = (ConstraintVariable2)expression.getProperty(PROPERTY_CONSTRAINT_VARIABLE);
            ancestor = this.fModel.createMethodParameterVariable(binding, index);
            if (ancestor != null && descendant != null) {
                this.fModel.createSubtypeConstraint(descendant, ancestor);
            }
            ++index;
        }
    }

    private void endVisit(List<VariableDeclarationFragment> fragments, Type type, ASTNode parent) {
        ConstraintVariable2 ancestor = (ConstraintVariable2)type.getProperty(PROPERTY_CONSTRAINT_VARIABLE);
        if (ancestor != null) {
            IVariableBinding binding = null;
            ConstraintVariable2 descendant = null;
            VariableDeclarationFragment fragment = null;
            int index = 0;
            while (index < fragments.size()) {
                fragment = fragments.get(index);
                descendant = (ConstraintVariable2)fragment.getProperty(PROPERTY_CONSTRAINT_VARIABLE);
                if (descendant != null) {
                    this.fModel.createSubtypeConstraint(descendant, ancestor);
                }
                if ((binding = fragment.resolveBinding()) != null && (descendant = this.fModel.createVariableVariable(binding)) != null) {
                    this.fModel.createEqualityConstraint(ancestor, descendant);
                }
                ++index;
            }
            parent.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)ancestor);
        }
    }

    @Override
    public boolean visit(LambdaExpression node) {
        this.fCurrentMethodsAndLambdas.push((ASTNode)node);
        return super.visit(node);
    }

    @Override
    public void endVisit(LambdaExpression node) {
        this.fCurrentMethodsAndLambdas.pop();
        IMethodBinding binding = node.resolveMethodBinding();
        if (binding != null) {
            ConstraintVariable2 ancestor;
            Expression expression;
            ConstraintVariable2 descendant;
            ASTNode body = node.getBody();
            if (body instanceof Expression && (descendant = (ConstraintVariable2)(expression = (Expression)body).getProperty(PROPERTY_CONSTRAINT_VARIABLE)) != null && (ancestor = this.fModel.createReturnTypeVariable(binding)) != null) {
                this.fModel.createSubtypeConstraint(descendant, ancestor);
            }
            this.endVisit(binding);
            ConstraintVariable2 ancestor2 = null;
            descendant = null;
            IVariableBinding variable = null;
            List parameters = node.parameters();
            if (!parameters.isEmpty()) {
                Collection<IMethodBinding> originals = this.getOriginalMethods(binding);
                VariableDeclaration declaration = null;
                int index = 0;
                while (index < parameters.size()) {
                    declaration = (VariableDeclaration)parameters.get(index);
                    ancestor2 = this.fModel.createMethodParameterVariable(binding, index);
                    if (ancestor2 != null) {
                        if (declaration instanceof SingleVariableDeclaration && (descendant = (ConstraintVariable2)((SingleVariableDeclaration)declaration).getType().getProperty(PROPERTY_CONSTRAINT_VARIABLE)) != null) {
                            this.fModel.createEqualityConstraint(descendant, ancestor2);
                        }
                        if ((variable = declaration.resolveBinding()) != null && (descendant = this.fModel.createVariableVariable(variable)) != null) {
                            this.fModel.createEqualityConstraint(ancestor2, descendant);
                        }
                        IMethodBinding method2 = null;
                        for (IMethodBinding method2 : originals) {
                            if (method2.getKey().equals(binding.getKey()) || (descendant = this.fModel.createMethodParameterVariable(method2, index)) == null) continue;
                            this.fModel.createEqualityConstraint(ancestor2, descendant);
                        }
                    }
                    ++index;
                }
            }
        }
    }

    @Override
    public final void endVisit(MethodDeclaration node) {
        this.fCurrentMethodsAndLambdas.pop();
        IMethodBinding binding = node.resolveBinding();
        if (binding != null) {
            ITypeBinding throwable;
            List exceptions;
            Type type;
            if (!binding.isConstructor() && (type = node.getReturnType2()) != null) {
                ConstraintVariable2 first = this.fModel.createReturnTypeVariable(binding);
                ConstraintVariable2 second = (ConstraintVariable2)type.getProperty(PROPERTY_CONSTRAINT_VARIABLE);
                if (first != null) {
                    if (second != null) {
                        this.fModel.createEqualityConstraint(first, second);
                    }
                    this.endVisit(binding);
                }
            }
            ConstraintVariable2 ancestor = null;
            ConstraintVariable2 descendant = null;
            IVariableBinding variable = null;
            List parameters = node.parameters();
            if (!parameters.isEmpty()) {
                Collection<IMethodBinding> originals = this.getOriginalMethods(binding);
                SingleVariableDeclaration declaration = null;
                int index = 0;
                while (index < parameters.size()) {
                    declaration = (SingleVariableDeclaration)parameters.get(index);
                    ancestor = this.fModel.createMethodParameterVariable(binding, index);
                    if (ancestor != null) {
                        descendant = (ConstraintVariable2)declaration.getType().getProperty(PROPERTY_CONSTRAINT_VARIABLE);
                        if (descendant != null) {
                            this.fModel.createEqualityConstraint(descendant, ancestor);
                        }
                        if ((variable = declaration.resolveBinding()) != null && (descendant = this.fModel.createVariableVariable(variable)) != null) {
                            this.fModel.createEqualityConstraint(ancestor, descendant);
                        }
                        IMethodBinding method2 = null;
                        for (IMethodBinding method2 : originals) {
                            if (method2.getKey().equals(binding.getKey()) || (descendant = this.fModel.createMethodParameterVariable(method2, index)) == null) continue;
                            this.fModel.createEqualityConstraint(ancestor, descendant);
                        }
                    }
                    ++index;
                }
            }
            if (!(exceptions = node.thrownExceptionTypes()).isEmpty() && (throwable = node.getAST().resolveWellKnownType("java.lang.Throwable")) != null && (ancestor = this.fModel.createImmutableTypeVariable(throwable)) != null) {
                Type exception = null;
                int index = 0;
                while (index < exceptions.size()) {
                    exception = (Type)exceptions.get(index);
                    descendant = (ConstraintVariable2)exception.getProperty(PROPERTY_CONSTRAINT_VARIABLE);
                    if (descendant != null) {
                        this.fModel.createSubtypeConstraint(descendant, ancestor);
                    }
                    ++index;
                }
            }
        }
    }

    @Override
    public void endVisit(MethodReference node) {
        ITypeBinding typeBinding;
        IMethodBinding methodBinding = node.resolveMethodBinding();
        if (methodBinding != null && (typeBinding = node.resolveTypeBinding()) != null) {
            ITypeBinding[] samParameterTypes;
            ITypeBinding[] parameterTypes;
            CreationReference creationReference;
            ITypeBinding creationTypeBinding;
            IMethodBinding samBinding = typeBinding.getFunctionalInterfaceMethod();
            ConstraintVariable2 descendant = node instanceof CreationReference ? ((creationTypeBinding = (creationReference = (CreationReference)node).getType().resolveBinding()) == null ? null : this.fModel.createDeclaringTypeVariable(creationTypeBinding)) : this.fModel.createReturnTypeVariable(methodBinding);
            ConstraintVariable2 ancestor = this.fModel.createReturnTypeVariable(samBinding);
            if (descendant != null && ancestor != null) {
                this.fModel.createSubtypeConstraint(descendant, ancestor);
            }
            if ((parameterTypes = methodBinding.getParameterTypes()).length == (samParameterTypes = samBinding.getParameterTypes()).length) {
                Expression expression;
                if (node instanceof ExpressionMethodReference && (descendant = (ConstraintVariable2)(expression = ((ExpressionMethodReference)node).getExpression()).getProperty(PROPERTY_CONSTRAINT_VARIABLE)) != null) {
                    this.endVisit(methodBinding, descendant);
                }
                int i = 0;
                while (i < parameterTypes.length) {
                    descendant = this.fModel.createMethodParameterVariable(samBinding, i);
                    ancestor = this.fModel.createMethodParameterVariable(methodBinding, i);
                    if (descendant != null && ancestor != null) {
                        this.fModel.createSubtypeConstraint(descendant, ancestor);
                    }
                    ++i;
                }
            } else if (parameterTypes.length + 1 == samParameterTypes.length) {
                ITypeBinding receiverType = null;
                if (node instanceof ExpressionMethodReference) {
                    receiverType = ((ExpressionMethodReference)node).getExpression().resolveTypeBinding();
                } else if (node instanceof TypeMethodReference) {
                    receiverType = ((TypeMethodReference)node).getType().resolveBinding();
                }
                if (receiverType != null) {
                    descendant = this.fModel.createMethodParameterVariable(samBinding, 0);
                    ancestor = this.fModel.createDeclaringTypeVariable(receiverType);
                    if (ancestor != null && descendant != null) {
                        this.fModel.createSubtypeConstraint(descendant, ancestor);
                    }
                }
                int i = 0;
                while (i < parameterTypes.length) {
                    descendant = this.fModel.createMethodParameterVariable(samBinding, i + 1);
                    ancestor = this.fModel.createMethodParameterVariable(methodBinding, i);
                    if (descendant != null && ancestor != null) {
                        this.fModel.createSubtypeConstraint(descendant, ancestor);
                    }
                    ++i;
                }
            }
        }
        super.endVisit(node);
    }

    @Override
    public final void endVisit(MethodInvocation node) {
        IMethodBinding binding = node.resolveMethodBinding();
        if (binding != null) {
            ConstraintVariable2 descendant;
            this.endVisit(node, binding);
            this.endVisit(node.arguments(), binding);
            Expression expression = node.getExpression();
            if (expression != null && (descendant = (ConstraintVariable2)expression.getProperty(PROPERTY_CONSTRAINT_VARIABLE)) != null) {
                this.endVisit(binding, descendant);
            }
        }
    }

    private void endVisit(MethodInvocation invocation, IMethodBinding binding) {
        ConstraintVariable2 variable;
        if (!binding.isConstructor() && (variable = this.fModel.createReturnTypeVariable(binding)) != null) {
            invocation.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)variable);
        }
    }

    @Override
    public final void endVisit(NullLiteral node) {
        node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)this.fModel.createImmutableTypeVariable(node.resolveTypeBinding()));
    }

    @Override
    public final void endVisit(ParenthesizedExpression node) {
        node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, node.getExpression().getProperty(PROPERTY_CONSTRAINT_VARIABLE));
    }

    @Override
    public final void endVisit(QualifiedName node) {
        ConstraintVariable2 variable;
        ASTNode parent = node.getParent();
        Name qualifier = node.getQualifier();
        IBinding binding = qualifier.resolveBinding();
        if (binding instanceof ITypeBinding && (variable = this.fModel.createTypeVariable((ITypeBinding)binding, new CompilationUnitRange(RefactoringASTParser.getCompilationUnit((ASTNode)node), (ISourceRange)new SourceRange(qualifier.getStartPosition(), qualifier.getLength())))) != null) {
            qualifier.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)variable);
        }
        if ((binding = node.getName().resolveBinding()) instanceof IVariableBinding && !(parent instanceof ImportDeclaration)) {
            this.endVisit((IVariableBinding)binding, (Expression)qualifier, (Expression)node);
        } else if (binding instanceof ITypeBinding && parent instanceof MethodDeclaration) {
            this.endVisit((ITypeBinding)binding, (Name)node);
        }
    }

    @Override
    public final void endVisit(ReturnStatement node) {
        ConstraintVariable2 descendant;
        Expression expression = node.getExpression();
        if (expression != null && (descendant = (ConstraintVariable2)expression.getProperty(PROPERTY_CONSTRAINT_VARIABLE)) != null) {
            ConstraintVariable2 ancestor;
            ASTNode methodOrLambda = this.fCurrentMethodsAndLambdas.peek();
            IMethodBinding binding = null;
            if (methodOrLambda instanceof MethodDeclaration) {
                binding = ((MethodDeclaration)methodOrLambda).resolveBinding();
            } else if (methodOrLambda instanceof LambdaExpression) {
                binding = ((LambdaExpression)methodOrLambda).resolveMethodBinding();
            }
            if (binding != null && (ancestor = this.fModel.createReturnTypeVariable(binding)) != null) {
                node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)ancestor);
                this.fModel.createSubtypeConstraint(descendant, ancestor);
            }
        }
    }

    @Override
    public final void endVisit(SimpleName node) {
        ASTNode parent = node.getParent();
        if (!(parent instanceof ImportDeclaration || parent instanceof PackageDeclaration || parent instanceof AbstractTypeDeclaration)) {
            IBinding binding = node.resolveBinding();
            if (binding instanceof IVariableBinding && !(parent instanceof MethodDeclaration)) {
                this.endVisit((IVariableBinding)binding, null, (Expression)node);
            } else if (binding instanceof ITypeBinding && parent instanceof MethodDeclaration) {
                this.endVisit((ITypeBinding)binding, (Name)node);
            }
        }
    }

    @Override
    public final void endVisit(SingleVariableDeclaration node) {
        ConstraintVariable2 ancestor = (ConstraintVariable2)node.getType().getProperty(PROPERTY_CONSTRAINT_VARIABLE);
        if (ancestor != null) {
            ConstraintVariable2 descendant;
            node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)ancestor);
            Expression expression = node.getInitializer();
            if (expression != null && (descendant = (ConstraintVariable2)expression.getProperty(PROPERTY_CONSTRAINT_VARIABLE)) != null) {
                this.fModel.createSubtypeConstraint(descendant, ancestor);
            }
        }
    }

    @Override
    public void endVisit(EnhancedForStatement node) {
        SingleVariableDeclaration parameter = node.getParameter();
        ConstraintVariable2 ancestor = (ConstraintVariable2)parameter.getType().getProperty(PROPERTY_CONSTRAINT_VARIABLE);
        if (ancestor != null) {
            ConstraintVariable2 descendant;
            ITypeBinding collectionType;
            ConstraintVariable2 descendant2;
            IVariableBinding binding = parameter.resolveBinding();
            if (binding != null && (descendant2 = this.fModel.createVariableVariable(binding)) != null) {
                this.fModel.createEqualityConstraint(ancestor, descendant2);
            }
            if ((collectionType = node.getExpression().resolveTypeBinding()) != null && collectionType.isArray() && (descendant = (ConstraintVariable2)node.getExpression().getProperty(PROPERTY_CONSTRAINT_VARIABLE)) != null) {
                this.fModel.createSubtypeConstraint(descendant, ancestor);
            }
        }
    }

    @Override
    public final void endVisit(SuperConstructorInvocation node) {
        IMethodBinding binding = node.resolveConstructorBinding();
        if (binding != null) {
            this.endVisit(node.arguments(), binding);
        }
    }

    @Override
    public final void endVisit(SuperFieldAccess node) {
        SimpleName name = node.getName();
        IBinding binding = name.resolveBinding();
        if (binding instanceof IVariableBinding) {
            this.endVisit((IVariableBinding)binding, null, (Expression)node);
        }
    }

    @Override
    public final void endVisit(SuperMethodInvocation node) {
        IMethodBinding superBinding = node.resolveMethodBinding();
        if (superBinding != null) {
            ConstraintVariable2 ancestor;
            IMethodBinding subBinding;
            this.endVisit(node.arguments(), superBinding);
            ASTNode methodOrLambda = this.fCurrentMethodsAndLambdas.peek();
            if (methodOrLambda instanceof MethodDeclaration && (subBinding = ((MethodDeclaration)methodOrLambda).resolveBinding()) != null && (ancestor = this.fModel.createReturnTypeVariable(superBinding)) != null) {
                node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)ancestor);
                ConstraintVariable2 descendant = this.fModel.createReturnTypeVariable(subBinding);
                if (descendant != null) {
                    this.fModel.createEqualityConstraint(descendant, ancestor);
                }
            }
        }
    }

    @Override
    public final void endVisit(ThisExpression node) {
        ITypeBinding binding = node.resolveTypeBinding();
        if (binding != null) {
            node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)this.fModel.createDeclaringTypeVariable(binding));
        }
    }

    @Override
    public final void endVisit(Type node) {
        ASTNode parent = node.getParent();
        if (!(parent instanceof AbstractTypeDeclaration || parent instanceof ClassInstanceCreation || parent instanceof CreationReference || parent instanceof TypeLiteral || parent instanceof InstanceofExpression && !this.fInstanceOf)) {
            node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)this.fModel.createTypeVariable(node));
        }
    }

    @Override
    public final void endVisit(VariableDeclarationExpression node) {
        this.endVisit(node.fragments(), node.getType(), (ASTNode)node);
    }

    @Override
    public final void endVisit(VariableDeclarationFragment node) {
        Expression initializer = node.getInitializer();
        if (initializer != null) {
            node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, initializer.getProperty(PROPERTY_CONSTRAINT_VARIABLE));
        }
    }

    @Override
    public final void endVisit(VariableDeclarationStatement node) {
        this.endVisit(node.fragments(), node.getType(), (ASTNode)node);
    }

    private Collection<IMethodBinding> getOriginalMethods(IMethodBinding binding) {
        ArrayList<IMethodBinding> originals = new ArrayList<IMethodBinding>();
        ITypeBinding type = binding.getDeclaringClass();
        SuperTypeConstraintsCreator.getOriginalMethods(binding, type, originals, false);
        SuperTypeConstraintsCreator.getOriginalMethods(binding, type, originals, true);
        if (originals.isEmpty()) {
            originals.add(binding);
        }
        return originals;
    }

    @Override
    public final boolean visit(AnnotationTypeDeclaration node) {
        return false;
    }

    @Override
    public final boolean visit(Comment node) {
        return false;
    }

    @Override
    public final boolean visit(ImportDeclaration node) {
        return false;
    }

    @Override
    public final boolean visit(MethodDeclaration node) {
        this.fCurrentMethodsAndLambdas.push((ASTNode)node);
        return super.visit(node);
    }

    @Override
    public final boolean visit(PackageDeclaration node) {
        return false;
    }

    @Override
    public final boolean visit(ThisExpression node) {
        return false;
    }

    @Override
    public final boolean visit(Type node) {
        return false;
    }
}

