/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.lens;

import fr.inria.zvtm.lens.BlendingLens;

public class BInverseCosineLens
extends BlendingLens {
    protected float aT = 0.0f;
    protected float bT = 0.0f;
    protected float cT = 0.0f;

    public BInverseCosineLens() {
        this(2.0f, 0.0f, 1.0f, 100, 50, 0, 0);
    }

    public BInverseCosineLens(float mm) {
        this(mm, 0.0f, 1.0f, 100, 50, 0, 0);
    }

    public BInverseCosineLens(float mm, float tc, float tf, int outerRadius, int innerRadius) {
        this(2.0f, tc, tf, outerRadius, innerRadius, 0, 0);
    }

    public BInverseCosineLens(float mm, float tc, float tf, int outerRadius, int innerRadius, int x, int y) {
        this.MM = mm;
        this.LR1 = outerRadius;
        this.LR2 = innerRadius;
        this.MMTc = tc;
        this.MMTf = tf;
        this.updateMagBufferWorkingDimensions();
        this.computeDropoffFactors();
        this.lx = x;
        this.ly = y;
    }

    @Override
    public void setOuterRadius(int r) {
        super.setOuterRadius(r);
        this.computeDropoffFactors();
    }

    @Override
    public void setInnerRadius(int r) {
        super.setInnerRadius(r);
        this.computeDropoffFactors();
    }

    @Override
    public void setRadii(int outerRadius, int innerRadius) {
        this.setRadii(outerRadius, innerRadius, true);
    }

    @Override
    public void setRadii(int outerRadius, int innerRadius, boolean forceRaster) {
        super.setRadii(outerRadius, innerRadius, forceRaster);
        this.computeDropoffFactors();
    }

    @Override
    public void setMMandRadii(float mm, int outerRadius, int innerRadius) {
        this.setMMandRadii(mm, outerRadius, innerRadius, true);
    }

    @Override
    public void setMMandRadii(float mm, int outerRadius, int innerRadius, boolean forceRaster) {
        super.setMMandRadii(mm, outerRadius, innerRadius, forceRaster);
        this.computeDropoffFactors();
    }

    @Override
    public void setMaximumMagnification(float mm) {
        this.setMaximumMagnification(mm, true);
    }

    @Override
    public void setMaximumMagnification(float mm, boolean forceRaster) {
        super.setMaximumMagnification(mm, forceRaster);
        this.computeDropoffFactors();
    }

    @Override
    void computeDropoffFactors() {
        this.aT = 1.0f / (float)(this.LR1 - this.LR2);
        this.bT = (float)this.LR2 / (float)(this.LR2 - this.LR1);
        this.cT = 0.63661975f * (this.MMTf - this.MMTc);
    }

    @Override
    public void gfT(float x, float y, float[] g) {
        this.d = Math.sqrt((x - (float)this.sw - (float)this.lx) * (x - (float)this.sw - (float)this.lx) + (y - (float)this.sh - (float)this.ly) * (y - (float)this.sh - (float)this.ly));
        g[0] = this.d <= (double)this.LR2 ? this.MMTf : (this.d <= (double)this.LR1 ? this.MMTf - this.cT * (float)Math.acos((this.d * (double)this.aT + (double)this.bT - 1.0) * (this.d * (double)this.aT + (double)this.bT - 1.0)) : 0.0f);
    }
}

