/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveableFilter;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.ide.ResourceUtil;

class SaveFilter
implements ISaveableFilter {
    private final IResource[] roots;

    public SaveFilter(IResource[] roots) {
        this.roots = roots;
    }

    public boolean select(Saveable saveable, IWorkbenchPart[] containingParts) {
        if (this.isDescendantOfRoots(saveable)) {
            return true;
        }
        int i = 0;
        while (i < containingParts.length) {
            IEditorPart editorPart;
            IWorkbenchPart workbenchPart = containingParts[i];
            if (workbenchPart instanceof IEditorPart && this.isEditingDescendantOf(editorPart = (IEditorPart)workbenchPart)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDescendantOfRoots(Saveable saveable) {
        ResourceMapping mapping = ResourceUtil.getResourceMapping((Object)saveable);
        if (mapping == null) {
            IFile file = ResourceUtil.getFile((Object)saveable);
            if (file == null) return false;
            return this.isDescendantOfRoots((IResource)file);
        }
        try {
            ResourceTraversal[] traversals = mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, null);
            int i = 0;
            block2: while (true) {
                if (i >= traversals.length) {
                    return false;
                }
                ResourceTraversal traversal = traversals[i];
                IResource[] resources = traversal.getResources();
                int j = 0;
                while (true) {
                    if (j >= resources.length) {
                        ++i;
                        continue block2;
                    }
                    IResource resource = resources[j];
                    if (this.isDescendantOfRoots(resource)) {
                        return true;
                    }
                    ++j;
                }
                break;
            }
        }
        catch (CoreException e) {
            Activator.logError(NLS.bind((String)"An internal error occurred while determining the resources for {0}", (Object)saveable.getName()), e);
            return false;
        }
    }

    private boolean isDescendantOfRoots(IResource resource) {
        int l = 0;
        while (l < this.roots.length) {
            IResource root = this.roots[l];
            if (root.getFullPath().isPrefixOf(resource.getFullPath())) {
                return true;
            }
            ++l;
        }
        return false;
    }

    private boolean isEditingDescendantOf(IEditorPart part) {
        IFile file = ResourceUtil.getFile((IEditorInput)part.getEditorInput());
        if (file != null) {
            return this.isDescendantOfRoots((IResource)file);
        }
        return false;
    }
}

