/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.papyrus.wizard.newproject.newfile;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewFileResourceWizard;
import org.osgi.framework.Bundle;

public class NewFMLFileWizard
extends BasicNewFileResourceWizard
implements INewWizard {
    private WizardNewFileCreationPage mainPage;
    private final String NEW_XLIA_FILE_CONTENT = "@xlia< system , 1.0 >:\n\nsystem mySystem {\n@public:\n\ttype myEnum enum { OFF , ON }\n\n\tport input myInputPort( myEnum );\n\tport output myOutputPort( int );\n\n@behavior:\n\tstatemachine myStatemachine \"my state machine\" {\n\t@private:\n\t\tvar integer n;\n\t\tvar myEnum trigger = OFF;\n\n\t@region:\n\t\tstate< start > q0 \"my start state\" {\n\t\t\t@enable{\n\t\t\t\tn = 0;\n\t\t\t}\n\t\t\ttransition t0 \"my simple transition\" {\n\t\t\t\tinput myInputPort( trigger );\n\t\t\t} --> qChoice;\n\t\t}\n\n\t\tstate< choice > qChoice \"my choice pseudostate\" {\n\t\t\ttransition t1 {\n\t\t\t\tguard( trigger == ON );\n\t\t\t\toutput myOutputPort( 42 );\n\t\t\t} --> q1;\n\n\t\t\ttransition< else > t2 \"my else transition\" --> q0;\n\t\t}\n\n\t\tstate q1 \"my simple state\" {\n\t\t\ttransition t3 {\n\t\t\t\tinput myInputPort( trigger );\n\t\t\t\tguard( trigger == OFF );\n\t\t\t\tn = 1;\n\t\t\t} --> qFinal;\n\n\t\t\ttransition< else > t4 \"my else transition\" --> q0;\n\t\t}\n\n\t\tstate< final > qFinal \"my final state\";\n\t}\n\n@com:\n\tconnect< env > {\n\t\tinput myInputPort;\n\t\toutput myOutputPort;\n\t}\n}\n";
    private final String NEW_FILE_XLIA = "examples/new_file.xlia";

    public NewFMLFileWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.mainPage = new WizardNewFileCreationPage("newFilePage1", this.getSelection());
        this.mainPage.setTitle("XLIA File");
        this.mainPage.setDescription("This wizard creates a new eXtensible Language For Interaction & Assembly file.");
        this.mainPage.setFileName("new_file");
        this.mainPage.setFileExtension("xlia");
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        final IPath containerPath = this.mainPage.getContainerFullPath();
        final String fileName = this.mainPage.getFileName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewFMLFileWizard.this.doFinish(containerPath, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(IPath containerPath, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember(containerPath);
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerPath + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream();
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream() throws IOException {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.efm.papyrus.wizard.newproject");
        URL url = bundle.getEntry("examples/new_file.xlia");
        if (url != null) {
            URL xliaTemplateURL = FileLocator.toFileURL((URL)url);
            if (url != null) {
                return xliaTemplateURL.openStream();
            }
        }
        return new ByteArrayInputStream("@xlia< system , 1.0 >:\n\nsystem mySystem {\n@public:\n\ttype myEnum enum { OFF , ON }\n\n\tport input myInputPort( myEnum );\n\tport output myOutputPort( int );\n\n@behavior:\n\tstatemachine myStatemachine \"my state machine\" {\n\t@private:\n\t\tvar integer n;\n\t\tvar myEnum trigger = OFF;\n\n\t@region:\n\t\tstate< start > q0 \"my start state\" {\n\t\t\t@enable{\n\t\t\t\tn = 0;\n\t\t\t}\n\t\t\ttransition t0 \"my simple transition\" {\n\t\t\t\tinput myInputPort( trigger );\n\t\t\t} --> qChoice;\n\t\t}\n\n\t\tstate< choice > qChoice \"my choice pseudostate\" {\n\t\t\ttransition t1 {\n\t\t\t\tguard( trigger == ON );\n\t\t\t\toutput myOutputPort( 42 );\n\t\t\t} --> q1;\n\n\t\t\ttransition< else > t2 \"my else transition\" --> q0;\n\t\t}\n\n\t\tstate q1 \"my simple state\" {\n\t\t\ttransition t3 {\n\t\t\t\tinput myInputPort( trigger );\n\t\t\t\tguard( trigger == OFF );\n\t\t\t\tn = 1;\n\t\t\t} --> qFinal;\n\n\t\t\ttransition< else > t4 \"my else transition\" --> q0;\n\t\t}\n\n\t\tstate< final > qFinal \"my final state\";\n\t}\n\n@com:\n\tconnect< env > {\n\t\tinput myInputPort;\n\t\toutput myOutputPort;\n\t}\n}\n".getBytes());
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.efm.papyrus.wizard.newproject", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    protected void initializeDefaultPageImageDescriptor() {
        super.initializeDefaultPageImageDescriptor();
    }
}

