/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.titan.designer.AST.Module;

class CycleCheck {
    private Map<Module, Node> map = new HashMap<Module, Node>();
    List<List<Module>> cycles;

    public CycleCheck(List<Module> modules) {
        for (Module module : modules) {
            this.map.put(module, new Node(module));
        }
        this.cycles = new ArrayList<List<Module>>();
        for (Module module : modules) {
            Node node = this.map.get(module);
            if (node.state != State.WHITE) continue;
            this.dfs(node);
        }
    }

    private void dfs(Node n) {
        n.state = State.GRAY;
        for (Module m : n.module.getImportedModules()) {
            Node child = this.map.get(m);
            if (child == null) continue;
            switch (child.state) {
                case WHITE: {
                    child.parent = n;
                    this.dfs(child);
                    break;
                }
                case GRAY: {
                    this.newCycle(child, n);
                    break;
                }
            }
        }
        n.state = State.BLACK;
    }

    private void newCycle(Node knot, Node n) {
        ArrayList<Module> cycle = new ArrayList<Module>();
        if (knot.module != n.module) {
            Node p = n;
            do {
                cycle.add(p.module);
            } while ((p = p.parent) != knot);
        }
        cycle.add(knot.module);
        this.cycles.add(cycle);
    }

    static enum State {
        WHITE,
        GRAY,
        BLACK;

    }

    static class Node {
        Module module;
        Node parent;
        State state;

        public Node(Module module) {
            this.module = module;
            this.parent = null;
            this.state = State.WHITE;
        }
    }
}

