/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.feature.ExternalFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.shared.CachedCheckboxTreeViewer;
import org.eclipse.pde.internal.ui.shared.FilteredCheckboxTree;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.UIJob;

public class FeatureImportWizardPage
extends WizardPage {
    private static final String SETTINGS_DROPLOCATION = "droplocation";
    private static final String SETTINGS_DOOTHER = "doother";
    private static final String SETTINGS_NOT_BINARY = "notbinary";
    protected static final int TYPING_DELAY = 300;
    private Label fOtherLocationLabel;
    private Button fRuntimeLocationButton;
    private Button fBrowseButton;
    private Combo fDropLocation;
    private boolean fSelfSetLocation;
    private String fCurrDropLocation;
    private Job fTextChangedJob;
    private CachedCheckboxTreeViewer fFeatureViewer;
    private Label fCounterLabel;
    private Button fSelectAllButton;
    private Button fDeselectAllButton;
    private IFeatureModel[] fModels;
    private Button fBinaryButton;

    public FeatureImportWizardPage() {
        super("FeatureImportWizardPage");
        this.setTitle(PDEUIMessages.FeatureImportWizard_FirstPage_title);
        this.setDescription(PDEUIMessages.FeatureImportWizard_FirstPage_desc);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.fRuntimeLocationButton = new Button(composite, 32);
        this.fillHorizontal((Control)this.fRuntimeLocationButton, 1, false);
        this.fRuntimeLocationButton.setText(PDEUIMessages.FeatureImportWizard_FirstPage_runtimeLocation);
        Composite otherLocationComposite = SWTFactory.createComposite(composite, 3, 1, 768, 0, 0);
        this.fOtherLocationLabel = new Label(otherLocationComposite, 0);
        this.fOtherLocationLabel.setText(PDEUIMessages.FeatureImportWizard_FirstPage_otherFolder);
        this.fDropLocation = new Combo(otherLocationComposite, 4);
        this.fillHorizontal((Control)this.fDropLocation, 1, true);
        this.fBrowseButton = new Button(otherLocationComposite, 8);
        this.fBrowseButton.setText(PDEUIMessages.FeatureImportWizard_FirstPage_browse);
        this.fBrowseButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fBrowseButton);
        this.createFeatureTable(composite);
        Composite underTableComp = SWTFactory.createComposite(composite, 2, 1, 768, 0, 0);
        this.fCounterLabel = SWTFactory.createLabel(underTableComp, "", 1);
        this.fCounterLabel.setLayoutData((Object)new GridData(16384, 128, true, false));
        Composite buttonComp = SWTFactory.createComposite(underTableComp, 2, 1, 0, 0, 0);
        buttonComp.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.fSelectAllButton = SWTFactory.createPushButton(buttonComp, PDEUIMessages.WizardCheckboxTablePart_selectAll, null);
        this.fSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureImportWizardPage.this.fFeatureViewer.setAllChecked(true);
                FeatureImportWizardPage.this.updateCounter();
                FeatureImportWizardPage.this.dialogChanged();
            }
        });
        this.fDeselectAllButton = SWTFactory.createPushButton(buttonComp, PDEUIMessages.WizardCheckboxTablePart_deselectAll, null);
        this.fDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureImportWizardPage.this.fFeatureViewer.setAllChecked(false);
                FeatureImportWizardPage.this.updateCounter();
                FeatureImportWizardPage.this.dialogChanged();
            }
        });
        this.fBinaryButton = SWTFactory.createCheckButton(composite, PDEUIMessages.FeatureImportWizard_FirstPage_binaryImport, null, true, 1);
        this.initializeFields(this.getDialogSettings());
        this.hookListeners();
        this.setControl((Control)composite);
        this.updateCounter();
        this.dialogChanged();
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.pde.doc.user.feature_import_first_page");
    }

    private void hookListeners() {
        this.fRuntimeLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureImportWizardPage.this.setOtherEnabled(!FeatureImportWizardPage.this.fRuntimeLocationButton.getSelection());
                FeatureImportWizardPage.this.setLocation(FeatureImportWizardPage.this.fRuntimeLocationButton.getSelection() ? TargetPlatform.getLocation() : FeatureImportWizardPage.this.fCurrDropLocation);
                FeatureImportWizardPage.this.handleReload();
            }
        });
        this.fDropLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean isItem = false;
                String[] items = FeatureImportWizardPage.this.fDropLocation.getItems();
                int i = 0;
                while (i < items.length) {
                    if (FeatureImportWizardPage.this.fDropLocation.getText().equals(items[i])) {
                        isItem = true;
                        break;
                    }
                    ++i;
                }
                FeatureImportWizardPage.this.locationChanged(isItem ? 0 : 300);
            }
        });
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPath chosen = FeatureImportWizardPage.this.chooseDropLocation();
                if (chosen != null) {
                    FeatureImportWizardPage.this.setLocation(chosen.toOSString());
                    FeatureImportWizardPage.this.handleReload();
                }
            }
        });
    }

    protected void locationChanged(long delay) {
        if (this.fTextChangedJob == null) {
            this.fTextChangedJob = new LocationChangedJob(this.getShell().getDisplay(), Messages.EditDirectoryContainerPage_3);
        } else {
            this.fTextChangedJob.cancel();
        }
        this.fTextChangedJob.schedule(delay);
    }

    private GridData fillHorizontal(Control control, int span, boolean grab) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = span;
        gd.grabExcessHorizontalSpace = grab;
        control.setLayoutData((Object)gd);
        return gd;
    }

    private void initializeFields(IDialogSettings initialSettings) {
        String[] dropItems = new String[]{};
        boolean doOther = false;
        boolean binary = true;
        if (initialSettings != null) {
            doOther = initialSettings.getBoolean(SETTINGS_DOOTHER);
            binary = !initialSettings.getBoolean(SETTINGS_NOT_BINARY);
            ArrayList<String> items = new ArrayList<String>();
            int i = 0;
            while (i < 6) {
                String curr = initialSettings.get(SETTINGS_DROPLOCATION + String.valueOf(i));
                if (curr != null && !items.contains(curr)) {
                    items.add(curr);
                }
                ++i;
            }
            if (items.size() == 0) {
                items.add("");
            }
            dropItems = items.toArray(new String[items.size()]);
        }
        this.fDropLocation.setItems(dropItems);
        this.fRuntimeLocationButton.setSelection(!doOther);
        this.setOtherEnabled(doOther);
        this.fCurrDropLocation = doOther ? dropItems[0] : TargetPlatform.getLocation();
        this.setLocation(this.fCurrDropLocation);
        this.fBinaryButton.setSelection(binary);
        this.validateDropLocation();
        this.handleReload();
    }

    private void setOtherEnabled(boolean enabled) {
        this.fOtherLocationLabel.setEnabled(enabled);
        this.fDropLocation.setEnabled(enabled);
        this.fBrowseButton.setEnabled(enabled);
    }

    public void storeSettings(boolean finishPressed) {
        IDialogSettings settings = this.getDialogSettings();
        boolean other = !this.fRuntimeLocationButton.getSelection();
        boolean binary = this.fBinaryButton.getSelection();
        if (finishPressed || this.fDropLocation.getText().length() > 0 && other) {
            settings.put(SETTINGS_DROPLOCATION + String.valueOf(0), this.fDropLocation.getText());
            String[] items = this.fDropLocation.getItems();
            int nEntries = Math.min(items.length, 5);
            int i = 0;
            while (i < nEntries) {
                settings.put(SETTINGS_DROPLOCATION + String.valueOf(i + 1), items[i]);
                ++i;
            }
        }
        if (finishPressed) {
            settings.put(SETTINGS_DOOTHER, other);
            settings.put(SETTINGS_NOT_BINARY, !binary);
        }
    }

    private IPath chooseDropLocation() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setFilterPath(this.fDropLocation.getText());
        dialog.setText(PDEUIMessages.FeatureImportWizard_messages_folder_title);
        dialog.setMessage(PDEUIMessages.FeatureImportWizard_messages_folder_message);
        String res = dialog.open();
        return res != null ? new Path(res) : null;
    }

    private void validateDropLocation() {
        String errorMessage = null;
        if (this.isOtherLocation()) {
            IPath curr = this.getDropLocation();
            if (curr.segmentCount() == 0) {
                errorMessage = PDEUIMessages.FeatureImportWizard_errors_locationMissing;
            } else if (!Path.ROOT.isValidPath(this.fDropLocation.getText())) {
                errorMessage = PDEUIMessages.FeatureImportWizard_errors_buildFolderInvalid;
            } else {
                File file = curr.toFile();
                if (!file.exists() || !file.isDirectory()) {
                    errorMessage = PDEUIMessages.FeatureImportWizard_errors_buildFolderMissing;
                }
            }
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    public boolean isBinary() {
        return this.fBinaryButton.getSelection();
    }

    public IPath getDropLocation() {
        return new Path(this.fDropLocation.getText().trim());
    }

    public boolean isOtherLocation() {
        return !this.fRuntimeLocationButton.getSelection();
    }

    private void handleReload() {
        Object[] models = this.getModels();
        this.fFeatureViewer.setInput(models);
        if (models != null) {
            if (!this.fRuntimeLocationButton.getSelection()) {
                String currItem = this.fDropLocation.getText();
                if (models.length > 0 && this.fDropLocation.indexOf(currItem) == -1) {
                    this.fDropLocation.add(currItem, 0);
                    if (this.fDropLocation.getItemCount() > 6) {
                        this.fDropLocation.remove(6);
                    }
                    this.storeSettings(false);
                }
                this.fDropLocation.setSelection(new Point(this.fDropLocation.getText().length(), this.fDropLocation.getText().length()));
            }
            this.fFeatureViewer.setCheckedElements(models);
        }
        this.updateCounter();
        this.dialogChanged();
    }

    public void createFeatureTable(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.verticalIndent = 5;
        gd.widthHint = 300;
        gd.heightHint = 300;
        container.setLayoutData((Object)gd);
        PatternFilter filter = new PatternFilter();
        filter.setIncludeLeadingWildcard(true);
        FilteredCheckboxTree tree = new FilteredCheckboxTree(container, null, 0, filter);
        this.fFeatureViewer = tree.getCheckboxTreeViewer();
        this.fFeatureViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Object[]) {
                    return (Object[])inputElement;
                }
                return new Object[0];
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                return new Object[0];
            }
        });
        this.fFeatureViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fFeatureViewer.setComparator(ListUtil.FEATURE_COMPARATOR);
        this.fFeatureViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                FeatureImportWizardPage.this.updateCounter();
                FeatureImportWizardPage.this.dialogChanged();
            }
        });
        this.fFeatureViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = FeatureImportWizardPage.this.fFeatureViewer.getSelection();
                if (!selection.isEmpty()) {
                    Object selected = ((IStructuredSelection)selection).getFirstElement();
                    FeatureImportWizardPage.this.fFeatureViewer.setChecked(selected, !FeatureImportWizardPage.this.fFeatureViewer.getChecked(selected));
                    FeatureImportWizardPage.this.updateCounter();
                    FeatureImportWizardPage.this.dialogChanged();
                }
            }
        });
    }

    private void updateCounter() {
        int total = 0;
        if (this.fModels != null) {
            total = this.fModels.length;
        }
        int checked = this.fFeatureViewer.getCheckedLeafCount();
        this.fCounterLabel.setText(NLS.bind((String)PDEUIMessages.WizardCheckboxTablePart_counter, (Object[])new String[]{Integer.valueOf(checked).toString(), Integer.valueOf(total).toString()}));
    }

    public void dispose() {
        super.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
    }

    public IFeatureModel[] getModels() {
        final IPath home = this.getDropLocation();
        final boolean useRuntimeLocation = this.fRuntimeLocationButton.getSelection() || TargetPlatform.getLocation().equals(this.fDropLocation.getText().trim());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(PDEUIMessages.FeatureImportWizard_messages_updating, -1);
                ArrayList<IFeatureModel> result = new ArrayList<IFeatureModel>();
                if (useRuntimeLocation) {
                    IFeatureModel[] allModels = PDECore.getDefault().getFeatureModelManager().getModels();
                    int i = 0;
                    while (i < allModels.length) {
                        if (allModels[i].getUnderlyingResource() == null) {
                            result.add(allModels[i]);
                        }
                        ++i;
                    }
                } else {
                    MultiStatus errors = FeatureImportWizardPage.this.doLoadFeatures(result, FeatureImportWizardPage.this.createPath(home));
                    if (errors != null && errors.getChildren().length > 0) {
                        PDEPlugin.log((IStatus)errors);
                    }
                }
                FeatureImportWizardPage.this.fModels = result.toArray(new IFeatureModel[result.size()]);
                monitor.done();
            }
        };
        IProgressService pservice = PlatformUI.getWorkbench().getProgressService();
        try {
            pservice.busyCursorWhile(runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return this.fModels;
    }

    private File createPath(IPath dropLocation) {
        File featuresDir = new File(dropLocation.toFile(), "features");
        if (featuresDir.exists()) {
            return featuresDir;
        }
        return null;
    }

    private MultiStatus doLoadFeatures(ArrayList<IFeatureModel> result, File path) {
        if (path == null) {
            return null;
        }
        File[] dirs = path.listFiles();
        if (dirs == null) {
            return null;
        }
        ArrayList<IStatus> resultStatus = new ArrayList<IStatus>();
        int i = 0;
        while (i < dirs.length) {
            IStatus status;
            File manifest;
            File dir = dirs[i];
            if (dir.isDirectory() && (manifest = new File(dir, "feature.xml")).exists() && (status = this.doLoadFeature(dir, manifest, result)) != null) {
                resultStatus.add(status);
            }
            ++i;
        }
        return new MultiStatus("org.eclipse.pde.ui", 0, resultStatus.toArray(new IStatus[resultStatus.size()]), PDEUIMessages.FeatureImportWizard_DetailedPage_problemsLoading, null);
    }

    private IStatus doLoadFeature(File dir, File manifest, ArrayList<IFeatureModel> result) {
        ExternalFeatureModel model = new ExternalFeatureModel();
        model.setInstallLocation(dir.getAbsolutePath());
        Status status = null;
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(manifest));
            model.load((InputStream)stream, false);
            if (!model.isValid()) {
                status = new Status(2, "org.eclipse.pde.ui", 0, NLS.bind((String)PDEUIMessages.FeatureImportWizardPage_importHasInvalid, (Object)dir), null);
            }
        }
        catch (Exception e) {
            status = new Status(4, "org.eclipse.pde.ui", 0, e.getMessage(), (Throwable)e);
        }
        if (stream != null) {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        if (status == null) {
            result.add((IFeatureModel)model);
        }
        return status;
    }

    public IFeatureModel[] getSelectedModels() {
        Object[] selected = this.fFeatureViewer.getCheckedElements();
        IFeatureModel[] result = new IFeatureModel[selected.length];
        System.arraycopy(selected, 0, result, 0, selected.length);
        return result;
    }

    private void dialogChanged() {
        String message = null;
        if (this.fFeatureViewer != null && (this.fModels == null || this.fModels.length == 0)) {
            message = PDEUIMessages.FeatureImportWizard_messages_noFeatures;
        }
        this.setMessage(message, 1);
        this.setPageComplete(this.fFeatureViewer.getCheckedLeafCount() > 0);
    }

    public boolean isPageComplete() {
        return this.fFeatureViewer.getCheckedLeafCount() > 0;
    }

    private void setLocation(String location) {
        this.fSelfSetLocation = true;
        this.fDropLocation.setText(location);
        this.fSelfSetLocation = false;
    }

    class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (FeatureImportWizardPage.this.fModels != null) {
                return FeatureImportWizardPage.this.fModels;
            }
            return new Object[0];
        }
    }

    private class LocationChangedJob
    extends UIJob {
        public LocationChangedJob(Display jobDisplay, String name) {
            super(jobDisplay, name);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            FeatureImportWizardPage.this.validateDropLocation();
            if (!FeatureImportWizardPage.this.fRuntimeLocationButton.getSelection()) {
                String newLoc = FeatureImportWizardPage.this.fDropLocation.getText();
                if (FeatureImportWizardPage.this.getMessageType() != 2 && !newLoc.equals(FeatureImportWizardPage.this.fCurrDropLocation) && !FeatureImportWizardPage.this.fSelfSetLocation) {
                    FeatureImportWizardPage.this.handleReload();
                }
                FeatureImportWizardPage.this.fCurrDropLocation = newLoc;
            }
            return Status.OK_STATUS;
        }
    }
}

