/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.migrationsupport.rules;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.junit.Rule;
import org.junit.jupiter.migrationsupport.rules.AbstractTestRuleSupport;
import org.junit.jupiter.migrationsupport.rules.adapter.AbstractTestRuleAdapter;
import org.junit.jupiter.migrationsupport.rules.member.TestRuleAnnotatedMember;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.rules.TestRule;

class TestRuleMethodSupport
extends AbstractTestRuleSupport<Method> {
    TestRuleMethodSupport(Function<TestRuleAnnotatedMember, AbstractTestRuleAdapter> adapterGenerator, Class<? extends TestRule> ruleType) {
        super(adapterGenerator, ruleType);
    }

    @Override
    protected List<Method> findRuleAnnotatedMembers(Object testInstance) {
        Predicate<Method> isRuleMethod = method -> AnnotationUtils.isAnnotated((AnnotatedElement)method, Rule.class);
        Predicate<Method> hasCorrectReturnType = method -> method.getReturnType().isAssignableFrom(this.getRuleType());
        return ReflectionUtils.findMethods(testInstance.getClass(), isRuleMethod.and(hasCorrectReturnType));
    }
}

