/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSHintHelper;
import org.eclipse.jdt.internal.ui.javaeditor.NLSKeyHyperlink;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.texteditor.ITextEditor;

public class NLSKeyHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (region == null || textEditor == null) {
            return null;
        }
        IEditorSite site = textEditor.getEditorSite();
        if (site == null) {
            return null;
        }
        ITypeRoot javaElement = this.getInputJavaElement(textEditor);
        if (javaElement == null) {
            return null;
        }
        CompilationUnit ast = SharedASTProvider.getAST(javaElement, SharedASTProvider.WAIT_NO, null);
        if (ast == null) {
            return null;
        }
        ASTNode node = NodeFinder.perform((ASTNode)ast, (int)region.getOffset(), (int)1);
        if (!(node instanceof StringLiteral) && !(node instanceof SimpleName)) {
            return null;
        }
        if (node.getLocationInParent() == QualifiedName.QUALIFIER_PROPERTY) {
            return null;
        }
        Region nlsKeyRegion = new Region(node.getStartPosition(), node.getLength());
        AccessorClassReference ref = NLSHintHelper.getAccessorClassReference(ast, (IRegion)nlsKeyRegion);
        if (ref == null) {
            return null;
        }
        String keyName = null;
        keyName = node instanceof StringLiteral ? ((StringLiteral)node).getLiteralValue() : ((SimpleName)node).getIdentifier();
        if (keyName != null) {
            return new IHyperlink[]{new NLSKeyHyperlink((IRegion)nlsKeyRegion, keyName, ref, (IEditorPart)textEditor)};
        }
        return null;
    }

    private ITypeRoot getInputJavaElement(ITextEditor editor) {
        return JavaUI.getEditorInputTypeRoot(editor.getEditorInput());
    }
}

