/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.core.workflow.serializer;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.efm.execution.core.IWorkflowConfigurationConstants;
import org.eclipse.efm.execution.core.util.PrettyPrintWriter;
import org.eclipse.efm.execution.core.workflow.Director;
import org.eclipse.efm.execution.core.workflow.common.ManifestCustomImpl;
import org.eclipse.efm.execution.core.workflow.common.TraceElementKind;
import org.eclipse.efm.execution.core.workflow.common.TraceSpecificationCustomImpl;
import org.eclipse.efm.execution.core.workflow.serializer.impl.ModelGraphvizSerializerWorkerImpl;

public class SymbexGraphvizSerializerWorkerCustomImpl
extends ModelGraphvizSerializerWorkerImpl
implements IWorkflowConfigurationConstants {
    protected SymbexGraphvizSerializerWorkerCustomImpl(Director director, String name) {
        this.setDirector(director);
        this.setName(name);
    }

    protected SymbexGraphvizSerializerWorkerCustomImpl(Director director, String name, String description) {
        this.setDirector(director);
        this.setName(name);
        this.setDescription(description);
    }

    public static SymbexGraphvizSerializerWorkerCustomImpl create(Director director, ILaunchConfiguration configuration) {
        String strFilename;
        String strTrace;
        String strCSS;
        String strFormat;
        SymbexGraphvizSerializerWorkerCustomImpl serializerWorker = new SymbexGraphvizSerializerWorkerCustomImpl(director, "symbex2graphiz");
        try {
            strFormat = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_FORMAT_SPEC", "node#header = EC#%1%<Ev:%2% , H:%3%>\\n%6%\nlifeline#state = %2%:%4%\npath#condition = PC: %1%\npath#timed#condition = PtC: %1%\nnode#condition = NC: %1%\nnode#timed#condition = NtC: %1%\nassign     = %3%=%4%\nnewfresh   = newfresh(%2%:%3%) <- %4%\ninput#env  = INPUT %2%:%3%%4%\ninput#rdv  = input %2%:%3%%4%\ninput      = input %2%:%3%%4%\noutput#env = OUTPUT %2%:%3%%4%\noutput#rdv = output %2%:%3%%4%\noutput     = output %2%:%3%%4%\nroutine    = invoke %2%:%3%\ntransition = fired transition %3%\nmachine    = \"run %2%:%3%\"");
        }
        catch (CoreException e) {
            e.printStackTrace();
            strFormat = "node#header = EC#%1%<Ev:%2% , H:%3%>\\n%6%\nlifeline#state = %2%:%4%\npath#condition = PC: %1%\npath#timed#condition = PtC: %1%\nnode#condition = NC: %1%\nnode#timed#condition = NtC: %1%\nassign     = %3%=%4%\nnewfresh   = newfresh(%2%:%3%) <- %4%\ninput#env  = INPUT %2%:%3%%4%\ninput#rdv  = input %2%:%3%%4%\ninput      = input %2%:%3%%4%\noutput#env = OUTPUT %2%:%3%%4%\noutput#rdv = output %2%:%3%%4%\noutput     = output %2%:%3%%4%\nroutine    = invoke %2%:%3%\ntransition = fired transition %3%\nmachine    = \"run %2%:%3%\"";
        }
        if (strFormat != null && !strFormat.isEmpty()) {
            TraceSpecificationCustomImpl format = TraceSpecificationCustomImpl.create("format", strFormat);
            serializerWorker.setFormat(format);
        }
        try {
            strCSS = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_CSS_SPEC", "node#color = 'lightblue'\nnode#shape = 'ellipse'\nnode#style = 'filled'\nnode#passed#color = 'yellow'\nnode#passed#shape = 'ellipse'\nnode#passed#style = 'filled'\nnode#failed#color = 'red'\nnode#failed#shape = 'doubleoctagon'\nnode#failed#style = 'filled'\nnode#inconclusive#color = 'orange'\nnode#inconclusive#shape = 'octagon'\nnode#inconclusive#style = 'filled'\nnode#aborted#color = 'red'\nnode#aborted#shape = 'octagon'\nnode#aborted#style = 'filled'\nnode#warning#color = 'orange'\nnode#warning#shape = 'ellipse'\nnode#warning#style = 'filled'\nnode#error#color = 'red'\nnode#error#shape = 'ellipse'\nnode#error#style = 'filled'\nnode#alert#color = 'red'\nnode#alert#shape = 'ellipse'\nnode#alert#style = 'filled'\nnode#exit#color = 'orange'\nnode#exit#shape = 'tripleoctagon'\nnode#exit#style = 'filled'\nnode#redundancy#source#color = 'green'\nnode#redundancy#source#shape = 'cds'\nnode#redundancy#source#style = 'filled'\nnode#redundancy#target#color = 'greenyellow'\nnode#redundancy#target#shape = 'septagon'\nnode#redundancy#target#style = 'filled'\npath#passed#color = 'lawngreen'\npath#passed#shape = 'tripleoctagon'\npath#passed#style = 'filled'\npath#failed#color = 'red'\npath#failed#shape = 'doubleoctagon'\npath#failed#style = 'filled'\npath#inconclusive#color = 'orange'\npath#inconclusive#shape = 'octagon'\npath#inconclusive#style = 'filled'\npath#aborted#color = 'red'\npath#aborted#shape = 'octagon'\npath#aborted#style = 'filled'");
        }
        catch (CoreException e) {
            e.printStackTrace();
            strCSS = "node#color = 'lightblue'\nnode#shape = 'ellipse'\nnode#style = 'filled'\nnode#passed#color = 'yellow'\nnode#passed#shape = 'ellipse'\nnode#passed#style = 'filled'\nnode#failed#color = 'red'\nnode#failed#shape = 'doubleoctagon'\nnode#failed#style = 'filled'\nnode#inconclusive#color = 'orange'\nnode#inconclusive#shape = 'octagon'\nnode#inconclusive#style = 'filled'\nnode#aborted#color = 'red'\nnode#aborted#shape = 'octagon'\nnode#aborted#style = 'filled'\nnode#warning#color = 'orange'\nnode#warning#shape = 'ellipse'\nnode#warning#style = 'filled'\nnode#error#color = 'red'\nnode#error#shape = 'ellipse'\nnode#error#style = 'filled'\nnode#alert#color = 'red'\nnode#alert#shape = 'ellipse'\nnode#alert#style = 'filled'\nnode#exit#color = 'orange'\nnode#exit#shape = 'tripleoctagon'\nnode#exit#style = 'filled'\nnode#redundancy#source#color = 'green'\nnode#redundancy#source#shape = 'cds'\nnode#redundancy#source#style = 'filled'\nnode#redundancy#target#color = 'greenyellow'\nnode#redundancy#target#shape = 'septagon'\nnode#redundancy#target#style = 'filled'\npath#passed#color = 'lawngreen'\npath#passed#shape = 'tripleoctagon'\npath#passed#style = 'filled'\npath#failed#color = 'red'\npath#failed#shape = 'doubleoctagon'\npath#failed#style = 'filled'\npath#inconclusive#color = 'orange'\npath#inconclusive#shape = 'octagon'\npath#inconclusive#style = 'filled'\npath#aborted#color = 'red'\npath#aborted#shape = 'octagon'\npath#aborted#style = 'filled'";
        }
        if (strCSS != null && !strCSS.isEmpty()) {
            TraceSpecificationCustomImpl css = TraceSpecificationCustomImpl.create("css", strCSS, TraceElementKind.RAW_ATTRIBUTE);
            serializerWorker.setCSS(css);
        }
        try {
            strTrace = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_TRACE_SPEC", "com = [*]\nvariable = [*]\n// See full grammar of [Trace Specification] at the end of this generated file");
        }
        catch (CoreException e) {
            e.printStackTrace();
            strTrace = "com = [*]\nvariable = [*]\n// See full grammar of [Trace Specification] at the end of this generated file";
        }
        if (strTrace != null && !strTrace.isEmpty()) {
            TraceSpecificationCustomImpl trace = TraceSpecificationCustomImpl.create("trace", strTrace);
            serializerWorker.setTrace(trace);
        }
        try {
            strFilename = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_FILENAME", "symbex_output.gv");
        }
        catch (CoreException e) {
            e.printStackTrace();
            strFilename = "symbex_output.gv";
        }
        serializerWorker.setFileName(strFilename);
        return serializerWorker;
    }

    public static SymbexGraphvizSerializerWorkerCustomImpl createSecond(Director director, ILaunchConfiguration configuration) {
        String strFilename;
        String strTrace;
        String strCSS;
        String strFormat;
        SymbexGraphvizSerializerWorkerCustomImpl serializerWorker = new SymbexGraphvizSerializerWorkerCustomImpl(director, "symbex2graphiz#extension");
        try {
            strFormat = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_ENABLED_SECOND_SYMBEX_OUTPUT_GRAPHVIZ_FORMAT_SPEC", "node#header = EC#%1%<Ev:%2% , H:%3%>\\n%6%\nlifeline#state = %2%:%4%\npath#condition = PC: %1%\npath#timed#condition = PtC: %1%\nnode#condition = NC: %1%\nnode#timed#condition = NtC: %1%\nassign     = %3%=%4%\nnewfresh   = newfresh(%2%:%3%) <- %4%\ninput#env  = INPUT %2%:%3%%4%\ninput#rdv  = input %2%:%3%%4%\ninput      = input %2%:%3%%4%\noutput#env = OUTPUT %2%:%3%%4%\noutput#rdv = output %2%:%3%%4%\noutput     = output %2%:%3%%4%\nroutine    = invoke %2%:%3%\ntransition = fired transition %3%\nmachine    = \"run %2%:%3%\"");
        }
        catch (CoreException e) {
            e.printStackTrace();
            strFormat = "node#header = EC#%1%<Ev:%2% , H:%3%>\\n%6%\nlifeline#state = %2%:%4%\npath#condition = PC: %1%\npath#timed#condition = PtC: %1%\nnode#condition = NC: %1%\nnode#timed#condition = NtC: %1%\nassign     = %3%=%4%\nnewfresh   = newfresh(%2%:%3%) <- %4%\ninput#env  = INPUT %2%:%3%%4%\ninput#rdv  = input %2%:%3%%4%\ninput      = input %2%:%3%%4%\noutput#env = OUTPUT %2%:%3%%4%\noutput#rdv = output %2%:%3%%4%\noutput     = output %2%:%3%%4%\nroutine    = invoke %2%:%3%\ntransition = fired transition %3%\nmachine    = \"run %2%:%3%\"";
        }
        if (strFormat != null && !strFormat.isEmpty()) {
            TraceSpecificationCustomImpl format = TraceSpecificationCustomImpl.create("format", strFormat);
            serializerWorker.setFormat(format);
        }
        try {
            strCSS = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_CSS_SPEC", "node#color = 'lightblue'\nnode#shape = 'ellipse'\nnode#style = 'filled'\nnode#passed#color = 'yellow'\nnode#passed#shape = 'ellipse'\nnode#passed#style = 'filled'\nnode#failed#color = 'red'\nnode#failed#shape = 'doubleoctagon'\nnode#failed#style = 'filled'\nnode#inconclusive#color = 'orange'\nnode#inconclusive#shape = 'octagon'\nnode#inconclusive#style = 'filled'\nnode#aborted#color = 'red'\nnode#aborted#shape = 'octagon'\nnode#aborted#style = 'filled'\nnode#warning#color = 'orange'\nnode#warning#shape = 'ellipse'\nnode#warning#style = 'filled'\nnode#error#color = 'red'\nnode#error#shape = 'ellipse'\nnode#error#style = 'filled'\nnode#alert#color = 'red'\nnode#alert#shape = 'ellipse'\nnode#alert#style = 'filled'\nnode#exit#color = 'orange'\nnode#exit#shape = 'tripleoctagon'\nnode#exit#style = 'filled'\nnode#redundancy#source#color = 'green'\nnode#redundancy#source#shape = 'cds'\nnode#redundancy#source#style = 'filled'\nnode#redundancy#target#color = 'greenyellow'\nnode#redundancy#target#shape = 'septagon'\nnode#redundancy#target#style = 'filled'\npath#passed#color = 'lawngreen'\npath#passed#shape = 'tripleoctagon'\npath#passed#style = 'filled'\npath#failed#color = 'red'\npath#failed#shape = 'doubleoctagon'\npath#failed#style = 'filled'\npath#inconclusive#color = 'orange'\npath#inconclusive#shape = 'octagon'\npath#inconclusive#style = 'filled'\npath#aborted#color = 'red'\npath#aborted#shape = 'octagon'\npath#aborted#style = 'filled'");
        }
        catch (CoreException e) {
            e.printStackTrace();
            strCSS = "node#color = 'lightblue'\nnode#shape = 'ellipse'\nnode#style = 'filled'\nnode#passed#color = 'yellow'\nnode#passed#shape = 'ellipse'\nnode#passed#style = 'filled'\nnode#failed#color = 'red'\nnode#failed#shape = 'doubleoctagon'\nnode#failed#style = 'filled'\nnode#inconclusive#color = 'orange'\nnode#inconclusive#shape = 'octagon'\nnode#inconclusive#style = 'filled'\nnode#aborted#color = 'red'\nnode#aborted#shape = 'octagon'\nnode#aborted#style = 'filled'\nnode#warning#color = 'orange'\nnode#warning#shape = 'ellipse'\nnode#warning#style = 'filled'\nnode#error#color = 'red'\nnode#error#shape = 'ellipse'\nnode#error#style = 'filled'\nnode#alert#color = 'red'\nnode#alert#shape = 'ellipse'\nnode#alert#style = 'filled'\nnode#exit#color = 'orange'\nnode#exit#shape = 'tripleoctagon'\nnode#exit#style = 'filled'\nnode#redundancy#source#color = 'green'\nnode#redundancy#source#shape = 'cds'\nnode#redundancy#source#style = 'filled'\nnode#redundancy#target#color = 'greenyellow'\nnode#redundancy#target#shape = 'septagon'\nnode#redundancy#target#style = 'filled'\npath#passed#color = 'lawngreen'\npath#passed#shape = 'tripleoctagon'\npath#passed#style = 'filled'\npath#failed#color = 'red'\npath#failed#shape = 'doubleoctagon'\npath#failed#style = 'filled'\npath#inconclusive#color = 'orange'\npath#inconclusive#shape = 'octagon'\npath#inconclusive#style = 'filled'\npath#aborted#color = 'red'\npath#aborted#shape = 'octagon'\npath#aborted#style = 'filled'";
        }
        if (strCSS != null && !strCSS.isEmpty()) {
            TraceSpecificationCustomImpl css = TraceSpecificationCustomImpl.create("css", strCSS, TraceElementKind.RAW_ATTRIBUTE);
            serializerWorker.setCSS(css);
        }
        try {
            strTrace = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_SECOND_SYMBEX_OUTPUT_GRAPHVIZ_TRACE_SPEC", "com = [*]\n// See full grammar of [Trace Specification] at the end of this generated file");
        }
        catch (CoreException e) {
            e.printStackTrace();
            strTrace = "com = [*]\n// See full grammar of [Trace Specification] at the end of this generated file";
        }
        if (strTrace != null && !strTrace.isEmpty()) {
            TraceSpecificationCustomImpl trace = TraceSpecificationCustomImpl.create("trace", strTrace);
            serializerWorker.setTrace(trace);
        }
        try {
            strFilename = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_SECOND_SYMBEX_OUTPUT_GRAPHVIZ_FILENAME", "symbex_output_extension.gv");
        }
        catch (CoreException e) {
            e.printStackTrace();
            strFilename = "symbex_output_extension.gv";
        }
        serializerWorker.setFileName(strFilename);
        return serializerWorker;
    }

    public void toWriter(PrettyPrintWriter writer) {
        TraceSpecificationCustomImpl css;
        TraceSpecificationCustomImpl format;
        writer.commentLine(this.getComment());
        writer.appendTab("serializer#symbex#graphviz");
        String str = this.getName();
        if (str != null) {
            writer.append(' ').append(str);
        }
        if ((str = this.getDescription()) != null) {
            writer.append(" '").append(str).append("'");
        }
        writer.appendEol(" {");
        PrettyPrintWriter writer2 = writer.itab2();
        ManifestCustomImpl manifest = (ManifestCustomImpl)this.getManifest();
        if (manifest != null) {
            manifest.toWriter(writer2);
        }
        writer2.appendTabEol("property [");
        writer2.appendTab2Eol("info#selection = 'ALL'");
        writer2.appendTab2Eol("data#selection = 'MODIFIED'");
        writer2.appendTabEol("] // end property");
        TraceSpecificationCustomImpl trace = (TraceSpecificationCustomImpl)this.getTrace();
        if (trace != null) {
            trace.toWriter(writer2);
        }
        if ((format = (TraceSpecificationCustomImpl)this.getFormat()) != null) {
            format.toWriter(writer2);
        }
        if ((css = (TraceSpecificationCustomImpl)this.getCSS()) != null) {
            css.toWriter(writer2);
        }
        String justifier = "";
        writer2.appendTabEol("vfs [");
        String path = this.getFolderName();
        if (path != null) {
            writer2.appendTab2("folder = \"").append(path).appendEol("\"");
            justifier = "  ";
        }
        if ((path = this.getFileName()) != null) {
            writer2.appendTab2("file").append(justifier).append(" = \"").append(path).appendEol("\"");
        }
        writer2.appendTabEol("] // end vfs");
        writer.appendTabEol("}");
    }
}

