/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.model;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Pair;
import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationTypeMismatchException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.EnumConstantNotPresentExceptionProxy;
import sun.reflect.annotation.ExceptionProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProxyMaker {
    private final Attribute.Compound anno;
    private final Class<? extends Annotation> annoType;

    private AnnotationProxyMaker(Attribute.Compound compound, Class<? extends Annotation> clazz) {
        this.anno = compound;
        this.annoType = clazz;
    }

    public static <A extends Annotation> A generateAnnotation(Attribute.Compound compound, Class<A> clazz) {
        AnnotationProxyMaker annotationProxyMaker = new AnnotationProxyMaker(compound, clazz);
        return (A)((Annotation)clazz.cast(annotationProxyMaker.generateAnnotation()));
    }

    private Annotation generateAnnotation() {
        return AnnotationParser.annotationForMap(this.annoType, this.getAllReflectedValues());
    }

    private Map<String, Object> getAllReflectedValues() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<Symbol.MethodSymbol, Attribute> entry : this.getAllValues().entrySet()) {
            Symbol.MethodSymbol methodSymbol = entry.getKey();
            Object object = this.generateValue(methodSymbol, entry.getValue());
            if (object == null) continue;
            linkedHashMap.put(methodSymbol.name.toString(), object);
        }
        return linkedHashMap;
    }

    private Map<Symbol.MethodSymbol, Attribute> getAllValues() {
        LinkedHashMap<Symbol.MethodSymbol, Attribute> linkedHashMap = new LinkedHashMap<Symbol.MethodSymbol, Attribute>();
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)this.anno.type.tsym;
        Object object = classSymbol.members().elems;
        while (object != null) {
            Symbol.MethodSymbol object2;
            Attribute attribute;
            if (((Scope.Entry)object).sym.kind == 16 && (attribute = (object2 = (Symbol.MethodSymbol)((Scope.Entry)object).sym).getDefaultValue()) != null) {
                linkedHashMap.put(object2, attribute);
            }
            object = ((Scope.Entry)object).sibling;
        }
        for (Pair pair : this.anno.values) {
            linkedHashMap.put((Symbol.MethodSymbol)pair.fst, (Attribute)pair.snd);
        }
        return linkedHashMap;
    }

    private Object generateValue(Symbol.MethodSymbol methodSymbol, Attribute attribute) {
        ValueVisitor valueVisitor = new ValueVisitor(methodSymbol);
        return valueVisitor.getValue(attribute);
    }

    private static class MirroredTypeExceptionProxy
    extends ExceptionProxy {
        static final long serialVersionUID = 269L;
        private final transient TypeMirror type;
        private final String typeString;

        MirroredTypeExceptionProxy(TypeMirror typeMirror) {
            this.type = typeMirror;
            this.typeString = ((Object)typeMirror).toString();
        }

        public String toString() {
            return this.typeString;
        }

        public int hashCode() {
            return (this.type != null ? this.type : this.typeString).hashCode();
        }

        public boolean equals(Object object) {
            return this.type != null && object instanceof MirroredTypeExceptionProxy && ((Object)this.type).equals(((MirroredTypeExceptionProxy)object).type);
        }

        protected RuntimeException generateException() {
            return new MirroredTypeException(this.type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MirroredTypesExceptionProxy
    extends ExceptionProxy {
        static final long serialVersionUID = 269L;
        private final transient List<TypeMirror> types;
        private final String typeStrings;

        MirroredTypesExceptionProxy(List<TypeMirror> list) {
            this.types = list;
            this.typeStrings = list.toString();
        }

        public String toString() {
            return this.typeStrings;
        }

        public int hashCode() {
            return (this.types != null ? this.types : this.typeStrings).hashCode();
        }

        public boolean equals(Object object) {
            return this.types != null && object instanceof MirroredTypesExceptionProxy && this.types.equals(((MirroredTypesExceptionProxy)object).types);
        }

        @Override
        protected RuntimeException generateException() {
            return new MirroredTypesException(this.types);
        }
    }

    private class ValueVisitor
    implements Attribute.Visitor {
        private Symbol.MethodSymbol meth;
        private Class<?> returnClass;
        private Object value;

        ValueVisitor(Symbol.MethodSymbol methodSymbol) {
            this.meth = methodSymbol;
        }

        Object getValue(Attribute attribute) {
            Method method;
            try {
                method = AnnotationProxyMaker.this.annoType.getMethod(this.meth.name.toString(), new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
            this.returnClass = method.getReturnType();
            attribute.accept(this);
            if (!(this.value instanceof ExceptionProxy) && !AnnotationType.invocationHandlerReturnType(this.returnClass).isInstance(this.value)) {
                this.typeMismatch(method, attribute);
            }
            return this.value;
        }

        public void visitConstant(Attribute.Constant constant) {
            this.value = constant.getValue();
        }

        public void visitClass(Attribute.Class clazz) {
            this.value = new MirroredTypeExceptionProxy(clazz.type);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitArray(Attribute.Array array) {
            block9: {
                block8: {
                    Name name = ((Type.ArrayType)array.type).elemtype.tsym.name;
                    if (name != name.table.java_lang_Class) break block8;
                    List<TypeMirror> list = List.nil();
                    for (Attribute attribute : array.values) {
                        Type type = ((Attribute.Class)attribute).type;
                        list.add(type);
                    }
                    this.value = new MirroredTypesExceptionProxy(list);
                    break block9;
                }
                int n = array.values.length;
                Class<?> clazz = this.returnClass;
                this.returnClass = this.returnClass.getComponentType();
                try {
                    Object object = Array.newInstance(this.returnClass, n);
                    for (int i = 0; i < n; ++i) {
                        block11: {
                            block10: {
                                array.values[i].accept(this);
                                if (this.value == null) break block10;
                                if (!(this.value instanceof ExceptionProxy)) break block11;
                            }
                            Object var10_14 = null;
                            this.returnClass = clazz;
                            return;
                        }
                        try {
                            Array.set(object, i, this.value);
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.value = null;
                            Object var10_15 = null;
                            this.returnClass = clazz;
                            return;
                        }
                    }
                    this.value = object;
                }
                catch (Throwable throwable) {
                    Object var10_17 = null;
                    this.returnClass = clazz;
                    throw throwable;
                }
                Object var10_16 = null;
                this.returnClass = clazz;
                {
                }
            }
        }

        public void visitEnum(Attribute.Enum enum_) {
            if (this.returnClass.isEnum()) {
                String string = enum_.value.toString();
                try {
                    this.value = Enum.valueOf(this.returnClass, string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.value = new EnumConstantNotPresentExceptionProxy(this.returnClass, string);
                }
            } else {
                this.value = null;
            }
        }

        public void visitCompound(Attribute.Compound compound) {
            try {
                Class<Annotation> clazz = this.returnClass.asSubclass(Annotation.class);
                this.value = AnnotationProxyMaker.generateAnnotation(compound, clazz);
            }
            catch (ClassCastException classCastException) {
                this.value = null;
            }
        }

        public void visitError(Attribute.Error error) {
            this.value = null;
        }

        private void typeMismatch(final Method method, final Attribute attribute) {
            this.value = new ExceptionProxy(){
                static final long serialVersionUID = 269L;

                public String toString() {
                    return "<error>";
                }

                protected RuntimeException generateException() {
                    return new AnnotationTypeMismatchException(method, attribute.type.toString());
                }
            };
        }
    }
}

