/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;

public final class AppendToLines
extends BaseParamFilterReader
implements ChainableReader {
    private static final String APPEND_KEY = "append";
    private String append = null;
    private String queuedData = null;

    public AppendToLines() {
    }

    public AppendToLines(Reader in) {
        super(in);
    }

    public int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        int ch = -1;
        if (this.queuedData != null && this.queuedData.length() == 0) {
            this.queuedData = null;
        }
        if (this.queuedData != null) {
            ch = this.queuedData.charAt(0);
            this.queuedData = this.queuedData.substring(1);
            if (this.queuedData.length() == 0) {
                this.queuedData = null;
            }
        } else {
            this.queuedData = this.readLine();
            if (this.queuedData == null) {
                ch = -1;
            } else {
                if (this.append != null) {
                    String lf = "";
                    if (this.queuedData.endsWith("\r\n")) {
                        lf = "\r\n";
                    } else if (this.queuedData.endsWith("\n")) {
                        lf = "\n";
                    }
                    this.queuedData = this.queuedData.substring(0, this.queuedData.length() - lf.length()) + this.append + lf;
                }
                return this.read();
            }
        }
        return ch;
    }

    public void setAppend(String append) {
        this.append = append;
    }

    private String getAppend() {
        return this.append;
    }

    public Reader chain(Reader rdr) {
        AppendToLines newFilter = new AppendToLines(rdr);
        newFilter.setAppend(this.getAppend());
        newFilter.setInitialized(true);
        return newFilter;
    }

    private void initialize() {
        Parameter[] params = this.getParameters();
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (!APPEND_KEY.equals(params[i].getName())) continue;
                this.append = params[i].getValue();
                break;
            }
        }
    }
}

