/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.query;

import java.util.List;
import org.ascape.model.Agent;
import org.ascape.model.Scape;
import org.ascape.model.event.DefaultScapeListener;
import org.ascape.model.event.ScapeEvent;
import org.ascape.query.parser.BoolExprTree;
import org.ascape.query.parser.ParseException;
import org.ascape.query.parser.QTBooleanPhrase;
import org.ascape.query.parser.QTInput;
import org.ascape.util.Conditional;

public class Query
extends DefaultScapeListener {
    private static final long serialVersionUID = 1L;
    private Scape collection;
    private List results;
    private boolean dynamicSearch = true;
    private String queryString;
    private QTInput query;
    private int searchSize;
    private int searchPosition;
    private int searchFound;
    private boolean evaluating;
    Conditional condition = new Conditional(){
        private static final long serialVersionUID = 1L;

        public boolean meetsCondition(Object object) {
            Query query = Query.this;
            query.searchPosition = query.searchPosition + 1;
            Agent agent = (Agent)object;
            boolean res = ((QTBooleanPhrase)Query.this.query.jjtGetChild(0)).evaluate(agent);
            if (res) {
                Query query2 = Query.this;
                query2.searchFound = query2.searchFound + 1;
            }
            return res;
        }
    };

    public Query(Scape collection, String queryString) throws ParseException {
        this(collection, queryString, true);
    }

    public Query(Scape collection, String queryString, boolean dynamic) throws ParseException {
        this.scape = collection;
        this.dynamicSearch = dynamic;
        collection.addScapeListenerFirst(this);
        this.collection = collection;
        this.queryString = queryString;
        this.query = BoolExprTree.parse(queryString);
        this.query.validate(collection.getPrototypeAgent());
    }

    public void execute() {
        this.searchSize = this.collection.size();
        this.evaluating = true;
        this.results = this.collection.find(this.condition);
        this.evaluating = false;
    }

    public void scapeIterated(ScapeEvent scapeEvent) {
        super.scapeIterated(scapeEvent);
        if (this.dynamicSearch) {
            this.execute();
        }
    }

    public List getResults() {
        return this.results;
    }

    public String getName() {
        return "Query";
    }

    public boolean isDynamicSearch() {
        return this.dynamicSearch;
    }

    public void setDynamicSearch(boolean dynamicSearch) {
        this.dynamicSearch = dynamicSearch;
    }

    public int getSearchSize() {
        return this.searchSize;
    }

    public int getSearchPosition() {
        return this.searchPosition;
    }

    public int getSearchFound() {
        return this.searchFound;
    }

    public boolean isEvaluating() {
        return this.evaluating;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public QTInput getQuery() {
        return this.query;
    }
}

