/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.space;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.ascape.model.space.Array;
import org.ascape.model.space.Array2D;
import org.ascape.model.space.CollectionSpace;
import org.ascape.model.space.Coordinate;
import org.ascape.model.space.Coordinate2DDiscrete;
import org.ascape.model.space.CoordinateDiscrete;
import org.ascape.model.space.Geometry;
import org.ascape.model.space.Location;
import org.ascape.model.space.Node;
import org.ascape.model.space.Relative;
import org.ascape.util.Conditional;
import org.ascape.util.RandomIterator;
import org.ascape.util.ResetableIterator;

public abstract class Array2DBase
extends Array
implements Relative {
    private static final long serialVersionUID = 1L;
    protected Node[][] cells = new Node[0][0];
    private Node[] agents = new Node[0];
    protected int[] order;
    protected boolean nearnessLineOfSight = true;
    private int[][] foundCellsCoordinates = new int[1000][2];
    protected static final int[][][] relativeCoordinatesTemplate;
    protected int[][][] relativeCoordinates = new int[relativeCoordinatesTemplate.length][16][2];
    protected static int[] relativeCoordinatesRankLengths;
    protected static double[] relativeCoordinatesRankDistance;
    protected static int[] sumOfCoordinatesWithinRank;
    public static int rankLimit;
    protected int currentRank = 0;
    protected int currentPositionInRank = 0;

    /*
     * Opcode count of 15659 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        int[][][] nArrayArray = new int[135][][];
        nArrayArray[0] = new int[][]{new int[2]};
        int[][] nArrayArray2 = new int[4][];
        int[] nArray = new int[2];
        nArray[0] = 1;
        nArrayArray2[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        nArrayArray2[1] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = -1;
        nArrayArray2[2] = nArray3;
        int[] nArray4 = new int[2];
        nArray4[0] = -1;
        nArrayArray2[3] = nArray4;
        nArrayArray[1] = nArrayArray2;
        nArrayArray[2] = new int[][]{{1, 1}, {1, -1}, {-1, 1}, {-1, -1}};
        int[][] nArrayArray3 = new int[4][];
        int[] nArray5 = new int[2];
        nArray5[0] = 2;
        nArrayArray3[0] = nArray5;
        int[] nArray6 = new int[2];
        nArray6[1] = 2;
        nArrayArray3[1] = nArray6;
        int[] nArray7 = new int[2];
        nArray7[1] = -2;
        nArrayArray3[2] = nArray7;
        int[] nArray8 = new int[2];
        nArray8[0] = -2;
        nArrayArray3[3] = nArray8;
        nArrayArray[3] = nArrayArray3;
        nArrayArray[4] = new int[][]{{2, 1}, {2, -1}, {1, 2}, {1, -2}, {-1, 2}, {-1, -2}, {-2, 1}, {-2, -1}};
        nArrayArray[5] = new int[][]{{2, 2}, {2, -2}, {-2, 2}, {-2, -2}};
        int[][] nArrayArray4 = new int[4][];
        int[] nArray9 = new int[2];
        nArray9[0] = 3;
        nArrayArray4[0] = nArray9;
        int[] nArray10 = new int[2];
        nArray10[1] = 3;
        nArrayArray4[1] = nArray10;
        int[] nArray11 = new int[2];
        nArray11[1] = -3;
        nArrayArray4[2] = nArray11;
        int[] nArray12 = new int[2];
        nArray12[0] = -3;
        nArrayArray4[3] = nArray12;
        nArrayArray[6] = nArrayArray4;
        nArrayArray[7] = new int[][]{{3, 1}, {3, -1}, {1, 3}, {1, -3}, {-1, 3}, {-1, -3}, {-3, 1}, {-3, -1}};
        nArrayArray[8] = new int[][]{{3, 2}, {3, -2}, {2, 3}, {2, -3}, {-2, 3}, {-2, -3}, {-3, 2}, {-3, -2}};
        int[][] nArrayArray5 = new int[4][];
        int[] nArray13 = new int[2];
        nArray13[0] = 4;
        nArrayArray5[0] = nArray13;
        int[] nArray14 = new int[2];
        nArray14[1] = 4;
        nArrayArray5[1] = nArray14;
        int[] nArray15 = new int[2];
        nArray15[1] = -4;
        nArrayArray5[2] = nArray15;
        int[] nArray16 = new int[2];
        nArray16[0] = -4;
        nArrayArray5[3] = nArray16;
        nArrayArray[9] = nArrayArray5;
        nArrayArray[10] = new int[][]{{4, 1}, {4, -1}, {1, 4}, {1, -4}, {-1, 4}, {-1, -4}, {-4, 1}, {-4, -1}};
        nArrayArray[11] = new int[][]{{3, 3}, {3, -3}, {-3, 3}, {-3, -3}};
        nArrayArray[12] = new int[][]{{4, 2}, {4, -2}, {2, 4}, {2, -4}, {-2, 4}, {-2, -4}, {-4, 2}, {-4, -2}};
        int[][] nArrayArray6 = new int[12][];
        int[] nArray17 = new int[2];
        nArray17[0] = 5;
        nArrayArray6[0] = nArray17;
        nArrayArray6[1] = new int[]{4, 3};
        nArrayArray6[2] = new int[]{4, -3};
        nArrayArray6[3] = new int[]{3, 4};
        nArrayArray6[4] = new int[]{3, -4};
        int[] nArray18 = new int[2];
        nArray18[1] = 5;
        nArrayArray6[5] = nArray18;
        int[] nArray19 = new int[2];
        nArray19[1] = -5;
        nArrayArray6[6] = nArray19;
        nArrayArray6[7] = new int[]{-3, 4};
        nArrayArray6[8] = new int[]{-3, -4};
        nArrayArray6[9] = new int[]{-4, 3};
        nArrayArray6[10] = new int[]{-4, -3};
        int[] nArray20 = new int[2];
        nArray20[0] = -5;
        nArrayArray6[11] = nArray20;
        nArrayArray[13] = nArrayArray6;
        nArrayArray[14] = new int[][]{{5, 1}, {5, -1}, {1, 5}, {1, -5}, {-1, 5}, {-1, -5}, {-5, 1}, {-5, -1}};
        nArrayArray[15] = new int[][]{{5, 2}, {5, -2}, {2, 5}, {2, -5}, {-2, 5}, {-2, -5}, {-5, 2}, {-5, -2}};
        nArrayArray[16] = new int[][]{{4, 4}, {4, -4}, {-4, 4}, {-4, -4}};
        nArrayArray[17] = new int[][]{{5, 3}, {5, -3}, {3, 5}, {3, -5}, {-3, 5}, {-3, -5}, {-5, 3}, {-5, -3}};
        int[][] nArrayArray7 = new int[4][];
        int[] nArray21 = new int[2];
        nArray21[0] = 6;
        nArrayArray7[0] = nArray21;
        int[] nArray22 = new int[2];
        nArray22[1] = 6;
        nArrayArray7[1] = nArray22;
        int[] nArray23 = new int[2];
        nArray23[1] = -6;
        nArrayArray7[2] = nArray23;
        int[] nArray24 = new int[2];
        nArray24[0] = -6;
        nArrayArray7[3] = nArray24;
        nArrayArray[18] = nArrayArray7;
        nArrayArray[19] = new int[][]{{6, 1}, {6, -1}, {1, 6}, {1, -6}, {-1, 6}, {-1, -6}, {-6, 1}, {-6, -1}};
        nArrayArray[20] = new int[][]{{6, 2}, {6, -2}, {2, 6}, {2, -6}, {-2, 6}, {-2, -6}, {-6, 2}, {-6, -2}};
        nArrayArray[21] = new int[][]{{5, 4}, {5, -4}, {4, 5}, {4, -5}, {-4, 5}, {-4, -5}, {-5, 4}, {-5, -4}};
        nArrayArray[22] = new int[][]{{6, 3}, {6, -3}, {3, 6}, {3, -6}, {-3, 6}, {-3, -6}, {-6, 3}, {-6, -3}};
        int[][] nArrayArray8 = new int[4][];
        int[] nArray25 = new int[2];
        nArray25[0] = 7;
        nArrayArray8[0] = nArray25;
        int[] nArray26 = new int[2];
        nArray26[1] = 7;
        nArrayArray8[1] = nArray26;
        int[] nArray27 = new int[2];
        nArray27[1] = -7;
        nArrayArray8[2] = nArray27;
        int[] nArray28 = new int[2];
        nArray28[0] = -7;
        nArrayArray8[3] = nArray28;
        nArrayArray[23] = nArrayArray8;
        nArrayArray[24] = new int[][]{{7, 1}, {7, -1}, {5, 5}, {5, -5}, {1, 7}, {1, -7}, {-1, 7}, {-1, -7}, {-5, 5}, {-5, -5}, {-7, 1}, {-7, -1}};
        nArrayArray[25] = new int[][]{{6, 4}, {6, -4}, {4, 6}, {4, -6}, {-4, 6}, {-4, -6}, {-6, 4}, {-6, -4}};
        nArrayArray[26] = new int[][]{{7, 2}, {7, -2}, {2, 7}, {2, -7}, {-2, 7}, {-2, -7}, {-7, 2}, {-7, -2}};
        nArrayArray[27] = new int[][]{{7, 3}, {7, -3}, {3, 7}, {3, -7}, {-3, 7}, {-3, -7}, {-7, 3}, {-7, -3}};
        nArrayArray[28] = new int[][]{{6, 5}, {6, -5}, {5, 6}, {5, -6}, {-5, 6}, {-5, -6}, {-6, 5}, {-6, -5}};
        int[][] nArrayArray9 = new int[4][];
        int[] nArray29 = new int[2];
        nArray29[0] = 8;
        nArrayArray9[0] = nArray29;
        int[] nArray30 = new int[2];
        nArray30[1] = 8;
        nArrayArray9[1] = nArray30;
        int[] nArray31 = new int[2];
        nArray31[1] = -8;
        nArrayArray9[2] = nArray31;
        int[] nArray32 = new int[2];
        nArray32[0] = -8;
        nArrayArray9[3] = nArray32;
        nArrayArray[29] = nArrayArray9;
        nArrayArray[30] = new int[][]{{8, 1}, {8, -1}, {7, 4}, {7, -4}, {4, 7}, {4, -7}, {1, 8}, {1, -8}, {-1, 8}, {-1, -8}, {-4, 7}, {-4, -7}, {-7, 4}, {-7, -4}, {-8, 1}, {-8, -1}};
        nArrayArray[31] = new int[][]{{8, 2}, {8, -2}, {2, 8}, {2, -8}, {-2, 8}, {-2, -8}, {-8, 2}, {-8, -2}};
        nArrayArray[32] = new int[][]{{6, 6}, {6, -6}, {-6, 6}, {-6, -6}};
        nArrayArray[33] = new int[][]{{8, 3}, {8, -3}, {3, 8}, {3, -8}, {-3, 8}, {-3, -8}, {-8, 3}, {-8, -3}};
        nArrayArray[34] = new int[][]{{7, 5}, {7, -5}, {5, 7}, {5, -7}, {-5, 7}, {-5, -7}, {-7, 5}, {-7, -5}};
        nArrayArray[35] = new int[][]{{8, 4}, {8, -4}, {4, 8}, {4, -8}, {-4, 8}, {-4, -8}, {-8, 4}, {-8, -4}};
        int[][] nArrayArray10 = new int[4][];
        int[] nArray33 = new int[2];
        nArray33[0] = 9;
        nArrayArray10[0] = nArray33;
        int[] nArray34 = new int[2];
        nArray34[1] = 9;
        nArrayArray10[1] = nArray34;
        int[] nArray35 = new int[2];
        nArray35[1] = -9;
        nArrayArray10[2] = nArray35;
        int[] nArray36 = new int[2];
        nArray36[0] = -9;
        nArrayArray10[3] = nArray36;
        nArrayArray[36] = nArrayArray10;
        nArrayArray[37] = new int[][]{{9, 1}, {9, -1}, {1, 9}, {1, -9}, {-1, 9}, {-1, -9}, {-9, 1}, {-9, -1}};
        nArrayArray[38] = new int[][]{{9, 2}, {9, -2}, {7, 6}, {7, -6}, {6, 7}, {6, -7}, {2, 9}, {2, -9}, {-2, 9}, {-2, -9}, {-6, 7}, {-6, -7}, {-7, 6}, {-7, -6}, {-9, 2}, {-9, -2}};
        nArrayArray[39] = new int[][]{{8, 5}, {8, -5}, {5, 8}, {5, -8}, {-5, 8}, {-5, -8}, {-8, 5}, {-8, -5}};
        nArrayArray[40] = new int[][]{{9, 3}, {9, -3}, {3, 9}, {3, -9}, {-3, 9}, {-3, -9}, {-9, 3}, {-9, -3}};
        nArrayArray[41] = new int[][]{{9, 4}, {9, -4}, {4, 9}, {4, -9}, {-4, 9}, {-4, -9}, {-9, 4}, {-9, -4}};
        nArrayArray[42] = new int[][]{{7, 7}, {7, -7}, {-7, 7}, {-7, -7}};
        int[][] nArrayArray11 = new int[12][];
        int[] nArray37 = new int[2];
        nArray37[0] = 10;
        nArrayArray11[0] = nArray37;
        nArrayArray11[1] = new int[]{8, 6};
        nArrayArray11[2] = new int[]{8, -6};
        nArrayArray11[3] = new int[]{6, 8};
        nArrayArray11[4] = new int[]{6, -8};
        int[] nArray38 = new int[2];
        nArray38[1] = 10;
        nArrayArray11[5] = nArray38;
        int[] nArray39 = new int[2];
        nArray39[1] = -10;
        nArrayArray11[6] = nArray39;
        nArrayArray11[7] = new int[]{-6, 8};
        nArrayArray11[8] = new int[]{-6, -8};
        nArrayArray11[9] = new int[]{-8, 6};
        nArrayArray11[10] = new int[]{-8, -6};
        int[] nArray40 = new int[2];
        nArray40[0] = -10;
        nArrayArray11[11] = nArray40;
        nArrayArray[43] = nArrayArray11;
        nArrayArray[44] = new int[][]{{10, 1}, {10, -1}, {1, 10}, {1, -10}, {-1, 10}, {-1, -10}, {-10, 1}, {-10, -1}};
        nArrayArray[45] = new int[][]{{10, 2}, {10, -2}, {2, 10}, {2, -10}, {-2, 10}, {-2, -10}, {-10, 2}, {-10, -2}};
        nArrayArray[46] = new int[][]{{9, 5}, {9, -5}, {5, 9}, {5, -9}, {-5, 9}, {-5, -9}, {-9, 5}, {-9, -5}};
        nArrayArray[47] = new int[][]{{10, 3}, {10, -3}, {3, 10}, {3, -10}, {-3, 10}, {-3, -10}, {-10, 3}, {-10, -3}};
        nArrayArray[48] = new int[][]{{8, 7}, {8, -7}, {7, 8}, {7, -8}, {-7, 8}, {-7, -8}, {-8, 7}, {-8, -7}};
        nArrayArray[49] = new int[][]{{10, 4}, {10, -4}, {4, 10}, {4, -10}, {-4, 10}, {-4, -10}, {-10, 4}, {-10, -4}};
        nArrayArray[50] = new int[][]{{9, 6}, {9, -6}, {6, 9}, {6, -9}, {-6, 9}, {-6, -9}, {-9, 6}, {-9, -6}};
        int[][] nArrayArray12 = new int[4][];
        int[] nArray41 = new int[2];
        nArray41[0] = 11;
        nArrayArray12[0] = nArray41;
        int[] nArray42 = new int[2];
        nArray42[1] = 11;
        nArrayArray12[1] = nArray42;
        int[] nArray43 = new int[2];
        nArray43[1] = -11;
        nArrayArray12[2] = nArray43;
        int[] nArray44 = new int[2];
        nArray44[0] = -11;
        nArrayArray12[3] = nArray44;
        nArrayArray[51] = nArrayArray12;
        nArrayArray[52] = new int[][]{{11, 1}, {11, -1}, {1, 11}, {1, -11}, {-1, 11}, {-1, -11}, {-11, 1}, {-11, -1}};
        nArrayArray[53] = new int[][]{{11, 2}, {11, -2}, {10, 5}, {10, -5}, {5, 10}, {5, -10}, {2, 11}, {2, -11}, {-2, 11}, {-2, -11}, {-5, 10}, {-5, -10}, {-10, 5}, {-10, -5}, {-11, 2}, {-11, -2}};
        nArrayArray[54] = new int[][]{{8, 8}, {8, -8}, {-8, 8}, {-8, -8}};
        nArrayArray[55] = new int[][]{{11, 3}, {11, -3}, {9, 7}, {9, -7}, {7, 9}, {7, -9}, {3, 11}, {3, -11}, {-3, 11}, {-3, -11}, {-7, 9}, {-7, -9}, {-9, 7}, {-9, -7}, {-11, 3}, {-11, -3}};
        nArrayArray[56] = new int[][]{{10, 6}, {10, -6}, {6, 10}, {6, -10}, {-6, 10}, {-6, -10}, {-10, 6}, {-10, -6}};
        nArrayArray[57] = new int[][]{{11, 4}, {11, -4}, {4, 11}, {4, -11}, {-4, 11}, {-4, -11}, {-11, 4}, {-11, -4}};
        int[][] nArrayArray13 = new int[4][];
        int[] nArray45 = new int[2];
        nArray45[0] = 12;
        nArrayArray13[0] = nArray45;
        int[] nArray46 = new int[2];
        nArray46[1] = 12;
        nArrayArray13[1] = nArray46;
        int[] nArray47 = new int[2];
        nArray47[1] = -12;
        nArrayArray13[2] = nArray47;
        int[] nArray48 = new int[2];
        nArray48[0] = -12;
        nArrayArray13[3] = nArray48;
        nArrayArray[58] = nArrayArray13;
        nArrayArray[59] = new int[][]{{12, 1}, {12, -1}, {9, 8}, {9, -8}, {8, 9}, {8, -9}, {1, 12}, {1, -12}, {-1, 12}, {-1, -12}, {-8, 9}, {-8, -9}, {-9, 8}, {-9, -8}, {-12, 1}, {-12, -1}};
        nArrayArray[60] = new int[][]{{11, 5}, {11, -5}, {5, 11}, {5, -11}, {-5, 11}, {-5, -11}, {-11, 5}, {-11, -5}};
        nArrayArray[61] = new int[][]{{12, 2}, {12, -2}, {2, 12}, {2, -12}, {-2, 12}, {-2, -12}, {-12, 2}, {-12, -2}};
        nArrayArray[62] = new int[][]{{10, 7}, {10, -7}, {7, 10}, {7, -10}, {-7, 10}, {-7, -10}, {-10, 7}, {-10, -7}};
        nArrayArray[63] = new int[][]{{12, 3}, {12, -3}, {3, 12}, {3, -12}, {-3, 12}, {-3, -12}, {-12, 3}, {-12, -3}};
        nArrayArray[64] = new int[][]{{11, 6}, {11, -6}, {6, 11}, {6, -11}, {-6, 11}, {-6, -11}, {-11, 6}, {-11, -6}};
        nArrayArray[65] = new int[][]{{12, 4}, {12, -4}, {4, 12}, {4, -12}, {-4, 12}, {-4, -12}, {-12, 4}, {-12, -4}};
        nArrayArray[66] = new int[][]{{9, 9}, {9, -9}, {-9, 9}, {-9, -9}};
        nArrayArray[67] = new int[][]{{10, 8}, {10, -8}, {8, 10}, {8, -10}, {-8, 10}, {-8, -10}, {-10, 8}, {-10, -8}};
        int[][] nArrayArray14 = new int[12][];
        int[] nArray49 = new int[2];
        nArray49[0] = 13;
        nArrayArray14[0] = nArray49;
        nArrayArray14[1] = new int[]{12, 5};
        nArrayArray14[2] = new int[]{12, -5};
        nArrayArray14[3] = new int[]{5, 12};
        nArrayArray14[4] = new int[]{5, -12};
        int[] nArray50 = new int[2];
        nArray50[1] = 13;
        nArrayArray14[5] = nArray50;
        int[] nArray51 = new int[2];
        nArray51[1] = -13;
        nArrayArray14[6] = nArray51;
        nArrayArray14[7] = new int[]{-5, 12};
        nArrayArray14[8] = new int[]{-5, -12};
        nArrayArray14[9] = new int[]{-12, 5};
        nArrayArray14[10] = new int[]{-12, -5};
        int[] nArray52 = new int[2];
        nArray52[0] = -13;
        nArrayArray14[11] = nArray52;
        nArrayArray[68] = nArrayArray14;
        nArrayArray[69] = new int[][]{{13, 1}, {13, -1}, {11, 7}, {11, -7}, {7, 11}, {7, -11}, {1, 13}, {1, -13}, {-1, 13}, {-1, -13}, {-7, 11}, {-7, -11}, {-11, 7}, {-11, -7}, {-13, 1}, {-13, -1}};
        nArrayArray[70] = new int[][]{{13, 2}, {13, -2}, {2, 13}, {2, -13}, {-2, 13}, {-2, -13}, {-13, 2}, {-13, -2}};
        nArrayArray[71] = new int[][]{{13, 3}, {13, -3}, {3, 13}, {3, -13}, {-3, 13}, {-3, -13}, {-13, 3}, {-13, -3}};
        nArrayArray[72] = new int[][]{{12, 6}, {12, -6}, {6, 12}, {6, -12}, {-6, 12}, {-6, -12}, {-12, 6}, {-12, -6}};
        nArrayArray[73] = new int[][]{{10, 9}, {10, -9}, {9, 10}, {9, -10}, {-9, 10}, {-9, -10}, {-10, 9}, {-10, -9}};
        nArrayArray[74] = new int[][]{{13, 4}, {13, -4}, {11, 8}, {11, -8}, {8, 11}, {8, -11}, {4, 13}, {4, -13}, {-4, 13}, {-4, -13}, {-8, 11}, {-8, -11}, {-11, 8}, {-11, -8}, {-13, 4}, {-13, -4}};
        nArrayArray[75] = new int[][]{{12, 7}, {12, -7}, {7, 12}, {7, -12}, {-7, 12}, {-7, -12}, {-12, 7}, {-12, -7}};
        nArrayArray[76] = new int[][]{{13, 5}, {13, -5}, {5, 13}, {5, -13}, {-5, 13}, {-5, -13}, {-13, 5}, {-13, -5}};
        int[][] nArrayArray15 = new int[4][];
        int[] nArray53 = new int[2];
        nArray53[0] = 14;
        nArrayArray15[0] = nArray53;
        int[] nArray54 = new int[2];
        nArray54[1] = 14;
        nArrayArray15[1] = nArray54;
        int[] nArray55 = new int[2];
        nArray55[1] = -14;
        nArrayArray15[2] = nArray55;
        int[] nArray56 = new int[2];
        nArray56[0] = -14;
        nArrayArray15[3] = nArray56;
        nArrayArray[77] = nArrayArray15;
        nArrayArray[78] = new int[][]{{14, 1}, {14, -1}, {1, 14}, {1, -14}, {-1, 14}, {-1, -14}, {-14, 1}, {-14, -1}};
        nArrayArray[79] = new int[][]{{14, 2}, {14, -2}, {10, 10}, {10, -10}, {2, 14}, {2, -14}, {-2, 14}, {-2, -14}, {-10, 10}, {-10, -10}, {-14, 2}, {-14, -2}};
        nArrayArray[80] = new int[][]{{11, 9}, {11, -9}, {9, 11}, {9, -11}, {-9, 11}, {-9, -11}, {-11, 9}, {-11, -9}};
        nArrayArray[81] = new int[][]{{14, 3}, {14, -3}, {13, 6}, {13, -6}, {6, 13}, {6, -13}, {3, 14}, {3, -14}, {-3, 14}, {-3, -14}, {-6, 13}, {-6, -13}, {-13, 6}, {-13, -6}, {-14, 3}, {-14, -3}};
        nArrayArray[82] = new int[][]{{12, 8}, {12, -8}, {8, 12}, {8, -12}, {-8, 12}, {-8, -12}, {-12, 8}, {-12, -8}};
        nArrayArray[83] = new int[][]{{14, 4}, {14, -4}, {4, 14}, {4, -14}, {-4, 14}, {-4, -14}, {-14, 4}, {-14, -4}};
        nArrayArray[84] = new int[][]{{13, 7}, {13, -7}, {7, 13}, {7, -13}, {-7, 13}, {-7, -13}, {-13, 7}, {-13, -7}};
        nArrayArray[85] = new int[][]{{14, 5}, {14, -5}, {11, 10}, {11, -10}, {10, 11}, {10, -11}, {5, 14}, {5, -14}, {-5, 14}, {-5, -14}, {-10, 11}, {-10, -11}, {-11, 10}, {-11, -10}, {-14, 5}, {-14, -5}};
        int[][] nArrayArray16 = new int[12][];
        int[] nArray57 = new int[2];
        nArray57[0] = 15;
        nArrayArray16[0] = nArray57;
        nArrayArray16[1] = new int[]{12, 9};
        nArrayArray16[2] = new int[]{12, -9};
        nArrayArray16[3] = new int[]{9, 12};
        nArrayArray16[4] = new int[]{9, -12};
        int[] nArray58 = new int[2];
        nArray58[1] = 15;
        nArrayArray16[5] = nArray58;
        int[] nArray59 = new int[2];
        nArray59[1] = -15;
        nArrayArray16[6] = nArray59;
        nArrayArray16[7] = new int[]{-9, 12};
        nArrayArray16[8] = new int[]{-9, -12};
        nArrayArray16[9] = new int[]{-12, 9};
        nArrayArray16[10] = new int[]{-12, -9};
        int[] nArray60 = new int[2];
        nArray60[0] = -15;
        nArrayArray16[11] = nArray60;
        nArrayArray[86] = nArrayArray16;
        nArrayArray[87] = new int[][]{{15, 1}, {15, -1}, {1, 15}, {1, -15}, {-1, 15}, {-1, -15}, {-15, 1}, {-15, -1}};
        nArrayArray[88] = new int[][]{{15, 2}, {15, -2}, {2, 15}, {2, -15}, {-2, 15}, {-2, -15}, {-15, 2}, {-15, -2}};
        nArrayArray[89] = new int[][]{{14, 6}, {14, -6}, {6, 14}, {6, -14}, {-6, 14}, {-6, -14}, {-14, 6}, {-14, -6}};
        nArrayArray[90] = new int[][]{{13, 8}, {13, -8}, {8, 13}, {8, -13}, {-8, 13}, {-8, -13}, {-13, 8}, {-13, -8}};
        nArrayArray[91] = new int[][]{{15, 3}, {15, -3}, {3, 15}, {3, -15}, {-3, 15}, {-3, -15}, {-15, 3}, {-15, -3}};
        nArrayArray[92] = new int[][]{{15, 4}, {15, -4}, {4, 15}, {4, -15}, {-4, 15}, {-4, -15}, {-15, 4}, {-15, -4}};
        nArrayArray[93] = new int[][]{{11, 11}, {11, -11}, {-11, 11}, {-11, -11}};
        nArrayArray[94] = new int[][]{{12, 10}, {12, -10}, {10, 12}, {10, -12}, {-10, 12}, {-10, -12}, {-12, 10}, {-12, -10}};
        nArrayArray[95] = new int[][]{{14, 7}, {14, -7}, {7, 14}, {7, -14}, {-7, 14}, {-7, -14}, {-14, 7}, {-14, -7}};
        nArrayArray[96] = new int[][]{{15, 5}, {15, -5}, {13, 9}, {13, -9}, {9, 13}, {9, -13}, {5, 15}, {5, -15}, {-5, 15}, {-5, -15}, {-9, 13}, {-9, -13}, {-13, 9}, {-13, -9}, {-15, 5}, {-15, -5}};
        int[][] nArrayArray17 = new int[4][];
        int[] nArray61 = new int[2];
        nArray61[0] = 16;
        nArrayArray17[0] = nArray61;
        int[] nArray62 = new int[2];
        nArray62[1] = 16;
        nArrayArray17[1] = nArray62;
        int[] nArray63 = new int[2];
        nArray63[1] = -16;
        nArrayArray17[2] = nArray63;
        int[] nArray64 = new int[2];
        nArray64[0] = -16;
        nArrayArray17[3] = nArray64;
        nArrayArray[97] = nArrayArray17;
        nArrayArray[98] = new int[][]{{16, 1}, {16, -1}, {1, 16}, {1, -16}, {-1, 16}, {-1, -16}, {-16, 1}, {-16, -1}};
        nArrayArray[99] = new int[][]{{16, 2}, {16, -2}, {14, 8}, {14, -8}, {8, 14}, {8, -14}, {2, 16}, {2, -16}, {-2, 16}, {-2, -16}, {-8, 14}, {-8, -14}, {-14, 8}, {-14, -8}, {-16, 2}, {-16, -2}};
        nArrayArray[100] = new int[][]{{15, 6}, {15, -6}, {6, 15}, {6, -15}, {-6, 15}, {-6, -15}, {-15, 6}, {-15, -6}};
        nArrayArray[101] = new int[][]{{16, 3}, {16, -3}, {12, 11}, {12, -11}, {11, 12}, {11, -12}, {3, 16}, {3, -16}, {-3, 16}, {-3, -16}, {-11, 12}, {-11, -12}, {-12, 11}, {-12, -11}, {-16, 3}, {-16, -3}};
        nArrayArray[102] = new int[][]{{13, 10}, {13, -10}, {10, 13}, {10, -13}, {-10, 13}, {-10, -13}, {-13, 10}, {-13, -10}};
        nArrayArray[103] = new int[][]{{16, 4}, {16, -4}, {4, 16}, {4, -16}, {-4, 16}, {-4, -16}, {-16, 4}, {-16, -4}};
        nArrayArray[104] = new int[][]{{15, 7}, {15, -7}, {7, 15}, {7, -15}, {-7, 15}, {-7, -15}, {-15, 7}, {-15, -7}};
        nArrayArray[105] = new int[][]{{14, 9}, {14, -9}, {9, 14}, {9, -14}, {-9, 14}, {-9, -14}, {-14, 9}, {-14, -9}};
        nArrayArray[106] = new int[][]{{16, 5}, {16, -5}, {5, 16}, {5, -16}, {-5, 16}, {-5, -16}, {-16, 5}, {-16, -5}};
        nArrayArray[107] = new int[][]{{12, 12}, {12, -12}, {-12, 12}, {-12, -12}};
        nArrayArray[108] = new int[][]{{15, 8}, {15, -8}, {8, 15}, {8, -15}, {-8, 15}, {-8, -15}, {-15, 8}, {-15, -8}};
        nArrayArray[109] = new int[][]{{13, 11}, {13, -11}, {11, 13}, {11, -13}, {-11, 13}, {-11, -13}, {-13, 11}, {-13, -11}};
        nArrayArray[110] = new int[][]{{16, 6}, {16, -6}, {6, 16}, {6, -16}, {-6, 16}, {-6, -16}, {-16, 6}, {-16, -6}};
        nArrayArray[111] = new int[][]{{14, 10}, {14, -10}, {10, 14}, {10, -14}, {-10, 14}, {-10, -14}, {-14, 10}, {-14, -10}};
        nArrayArray[112] = new int[][]{{16, 7}, {16, -7}, {7, 16}, {7, -16}, {-7, 16}, {-7, -16}, {-16, 7}, {-16, -7}};
        nArrayArray[113] = new int[][]{{15, 9}, {15, -9}, {9, 15}, {9, -15}, {-9, 15}, {-9, -15}, {-15, 9}, {-15, -9}};
        nArrayArray[114] = new int[][]{{13, 12}, {13, -12}, {12, 13}, {12, -13}, {-12, 13}, {-12, -13}, {-13, 12}, {-13, -12}};
        nArrayArray[115] = new int[][]{{14, 11}, {14, -11}, {11, 14}, {11, -14}, {-11, 14}, {-11, -14}, {-14, 11}, {-14, -11}};
        nArrayArray[116] = new int[][]{{16, 8}, {16, -8}, {8, 16}, {8, -16}, {-8, 16}, {-8, -16}, {-16, 8}, {-16, -8}};
        nArrayArray[117] = new int[][]{{15, 10}, {15, -10}, {10, 15}, {10, -15}, {-10, 15}, {-10, -15}, {-15, 10}, {-15, -10}};
        nArrayArray[118] = new int[][]{{16, 9}, {16, -9}, {9, 16}, {9, -16}, {-9, 16}, {-9, -16}, {-16, 9}, {-16, -9}};
        nArrayArray[119] = new int[][]{{13, 13}, {13, -13}, {-13, 13}, {-13, -13}};
        nArrayArray[120] = new int[][]{{14, 12}, {14, -12}, {12, 14}, {12, -14}, {-12, 14}, {-12, -14}, {-14, 12}, {-14, -12}};
        nArrayArray[121] = new int[][]{{15, 11}, {15, -11}, {11, 15}, {11, -15}, {-11, 15}, {-11, -15}, {-15, 11}, {-15, -11}};
        nArrayArray[122] = new int[][]{{16, 10}, {16, -10}, {10, 16}, {10, -16}, {-10, 16}, {-10, -16}, {-16, 10}, {-16, -10}};
        nArrayArray[123] = new int[][]{{14, 13}, {14, -13}, {13, 14}, {13, -14}, {-13, 14}, {-13, -14}, {-14, 13}, {-14, -13}};
        nArrayArray[124] = new int[][]{{15, 12}, {15, -12}, {12, 15}, {12, -15}, {-12, 15}, {-12, -15}, {-15, 12}, {-15, -12}};
        nArrayArray[125] = new int[][]{{16, 11}, {16, -11}, {11, 16}, {11, -16}, {-11, 16}, {-11, -16}, {-16, 11}, {-16, -11}};
        nArrayArray[126] = new int[][]{{14, 14}, {14, -14}, {-14, 14}, {-14, -14}};
        nArrayArray[127] = new int[][]{{15, 13}, {15, -13}, {13, 15}, {13, -15}, {-13, 15}, {-13, -15}, {-15, 13}, {-15, -13}};
        nArrayArray[128] = new int[][]{{16, 12}, {16, -12}, {12, 16}, {12, -16}, {-12, 16}, {-12, -16}, {-16, 12}, {-16, -12}};
        nArrayArray[129] = new int[][]{{15, 14}, {15, -14}, {14, 15}, {14, -15}, {-14, 15}, {-14, -15}, {-15, 14}, {-15, -14}};
        nArrayArray[130] = new int[][]{{16, 13}, {16, -13}, {13, 16}, {13, -16}, {-13, 16}, {-13, -16}, {-16, 13}, {-16, -13}};
        nArrayArray[131] = new int[][]{{15, 15}, {15, -15}, {-15, 15}, {-15, -15}};
        nArrayArray[132] = new int[][]{{16, 14}, {16, -14}, {14, 16}, {14, -16}, {-14, 16}, {-14, -16}, {-16, 14}, {-16, -14}};
        nArrayArray[133] = new int[][]{{16, 15}, {16, -15}, {15, 16}, {15, -16}, {-15, 16}, {-15, -16}, {-16, 15}, {-16, -15}};
        nArrayArray[134] = new int[][]{{16, 16}, {16, -16}, {-16, 16}, {-16, -16}};
        relativeCoordinatesTemplate = nArrayArray;
        relativeCoordinatesRankLengths = new int[]{1, 4, 4, 4, 8, 4, 4, 8, 8, 4, 8, 4, 8, 12, 8, 8, 4, 8, 4, 8, 8, 8, 8, 4, 12, 8, 8, 8, 8, 4, 16, 8, 4, 8, 8, 8, 4, 8, 16, 8, 8, 8, 4, 12, 8, 8, 8, 8, 8, 8, 8, 4, 8, 16, 4, 16, 8, 8, 4, 16, 8, 8, 8, 8, 8, 8, 4, 8, 12, 16, 8, 8, 8, 8, 16, 8, 8, 4, 8, 12, 8, 16, 8, 8, 8, 16, 12, 8, 8, 8, 8, 8, 8, 4, 8, 8, 16, 4, 8, 16, 8, 16, 8, 8, 8, 8, 8, 4, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 8, 8, 8, 8, 8, 8, 4, 8, 8, 8, 8, 4, 8, 8, 4};
        sumOfCoordinatesWithinRank = new int[]{1, 5, 9, 13, 21, 25, 29, 37, 45, 49, 57, 61, 69, 81, 89, 97, 101, 109, 113, 121, 129, 137, 145, 149, 161, 169, 177, 185, 193, 197, 213, 221, 225, 233, 241, 249, 253, 261, 277, 285, 293, 301, 305, 317, 325, 333, 341, 349, 357, 365, 373, 377, 385, 401, 405, 421, 429, 437, 441, 457, 465, 473, 481, 489, 497, 505, 509, 517, 529, 545, 553, 561, 569, 577, 593, 601, 609, 613, 621, 633, 641, 657, 665, 673, 681, 697, 709, 717, 725, 733, 741, 749, 757, 761, 769, 777, 793, 797, 805, 821, 829, 845, 853, 861, 869, 877, 885, 889, 897, 905, 913, 921, 929, 937, 945, 953, 961, 969, 977, 981, 989, 997, 1005, 1013, 1021, 1029, 1033, 1041, 1049, 1057, 1065, 1069, 1077, 1085, 1089};
    }

    public Array2DBase() {
        relativeCoordinatesRankDistance = new double[relativeCoordinatesTemplate.length];
    }

    public Array2DBase(CoordinateDiscrete extent) {
        this();
        this.setExtent(extent);
    }

    public Object clone() {
        CollectionSpace clone = (CollectionSpace)super.clone();
        Coordinate2DDiscrete originalExtent = (Coordinate2DDiscrete)this.extent;
        clone.extent = new Coordinate2DDiscrete(originalExtent.getXValue(), originalExtent.getYValue());
        return clone;
    }

    public void construct() {
        this.cells = new Node[((Coordinate2DDiscrete)this.extent).getXValue()][((Coordinate2DDiscrete)this.extent).getYValue()];
        this.order = Array2DBase.createOrder(this.getSize());
    }

    public void populate() {
        int x = 0;
        while (x < this.cells.length) {
            int y = 0;
            while (y < this.cells[0].length) {
                this.cells[x][y] = (Node)this.getContext().getPrototype().clone();
                this.cells[x][y].setCoordinate(new Coordinate2DDiscrete(x, y));
                ++y;
            }
            ++x;
        }
        this.agents = null;
    }

    public void initialize() {
        super.initialize();
        this.order = Array2DBase.createOrder(((Coordinate2DDiscrete)this.extent).getXValue() * ((Coordinate2DDiscrete)this.extent).getYValue());
    }

    public void setGeometry(Geometry geometry) {
        super.setGeometry(geometry);
        if (geometry.getDimensionCount() != 2) {
            throw new RuntimeException("Tried to assign an inappropriate geometry.");
        }
    }

    public void setExtent(Coordinate extent) {
        super.setExtent(extent);
    }

    public void setExtent(int xSize, int ySize) {
        this.setExtent(new Coordinate2DDiscrete(xSize, ySize));
    }

    public void randomizeCallingOrder() {
        this.order = Array2DBase.randomizeOrder(this.order, this.getRandom());
    }

    public Iterator iterator() {
        return new Array2DIterator(null, null);
    }

    public ResetableIterator safeIterator() {
        return new Array2DIterator(null, null);
    }

    public ResetableIterator safeIterator(int start, int limit) {
        return new Array2DSubIterator(start, limit);
    }

    public RandomIterator safeRandomIterator() {
        return new Array2DRandomIterator();
    }

    public boolean isMutable() {
        return false;
    }

    public int getSize() {
        return ((Coordinate2DDiscrete)this.extent).getXValue() * ((Coordinate2DDiscrete)this.extent).getYValue();
    }

    public int getXSize() {
        if (this.cells != null) {
            return this.cells.length;
        }
        return 0;
    }

    public int getYSize() {
        if (this.cells != null) {
            if (this.cells.length != 0) {
                return this.cells[0].length;
            }
            return 0;
        }
        return 0;
    }

    public synchronized Node[] findCells(Conditional condition) {
        return this.findCells(condition, 0, 0, this.cells.length, this.cells[0].length);
    }

    public synchronized Node[] findCells(Conditional condition, int _x, int _y, int width, int height) {
        int count = 0;
        if (this.getSize() > this.foundCellsCoordinates.length) {
            this.foundCellsCoordinates = new int[this.getSize()][2];
        }
        int x = _x;
        while (x < width) {
            int y = _y;
            while (y < height) {
                if (condition.meetsCondition(this.cells[x][y])) {
                    this.foundCellsCoordinates[count][0] = x;
                    this.foundCellsCoordinates[count][1] = y;
                    ++count;
                }
                ++y;
            }
            ++x;
        }
        Node[] foundCells = new Node[count];
        int i = 0;
        while (i < count) {
            foundCells[i] = this.cells[this.foundCellsCoordinates[i][0]][this.foundCellsCoordinates[i][1]];
            ++i;
        }
        return foundCells;
    }

    public Location findRandom() {
        return this.cells[this.randomToLimit(this.cells.length)][this.randomToLimit(this.cells[0].length)];
    }

    public Location findRandom(int x, int y, int width, int height) {
        if (this.geometry.isPeriodic()) {
            int xCoor = this.randomInRange(x, x + width - 1);
            if (xCoor < 0) {
                xCoor += this.getXSize();
            } else if (xCoor >= this.getXSize()) {
                xCoor -= this.getXSize();
            }
            int yCoor = this.randomInRange(y, y + height - 1);
            if (yCoor < 0) {
                yCoor += this.getYSize();
            } else if (yCoor >= this.getYSize()) {
                yCoor -= this.getYSize();
            }
            return this.cells[xCoor][yCoor];
        }
        if (x < 0) {
            x = 0;
        }
        if ((width = x + width - 1) >= this.getXSize()) {
            width = this.getXSize() - 1;
        }
        if (y < 0) {
            y = 0;
        }
        if ((height = y + height - 1) >= this.getYSize()) {
            height = this.getYSize() - 1;
        }
        return this.cells[this.randomInRange(x, width)][this.randomInRange(y, height)];
    }

    public final Location findRandomRelative(Node cell, int x, int y, int width, int height) {
        Coordinate2DDiscrete coor = (Coordinate2DDiscrete)cell.getCoordinate();
        return this.findRandom(cell, coor.getXValue() + x, coor.getYValue() + y, coor.getXValue() + width, coor.getXValue() + height);
    }

    public final Location findRandom(Node cell, int x, int y, int width, int height) {
        Location randomCell;
        while (cell == (randomCell = this.findRandom(x, y, width, height))) {
        }
        return randomCell;
    }

    public Node findRandomUnoccupied(int x, int y, int width, int height) {
        int i = 0;
        while (i < 10) {
            Node cell = (Node)this.findRandom(x, y, width, height);
            if (cell.isAvailable()) {
                return cell;
            }
            ++i;
        }
        List available = this.findAvailable();
        if (available.size() > 0) {
            return (Node)available.get(this.randomToLimit(available.size()));
        }
        return null;
    }

    public Coordinate findRandomCoordinate() {
        return new Coordinate2DDiscrete(this.randomToLimit(this.cells.length), this.randomToLimit(this.cells[0].length));
    }

    public boolean isValid(CoordinateDiscrete coordinate) {
        return this.isValid(coordinate.getValueAtDimension(1), coordinate.getValueAtDimension(2));
    }

    public Location findRelative(Location location, Coordinate coordinate) {
        int ry;
        Coordinate2DDiscrete origin = (Coordinate2DDiscrete)location.getCoordinate();
        Coordinate2DDiscrete delta = (Coordinate2DDiscrete)coordinate;
        int rx = origin.getXValue() + delta.getXValue();
        if (this.isValid(rx, ry = origin.getYValue() + delta.getYValue())) {
            return this.get(rx, ry);
        }
        return null;
    }

    public Location get(Coordinate coordinate) {
        return this.cells[((Coordinate2DDiscrete)coordinate).getValueAtDimension(1)][((Coordinate2DDiscrete)coordinate).getValueAtDimension(2)];
    }

    public void set(Coordinate coordinate, Location cell) {
        this.cells[((Coordinate2DDiscrete)coordinate).getXValue()][((Coordinate2DDiscrete)coordinate).getYValue()] = (Node)cell;
    }

    public void set(int xPosition, int yPosition, Location cell) {
        this.cells[xPosition][yPosition] = (Node)cell;
    }

    public boolean isValid(int xPosition, int yPosition) {
        return xPosition >= 0 && xPosition < this.cells.length && yPosition >= 0 && this.cells.length > 0 && yPosition < this.cells[0].length;
    }

    public Node get(int xPosition, int yPosition) {
        return this.cells[xPosition][yPosition];
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException("Arrays are immutable.");
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException("Arrays are immutable.");
    }

    public void clear() {
        throw new UnsupportedOperationException("Arrays are immutable.");
    }

    public boolean contains(Object o) {
        Iterator iterator = this.collection.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(o)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection c) {
        Iterator e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.getSize() != 0;
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Arrays are immutable.");
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException("Arrays are immutable.");
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException("Arrays are immutable.");
    }

    public int size() {
        return this.getSize();
    }

    public Object[] toArray() {
        if (this.agents == null) {
            this.agents = new Node[this.getSize()];
            int indexLocations = 0;
            int x = 0;
            while (x < this.cells.length) {
                System.arraycopy(this.cells[x], 0, this.agents, indexLocations, this.cells[0].length);
                indexLocations += this.cells[0].length;
                ++x;
            }
        }
        return this.agents;
    }

    public List toList() {
        return Arrays.asList(this.toArray());
    }

    public Object[] toArray(Object[] a) {
        a = (Object[])java.lang.reflect.Array.newInstance(a.getClass().getComponentType(), this.getSize());
        int indexLocations = 0;
        int x = 0;
        while (x < this.cells.length) {
            System.arraycopy(this.cells[x], 0, a, indexLocations, this.cells[0].length);
            indexLocations += this.cells[0].length;
            ++x;
        }
        return a;
    }

    public boolean isNearnessLineOfSight() {
        return this.nearnessLineOfSight;
    }

    public void setNearnessLineOfSight(boolean nearnessLineOfSight) {
        this.nearnessLineOfSight = nearnessLineOfSight;
    }

    protected void randomizeRank(int rank) {
        int j = Array2D.relativeCoordinatesRankLengths[rank] - 1;
        while (j > 0) {
            int k = this.randomInRange(0, j);
            if (k != j) {
                int[] swapCoordinate = this.relativeCoordinates[rank][j];
                this.relativeCoordinates[rank][j] = this.relativeCoordinates[rank][k];
                this.relativeCoordinates[rank][k] = swapCoordinate;
            }
            --j;
        }
    }

    public List findWithinMoore(Coordinate origin, boolean includeSelf, double distanceDouble) {
        int distance = (int)distanceDouble;
        if (this.getGeometry().isPeriodic()) {
            int xMid = ((Coordinate2DDiscrete)origin).getXValue();
            int yMid = ((Coordinate2DDiscrete)origin).getYValue();
            int xExtent = ((Coordinate2DDiscrete)this.getExtent()).getXValue();
            int yExtent = ((Coordinate2DDiscrete)this.getExtent()).getYValue();
            int xMin = xMid - distance;
            int yMin = yMid - distance;
            int xMax = xMid + distance;
            int yMax = yMid + distance;
            if (distance * 2 + 1 > xExtent) {
                xMin = xMid - xExtent / 2;
                xMax = xMin + xExtent - 1;
            }
            if (distance * 2 + 1 > yExtent) {
                yMin = yMid - yExtent / 2;
                yMax = yMin + yExtent - 1;
            }
            int xSpan = xMax - xMin + 1;
            int ySpan = yMax - yMin + 1;
            Node[] cellsNear = new Node[xSpan * ySpan - (includeSelf ? 0 : 1)];
            int xSourcePos = xMin;
            int xOffset = 0;
            if (xMin < 0) {
                xSourcePos += xExtent;
            }
            int xPos = xMin;
            while (xPos <= xMax) {
                if (xSourcePos >= xExtent) {
                    xSourcePos -= xExtent;
                }
                if (includeSelf || xPos != xMid) {
                    if (yMin < 0) {
                        System.arraycopy(this.cells[xSourcePos], yExtent + yMin, cellsNear, xOffset, -yMin);
                        System.arraycopy(this.cells[xSourcePos], 0, cellsNear, xOffset - yMin, yMax + 1);
                    } else if (yMax >= yExtent) {
                        System.arraycopy(this.cells[xSourcePos], yMin, cellsNear, xOffset, yExtent - yMin);
                        System.arraycopy(this.cells[xSourcePos], 0, cellsNear, xOffset + yExtent - yMin, yMax - yExtent + 1);
                    } else {
                        System.arraycopy(this.cells[xSourcePos], yMin, cellsNear, xOffset, ySpan);
                    }
                } else if (yMin < 0) {
                    System.arraycopy(this.cells[xSourcePos], yExtent + yMin, cellsNear, xOffset, -yMin);
                    System.arraycopy(this.cells[xSourcePos], 0, cellsNear, xOffset - yMin, yMid);
                    System.arraycopy(this.cells[xSourcePos], yMid + 1, cellsNear, --xOffset + yMid - yMin + 1, yMax - yMid);
                } else if (yMax >= yExtent) {
                    System.arraycopy(this.cells[xSourcePos], yMin, cellsNear, xOffset, yMid - yMin);
                    System.arraycopy(this.cells[xSourcePos], yMid + 1, cellsNear, --xOffset + yMid - yMin + 1, yExtent - yMid - 1);
                    System.arraycopy(this.cells[xSourcePos], 0, cellsNear, xOffset + ySpan - (yMax - yExtent + 1), yMax - yExtent + 1);
                } else if (yMin < yMax) {
                    System.arraycopy(this.cells[xSourcePos], yMin, cellsNear, xOffset, yMid - yMin);
                    System.arraycopy(this.cells[xSourcePos], yMid + 1, cellsNear, --xOffset + (yMid - yMin) + 1, yMax - yMid);
                } else {
                    --xOffset;
                }
                xOffset += ySpan;
                ++xSourcePos;
                ++xPos;
            }
            return Arrays.asList(cellsNear);
        }
        int xMid = ((Coordinate2DDiscrete)origin).getXValue();
        int yMid = ((Coordinate2DDiscrete)origin).getYValue();
        int xExtent = ((Coordinate2DDiscrete)this.getExtent()).getXValue();
        int yExtent = ((Coordinate2DDiscrete)this.getExtent()).getYValue();
        int xMin = Math.max(xMid - distance, 0);
        int yMin = Math.max(yMid - distance, 0);
        int xMax = Math.min(xMid + distance, xExtent - 1);
        int yMax = Math.min(yMid + distance, yExtent - 1);
        int xSpan = xMax - xMin + 1;
        int ySpan = yMax - yMin + 1;
        Node[] cellsNear = new Node[xSpan * ySpan - (includeSelf ? 0 : 1)];
        int xOffset = 0;
        int xPos = xMin;
        while (xPos <= xMax) {
            if (includeSelf || xPos != xMid) {
                System.arraycopy(this.cells[xPos], yMin, cellsNear, xOffset, ySpan);
            } else {
                if (yMin != yMax) {
                    System.arraycopy(this.cells[xPos], yMin, cellsNear, xOffset, yMid - yMin);
                    System.arraycopy(this.cells[xPos], yMid + 1, cellsNear, xOffset + yMid - yMin, yMax - yMid);
                }
                --xOffset;
            }
            xOffset += ySpan;
            ++xPos;
        }
        return Arrays.asList(cellsNear);
    }

    public List findWithinVonNeumann(Coordinate origin, boolean includeSelf, double dist) {
        int distance = (int)dist;
        if (!this.nearnessLineOfSight) {
            return this.findWithinVonNeumannMovement(origin, includeSelf, distance);
        }
        return this.findWithinVonNeumannLineOfSight(origin, includeSelf, distance);
    }

    public final Node[] getCellsNearVonNeumannMovement(Node origin, boolean includeSelf, int distance) {
        List list = this.findWithinVonNeumannMovement(origin.getCoordinate(), includeSelf, distance);
        Node[] cells = new Node[list.size()];
        return list.toArray(cells);
    }

    public List findWithinVonNeumannMovement(Coordinate origin, boolean includeSelf, double distance) {
        return this.findWithinDefault(origin, includeSelf, distance);
    }

    public final Node[] getCellsNearVonNeumannLineOfSight(Node origin, boolean includeSelf, int distance) {
        List list = this.findWithinVonNeumannLineOfSight(origin.getCoordinate(), includeSelf, distance);
        Node[] cells = new Node[list.size()];
        return list.toArray(cells);
    }

    public List findWithinVonNeumannLineOfSight(Coordinate origin, boolean includeSelf, double dist) {
        int distance = (int)dist;
        int maxDistance = distance * 2 + 1;
        if (this.getGeometry().isPeriodic()) {
            int ySpan;
            int xSpan;
            int yMax;
            int xMax;
            int yMin;
            if (maxDistance <= this.cells.length && maxDistance <= this.cells[0].length) {
                if (includeSelf) {
                    Node[] nearCells = new Node[4 * distance + 1];
                    int x = ((Coordinate2DDiscrete)origin).getXValue();
                    int y = ((Coordinate2DDiscrete)origin).getYValue();
                    nearCells[0] = this.cells[x][y];
                    int i = 1;
                    while (i <= distance) {
                        nearCells[i * 4 - 3] = x + i < this.cells.length ? this.cells[x + i][y] : this.cells[x + i - this.cells.length][y];
                        nearCells[i * 4 - 2] = x - i >= 0 ? this.cells[x - i][y] : this.cells[this.cells.length + (x - i)][y];
                        nearCells[i * 4 - 1] = y + i < this.cells[0].length ? this.cells[x][y + i] : this.cells[x][y + i - this.cells[0].length];
                        nearCells[i * 4] = y - i >= 0 ? this.cells[x][y - i] : this.cells[x][this.cells[0].length + (y - i)];
                        ++i;
                    }
                    return Arrays.asList(nearCells);
                }
                Node[] nearCells = new Node[4 * distance];
                int x = ((Coordinate2DDiscrete)origin).getXValue();
                int y = ((Coordinate2DDiscrete)origin).getYValue();
                int i = 1;
                while (i <= distance) {
                    nearCells[i * 4 - 4] = x + i < this.cells.length ? this.cells[x + i][y] : this.cells[x + i - this.cells.length][y];
                    nearCells[i * 4 - 3] = x - i >= 0 ? this.cells[x - i][y] : this.cells[this.cells.length + (x - i)][y];
                    nearCells[i * 4 - 2] = y + i < this.cells[0].length ? this.cells[x][y + i] : this.cells[x][y + i - this.cells[0].length];
                    nearCells[i * 4 - 1] = y - i >= 0 ? this.cells[x][y - i] : this.cells[x][this.cells[0].length + (y - i)];
                    ++i;
                }
                return Arrays.asList(nearCells);
            }
            int xExtent = ((Coordinate2DDiscrete)this.getExtent()).getXValue();
            int yExtent = ((Coordinate2DDiscrete)this.getExtent()).getYValue();
            int xMid = ((Coordinate2DDiscrete)origin).getXValue();
            int yMid = ((Coordinate2DDiscrete)origin).getYValue();
            int xMin = xMid - distance;
            if (xMin < 0) {
                xMin += xExtent;
            }
            if ((yMin = yMid - distance) < 0) {
                yMin += yExtent;
            }
            if ((xMax = Math.min(xMid + distance, xExtent - 1)) >= xExtent) {
                xMax -= xExtent;
            }
            if ((yMax = Math.min(yMid + distance, yExtent - 1)) >= yExtent) {
                yMax -= yExtent;
            }
            if ((xSpan = xMax - xMin + 1) < 0) {
                xSpan = xMax + (xExtent - xMin);
            }
            if ((ySpan = yMax - yMin + 1) < 0) {
                ySpan = yMax + (yExtent - yMin);
            }
            int size = 0;
            size = xSpan > maxDistance ? (size += xSpan) : (size += Math.min(maxDistance, this.cells.length));
            size = ySpan > maxDistance ? (size += ySpan - 1) : (size += Math.min(maxDistance, this.cells[0].length) - 1);
            if (!includeSelf) {
                --size;
            }
            Node[] nearCells = new Node[size];
            int index = 0;
            try {
                int yPos;
                int xPos;
                if (maxDistance > this.cells.length) {
                    xPos = 0;
                    while (xPos < xMid) {
                        nearCells[index] = this.cells[xPos][yMid];
                        ++index;
                        ++xPos;
                    }
                    if (includeSelf) {
                        nearCells[index] = this.cells[xMid][yMid];
                        ++index;
                    }
                    xPos = xMid + 1;
                    while (xPos < xExtent) {
                        nearCells[index] = this.cells[xPos][yMid];
                        ++index;
                        ++xPos;
                    }
                } else if (xMin < xMax) {
                    xPos = xMin;
                    while (xPos < xMid) {
                        nearCells[index] = this.cells[xPos][yMid];
                        ++index;
                        ++xPos;
                    }
                    if (includeSelf) {
                        nearCells[index] = this.cells[xMid][yMid];
                        ++index;
                    }
                    xPos = xMid + 1;
                    while (xPos <= xMax) {
                        nearCells[index] = this.cells[xPos][yMid];
                        ++index;
                        ++xPos;
                    }
                } else if (xMid < xMin) {
                    xPos = xMin;
                    while (xPos < xExtent) {
                        nearCells[index] = this.cells[xPos][yMid];
                        ++index;
                        ++xPos;
                    }
                    xPos = 0;
                    while (xPos < xMid) {
                        nearCells[index] = this.cells[xPos][yMid];
                        ++index;
                        ++xPos;
                    }
                    if (includeSelf) {
                        nearCells[index] = this.cells[xMid][yMid];
                        ++index;
                    }
                    xPos = xMid + 1;
                    while (xPos <= xMax) {
                        nearCells[index] = this.cells[xPos][yMid];
                        ++index;
                        ++xPos;
                    }
                } else {
                    xPos = xMin;
                    while (xPos < xMid) {
                        nearCells[index] = this.cells[xPos][yMid];
                        ++index;
                        ++xPos;
                    }
                    if (includeSelf) {
                        nearCells[index] = this.cells[xMid][yMid];
                        ++index;
                    }
                    xPos = xMid + 1;
                    while (xPos < xExtent) {
                        nearCells[index] = this.cells[xPos][yMid];
                        ++index;
                        ++xPos;
                    }
                    xPos = 0;
                    while (xPos <= xMax) {
                        nearCells[index] = this.cells[xPos][yMid];
                        ++index;
                        ++xPos;
                    }
                }
                if (maxDistance > this.cells[0].length) {
                    yPos = 0;
                    while (yPos < yMid) {
                        nearCells[index] = this.cells[xMid][yPos];
                        ++index;
                        ++yPos;
                    }
                    yPos = yMid + 1;
                    while (yPos < yExtent) {
                        nearCells[index] = this.cells[xMid][yPos];
                        ++index;
                        ++yPos;
                    }
                } else if (yMin < yMax) {
                    yPos = yMin;
                    while (yPos < yMid) {
                        nearCells[index] = this.cells[xMid][yPos];
                        ++index;
                        ++yPos;
                    }
                    yPos = yMid + 1;
                    while (yPos <= yMax) {
                        nearCells[index] = this.cells[xMid][yPos];
                        ++index;
                        ++yPos;
                    }
                } else if (yMid < yMin) {
                    yPos = yMin;
                    while (yPos < yExtent) {
                        nearCells[index] = this.cells[xMid][yPos];
                        ++index;
                        ++yPos;
                    }
                    yPos = 0;
                    while (yPos < yMid) {
                        nearCells[index] = this.cells[xMid][yPos];
                        ++index;
                        ++yPos;
                    }
                    yPos = yMid + 1;
                    while (yPos <= yMax) {
                        nearCells[index] = this.cells[xMid][yPos];
                        ++index;
                        ++yPos;
                    }
                } else {
                    yPos = yMin;
                    while (yPos < yMid) {
                        nearCells[index] = this.cells[xMid][yPos];
                        ++index;
                        ++yPos;
                    }
                    yPos = yMid + 1;
                    while (yPos < yExtent) {
                        nearCells[index] = this.cells[xMid][yPos];
                        ++index;
                        ++yPos;
                    }
                    yPos = 0;
                    while (yPos <= yMax) {
                        nearCells[index] = this.cells[xMid][yPos];
                        ++index;
                        ++yPos;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.println("xMin = " + xMin);
                System.out.println("xMid = " + xMid);
                System.out.println("xMax = " + xMax);
                System.out.println("xSpan = " + xSpan);
                System.out.println("xExtent = " + xExtent);
                System.out.println("cells = " + this.cells.length);
                System.out.println("yMin = " + yMin);
                System.out.println("yMid = " + yMid);
                System.out.println("yMax = " + yMax);
                System.out.println("ySpan = " + ySpan);
                System.out.println("yEytent = " + yExtent);
                System.out.println("cells[0] = " + this.cells[0].length);
                System.out.println("nearCells = " + nearCells.length);
                throw e;
            }
            return Arrays.asList(nearCells);
        }
        int xExtent = ((Coordinate2DDiscrete)this.getExtent()).getXValue();
        int yExtent = ((Coordinate2DDiscrete)this.getExtent()).getYValue();
        int xMid = ((Coordinate2DDiscrete)origin).getXValue();
        int yMid = ((Coordinate2DDiscrete)origin).getYValue();
        int xMin = Math.max(xMid - distance, 0);
        int yMin = Math.max(yMid - distance, 0);
        int xMax = Math.min(xMid + distance, xExtent - 1);
        int yMax = Math.min(yMid + distance, yExtent - 1);
        int xSpan = xMax - xMin + 1;
        int ySpan = yMax - yMin + 1;
        Node[] nearCells = new Node[xSpan + ySpan - (includeSelf ? 1 : 2)];
        if (includeSelf) {
            System.arraycopy(this.cells[xMid], yMin, nearCells, 0, yMax - yMin);
            int xPos = xMin;
            while (xPos < xMid) {
                nearCells[xSpan + xPos - xMin] = this.cells[xPos][yMid];
                ++xPos;
            }
            xPos = xMid + 1;
            while (xPos <= xMax) {
                nearCells[xSpan + xPos - xMin - 1] = this.cells[xPos][yMid];
                ++xPos;
            }
        } else {
            System.arraycopy(this.cells[xMid], yMin, nearCells, 0, yMid - yMin);
            System.arraycopy(this.cells[xMid], yMid + 1, nearCells, yMid - yMin, yMax - yMid);
            int xPos = xMin;
            while (xPos < xMid) {
                nearCells[ySpan + xPos - xMin - 1] = this.cells[xPos][yMid];
                ++xPos;
            }
            xPos = xMid + 1;
            while (xPos <= xMax) {
                nearCells[ySpan + xPos - xMin - 2] = this.cells[xPos][yMid];
                ++xPos;
            }
        }
        return Arrays.asList(nearCells);
    }

    public List findWithinEuclidian(Coordinate origin, boolean includeSelf, double dist) {
        int distance = (int)dist;
        if (this.getGeometry().isPeriodic()) {
            if ((double)distance <= Array2D.relativeCoordinatesRankDistance[this.relativeCoordinates.length - 1]) {
                int maxRank = 0;
                boolean lastRankReached = false;
                while (!lastRankReached) {
                    if (Array2D.relativeCoordinatesRankDistance[maxRank + 1] > (double)distance) {
                        lastRankReached = true;
                        continue;
                    }
                    ++maxRank;
                }
                int index = 0;
                int xO = ((Coordinate2DDiscrete)origin).getXValue();
                int yO = ((Coordinate2DDiscrete)origin).getYValue();
                Node[] nearCells = new Node[Array2D.sumOfCoordinatesWithinRank[maxRank + (includeSelf ? 1 : 0)]];
                int rank = includeSelf ? 0 : 1;
                while (rank < maxRank) {
                    int place = 0;
                    while (place < Array2D.relativeCoordinatesRankLengths[rank]) {
                        int x = xO + this.relativeCoordinates[rank][place][0];
                        if (x < 0) {
                            x += this.cells.length;
                        } else if (x >= this.cells.length) {
                            x -= this.cells.length;
                        }
                        int y = yO + this.relativeCoordinates[rank][place][1];
                        if (y < 0) {
                            y += this.cells[0].length;
                        } else if (y >= this.cells[0].length) {
                            y -= this.cells[0].length;
                        }
                        nearCells[index] = this.cells[x][y];
                        ++index;
                        ++place;
                    }
                    ++rank;
                }
                ArrayList<Node> found = new ArrayList<Node>();
                int i = 0;
                while (i < nearCells.length) {
                    found.add(nearCells[i]);
                    ++i;
                }
                return found;
            }
            return this.findWithinDefault(origin, includeSelf, distance);
        }
        return this.findWithinDefault(origin, includeSelf, distance);
    }

    public Node findCellToward(Node originCell, Node targetCell) {
        if (originCell == targetCell) {
            return originCell;
        }
        int ox = ((Coordinate2DDiscrete)originCell.getCoordinate()).getXValue();
        int oy = ((Coordinate2DDiscrete)originCell.getCoordinate()).getYValue();
        int tx = ((Coordinate2DDiscrete)targetCell.getCoordinate()).getXValue();
        int ty = ((Coordinate2DDiscrete)targetCell.getCoordinate()).getYValue();
        if (!this.getGeometry().isPeriodic()) {
            if (ox > tx) {
                --ox;
            } else if (ox < tx) {
                ++ox;
            }
            if (oy > ty) {
                --oy;
            } else if (oy < ty) {
                ++oy;
            }
        } else {
            int ex = this.getXSize();
            int ey = this.getYSize();
            if (ox > tx) {
                ox = ox - tx < tx + (ex - ox) ? --ox : ++ox;
            } else if (ox < tx) {
                ox = tx - ox < ox + (ex - tx) ? ++ox : --ox;
            }
            if (oy > ty) {
                oy = oy - ty < ty + (ey - oy) ? --oy : ++oy;
            } else if (oy < ty) {
                oy = ty - oy < oy + (ey - ty) ? ++oy : --oy;
            }
            if (ox >= ex) {
                ox = 0;
            } else if (ox < 0) {
                ox = ex - 1;
            }
            if (oy >= ey) {
                oy = 0;
            } else if (oy < 0) {
                oy = ey - 1;
            }
        }
        return this.get(ox, oy);
    }

    public Node findCellAway(Node originCell, Node targetCell) {
        if (originCell == targetCell) {
            return originCell.findRandomNeighbor();
        }
        int ox = ((Coordinate2DDiscrete)originCell.getCoordinate()).getXValue();
        int oy = ((Coordinate2DDiscrete)originCell.getCoordinate()).getYValue();
        int tx = ((Coordinate2DDiscrete)targetCell.getCoordinate()).getXValue();
        int ty = ((Coordinate2DDiscrete)targetCell.getCoordinate()).getYValue();
        int ex = this.getXSize();
        int ey = this.getYSize();
        int dx = tx - ox;
        int dy = ty - oy;
        if (this.getGeometry().isPeriodic()) {
            int rx = ex / 2;
            int ry = ey / 2;
            if (dx > 0) {
                ox = dx < rx - 1 ? (ox > 0 ? --ox : ex - 1) : (ox < ex - 1 ? ++ox : 0);
            } else if (dx < 0) {
                ox = dx > -rx - 1 ? (ox < ex - 1 ? ++ox : 0) : (ox > 0 ? --ox : ex - 1);
            }
            if (dy > 0) {
                oy = dy < ry - 1 ? (oy > 0 ? --oy : ey - 1) : (oy < ey - 1 ? ++oy : 0);
            } else if (dy < 0) {
                oy = dy > -ry - 1 ? (oy < ey - 1 ? ++oy : 0) : (oy > 0 ? --oy : ey - 1);
            }
        } else {
            if (dx > 0) {
                if (ox > 0) {
                    --ox;
                }
            } else if (dx < 0 && ox < ex - 1) {
                ++ox;
            }
            if (dy > 0) {
                if (oy > 0) {
                    --oy;
                }
            } else if (dy < 0 && oy < ey - 1) {
                ++oy;
            }
        }
        Node dCell = this.get(ox, oy);
        if (dCell.isAvailable()) {
            return dCell;
        }
        if (this.randomIs()) {
            dCell = this.get(((Coordinate2DDiscrete)originCell.getCoordinate()).getXValue(), oy);
            if (dCell.isAvailable()) {
                return dCell;
            }
            dCell = this.get(ox, ((Coordinate2DDiscrete)originCell.getCoordinate()).getYValue());
            if (dCell.isAvailable()) {
                return dCell;
            }
        } else {
            dCell = this.get(ox, ((Coordinate2DDiscrete)originCell.getCoordinate()).getYValue());
            if (dCell.isAvailable()) {
                return dCell;
            }
            dCell = this.get(((Coordinate2DDiscrete)originCell.getCoordinate()).getXValue(), oy);
            if (dCell.isAvailable()) {
                return dCell;
            }
        }
        return originCell;
    }

    private class Array2DIterator
    implements ResetableIterator,
    Serializable {
        private static final long serialVersionUID = 1L;
        int x = 0;
        int y = 0;

        private Array2DIterator() {
        }

        public void first() {
            this.x = 0;
            this.y = 0;
        }

        public boolean hasNext() {
            return this.x < Array2DBase.this.cells.length - 1 || this.y < Array2DBase.this.cells[0].length;
        }

        public Object next() {
            if (this.y >= Array2DBase.this.cells[0].length) {
                ++this.x;
                this.y = 0;
            }
            return Array2DBase.this.cells[this.x][this.y++];
        }

        public void remove() {
            throw new UnsupportedOperationException("Can't remove an object from a immutable space.");
        }

        /* synthetic */ Array2DIterator(Array2DIterator array2DIterator, Array2DIterator array2DIterator2) {
            this();
        }
    }

    private class Array2DRandomIterator
    implements RandomIterator {
        private int i = -1;
        private int[] iterOrder;
        private final int size;

        public Array2DRandomIterator() {
            this.size = Array2DBase.this.getSize();
            this.iterOrder = Array2DBase.createOrder(Array2DBase.this.getSize());
            this.randomize();
        }

        public void first() {
            this.i = -1;
        }

        public boolean hasNext() {
            return this.i < this.size - 1;
        }

        public Object next() {
            ++this.i;
            return Array2DBase.this.cells[this.iterOrder[this.i] / Array2DBase.this.cells[0].length][this.iterOrder[this.i] % Array2DBase.this.cells[0].length];
        }

        public void remove() {
            throw new UnsupportedOperationException("Can't remove an object from a immutable space.");
        }

        public void randomize() {
            this.first();
            this.iterOrder = Array2DBase.randomizeOrder(Array2DBase.this.order, Array2DBase.this.getRandom());
        }
    }

    private class Array2DSubIterator
    extends Array2DIterator {
        private static final long serialVersionUID = 1L;
        int start;
        int limit;
        int xlimit;
        int ylimit;

        public Array2DSubIterator(int start, int limit) {
            this.start = start;
            this.limit = limit;
            this.first();
            this.xlimit = limit / Array2DBase.this.cells[0].length;
            this.ylimit = limit % Array2DBase.this.cells[0].length;
            if (this.ylimit == 0) {
                this.ylimit = Array2DBase.this.cells[0].length;
            } else {
                ++this.xlimit;
            }
        }

        public void first() {
            this.x = this.start / Array2DBase.this.cells[0].length;
            this.y = this.start % Array2DBase.this.cells[0].length;
        }

        public boolean hasNext() {
            return this.x < this.xlimit - 1 || this.y < this.ylimit;
        }

        public Object next() {
            if (this.y >= Array2DBase.this.cells[0].length) {
                ++this.x;
                if (this.x < this.xlimit) {
                    this.y = 0;
                }
            }
            return Array2DBase.this.cells[this.x][this.y++];
        }

        public void remove() {
            throw new UnsupportedOperationException("Can't remove an object from a immutable space.");
        }
    }
}

