/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.engine;

import org.ascape.model.Agent;
import org.ascape.model.Scape;
import org.ascape.model.engine.AgentSelector;
import org.ascape.model.engine.IncrementalExecutionStrategy;

public class RandomAgentSelector
implements AgentSelector {
    private IncrementalExecutionStrategy strategy;
    private Scape scape;
    private int iterationCount;
    private int iteration;

    public RandomAgentSelector(IncrementalExecutionStrategy strategy, int iterationCount) {
        this.setStrategy(strategy);
        this.iterationCount = iterationCount;
    }

    public boolean hasMoreAgents() {
        return this.iteration < this.iterationCount;
    }

    public Agent nextAgent() {
        ++this.iteration;
        return this.scape.findRandom();
    }

    public void reset() {
        this.iteration = 0;
    }

    public IncrementalExecutionStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(IncrementalExecutionStrategy strategy) {
        this.strategy = strategy;
        this.scape = strategy.getScape();
    }

    public Object clone() {
        try {
            AgentSelector clone = (AgentSelector)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }
}

