/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  subrules_phrase.lex
Dates:		  3 Jun 2004
Purpose:	  parse subrule definitions
Output:       T_subrules_phrase
              assorted errors
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |subrules_phrase| Thread.\fbreak
Parse subrule definitions.
@/
fsm	
(fsm-id "subrules_phrase.lex"
,fsm-filename subrules_phrase
,fsm-namespace NS_subrules_phrase
,fsm-class Csubrules_phrase{
  user-prefix-declaration
#include "lint_balls.h"
#include "eol.h"
#include "c_comments.h"
#include "identifier.h"
#include "c_string.h"
#include "subrule_def.h"
  ***
  user-declaration
    public:
    T_subrules_phrase* subrules_phrase_;
    int subrule_no_;
  ***
  op
    if(subrules_phrase_ != 0){
      delete subrules_phrase_;
      subrules_phrase_ = 0;
    }
    subrules_phrase_ = new T_subrules_phrase;
    subrules_phrase_->set_rc(*parser__->start_token__,__FILE__,__LINE__);
    AST* t = new AST(*subrules_phrase_);
    subrules_phrase_->phrase_tree(t);
    subrule_no_=0;
  ***
  constructor
      subrules_phrase_ = 0;
  ***
}
,fsm-version "1.0",fsm-date "24 mar 2004",fsm-debug "false"
,fsm-comments "Parse subrules: into the valley of ...")
parallel-parser	
(	
  parallel-thread-function
    TH_subrules_phrase
  ***
  parallel-la-boundary
    eolr - |||
  ***
)
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rsubrules_phrase  (){
  -> Rsubrule_defs {
    op
      Csubrules_phrase* fsm = (Csubrules_phrase*)rule_info__.parser__->fsm_tbl__;
      RSVP(fsm->subrules_phrase_);
      fsm->subrules_phrase_ = 0;
    ***
    }	
}


Rsubrule_defs  (){
  ->  Rsubrule_def Rlint
  ->  Rsubrule_defs Rsubrule_def1 Rlint
}

Rsubrule_def  (){
  ->  ||| "subrule-def" NS_subrule_def::TH_subrule_def {
      op 
        Csubrules_phrase* fsm = (Csubrules_phrase*)rule_info__.parser__->fsm_tbl__;
        ++fsm->subrule_no_;
        sf->p2__->subrule_no_of_rule(fsm->subrule_no_);
        fsm->subrules_phrase_->add_sr_to_subrules(sf->p2__);
      ***
      }   
  ->  ||| |?| NULL {
      op
        RSVP(sf->p2__);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_sub_rule_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rsubrule_def1  (){
  ->  ||| "subrule-def" NS_subrule_def::TH_subrule_def {
      op 
        Csubrules_phrase* fsm = (Csubrules_phrase*)rule_info__.parser__->fsm_tbl__;
        ++fsm->subrule_no_;
        sf->p2__->subrule_no_of_rule(fsm->subrule_no_);
        fsm->subrules_phrase_->add_sr_to_subrules(sf->p2__);
      ***
      }   
  -> ||| |?| NULL {
      op
        RSVP(sf->p2__);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rlint  (){
  ->  ||| lint NS_lint_balls::TH_lint_balls
  -> 
}

}// end of rules
