/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  rc_phrase.lex
Dates:		  24 May 2004
Purpose:	  raw characters alphabet
Grammar being parsed:
	raw-characters       
	(file-name yacco2_rc
	,name-space NS_yacco2_rc)  
	{ 
		1+ terminal definitions where def is
		 terminal-key [AD AB attributes](sym-class C++ name)
		      or
		 terminal-key [AD AB attributes]
		 (sym-class C++ name {C++ directives block} ) 
	}
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |rc_phrase| grammar.\fbreak
Dispatcher to parse the raw character terminal symbols.
@/
fsm	
(fsm-id "rc_phrase.lex"
,fsm-filename rc_phrase
,fsm-namespace NS_rc_phrase
,fsm-class Crc_phrase{
  user-prefix-declaration
    using namespace NS_yacco2_terminals;
    #include "rc_phrase_th.h"
   #include "o2_externs.h"
  ***
  user-declaration
   public: yacco2::AST* cweb_marker__;
  ***
  op
   if(CWEB_MARKER != 0){
     cweb_marker__ = CWEB_MARKER;
     CWEB_MARKER=0;
   }
  ***
  constructor
   cweb_marker__ = 0;
  ***
}
,fsm-version "1.0",fsm-date "24 May 2004",fsm-debug "false"
,fsm-comments "Dispatcher to parse raw character vocabulary.")
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"
rules{
Rrc_phrase (){
  -> Rphrase
}

Rphrase (){
  ->  ||| "rc-phrase" 
      NS_rc_phrase_th::TH_rc_phrase_th {
  op
    ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
  ***
  } 
  ->  ||| |?| NULL { // thread has stop parsing with RSVP error
  op
    ADD_TOKEN_TO_ERROR_QUEUE(*sf->p2__);
  ***
  }
  ->  |?| { // error due to no first set to start thread {
  op
    CAbs_lr1_sym* sym = new Err_no_open_parenthesis;
    sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
    ADD_TOKEN_TO_ERROR_QUEUE(*sym);
  ***
  }
}
}// end of rules
